/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.compiler.support;

import griffon.plugins.ratpack.GriffonRatpackApp;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.griffon.compiler.GriffonCompilerContext;
import org.codehaus.griffon.compiler.SourceUnitCollector;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTInjector;
import org.codehaus.griffon.compiler.support.GriffonArtifactASTTransformation;
import org.codehaus.griffon.runtime.ratpack.AbstractGriffonRatpackApp;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class GriffonRatpackAppASTTransformation
extends GriffonArtifactASTTransformation {
    private static final Logger LOG = LoggerFactory.getLogger(GriffonRatpackAppASTTransformation.class);
    private static final String ARTIFACT_PATH = "ratpack";
    private static final ClassNode GRIFFON_RATPACK_APP_CLASS = ClassHelper.makeWithoutCaching(GriffonRatpackApp.class);
    private static final ClassNode ABSTRACT_GRIFFON_RATPACK_APP_CLASS = ClassHelper.makeWithoutCaching(AbstractGriffonRatpackApp.class);

    public static boolean isRatpackAppArtifact(ClassNode classNode, SourceUnit source) {
        if (classNode == null || source == null) {
            return false;
        }
        return ARTIFACT_PATH.equals(GriffonCompilerContext.getArtifactPath((SourceUnit)source)) && classNode.getName().endsWith("RatpackApp");
    }

    protected void transform(ClassNode classNode, SourceUnit source, String artifactPath) {
        if (!GriffonRatpackAppASTTransformation.isRatpackAppArtifact(classNode, source)) {
            return;
        }
        this.doTransform(classNode);
    }

    private void doTransform(ClassNode classNode) {
        ClassNode superClass = classNode.getSuperClass();
        if (ClassHelper.OBJECT_TYPE.equals((Object)superClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting " + ABSTRACT_GRIFFON_RATPACK_APP_CLASS.getName() + " as the superclass of " + classNode.getName());
            }
            classNode.setSuperClass(ABSTRACT_GRIFFON_RATPACK_APP_CLASS);
        } else if (!classNode.implementsInterface(GRIFFON_RATPACK_APP_CLASS)) {
            this.inject(classNode, superClass);
        }
    }

    private void inject(ClassNode classNode, ClassNode superClass) {
        SourceUnit superSource = SourceUnitCollector.getInstance().getSourceUnit(superClass);
        if (GriffonRatpackAppASTTransformation.isRatpackAppArtifact(superClass, superSource)) {
            return;
        }
        if (superSource == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + GRIFFON_RATPACK_APP_CLASS.getName() + " behavior to " + classNode.getName());
            }
            GriffonASTUtils.injectInterface((ClassNode)classNode, (ClassNode)GRIFFON_RATPACK_APP_CLASS);
            GriffonArtifactASTInjector injector = new GriffonArtifactASTInjector();
            injector.inject(classNode, ARTIFACT_PATH);
        } else {
            this.doTransform(superClass);
        }
    }
}

