/*
 * Decompiled with CFR 0.152.
 */
package com.trolltech.qt.designer;

import com.trolltech.qt.QSignalEmitter;
import com.trolltech.qt.core.QFile;
import com.trolltech.qt.core.QIODevice;
import com.trolltech.qt.core.QObject;
import com.trolltech.qt.core.QRect;
import com.trolltech.qt.core.QSize;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.designer.BoolPropertyHandler;
import com.trolltech.qt.designer.ColorPropertyHandler;
import com.trolltech.qt.designer.EnumPropertyHandler;
import com.trolltech.qt.designer.FontPropertyHandler;
import com.trolltech.qt.designer.IconsetPropertyHandler;
import com.trolltech.qt.designer.Line;
import com.trolltech.qt.designer.NumberPropertyHandler;
import com.trolltech.qt.designer.OrientationPropertyHandler;
import com.trolltech.qt.designer.PalettePropertyHandler;
import com.trolltech.qt.designer.PixmapPropertyHandler;
import com.trolltech.qt.designer.PointPropertyHandler;
import com.trolltech.qt.designer.PropertyHandler;
import com.trolltech.qt.designer.QUiLoaderException;
import com.trolltech.qt.designer.RectPropertyHandler;
import com.trolltech.qt.designer.SetPropertyHandler;
import com.trolltech.qt.designer.SizePolicyPropertyHandler;
import com.trolltech.qt.designer.SizePropertyHandler;
import com.trolltech.qt.designer.StringPropertyHandler;
import com.trolltech.qt.gui.QAction;
import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QBoxLayout;
import com.trolltech.qt.gui.QComboBox;
import com.trolltech.qt.gui.QContentsMargins;
import com.trolltech.qt.gui.QDockWidget;
import com.trolltech.qt.gui.QGridLayout;
import com.trolltech.qt.gui.QIcon;
import com.trolltech.qt.gui.QLabel;
import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QLayoutItem;
import com.trolltech.qt.gui.QLayoutItemInterface;
import com.trolltech.qt.gui.QListWidget;
import com.trolltech.qt.gui.QListWidgetItem;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QMenu;
import com.trolltech.qt.gui.QMenuBar;
import com.trolltech.qt.gui.QSizePolicy;
import com.trolltech.qt.gui.QSpacerItem;
import com.trolltech.qt.gui.QStatusBar;
import com.trolltech.qt.gui.QTabWidget;
import com.trolltech.qt.gui.QToolBar;
import com.trolltech.qt.gui.QWidget;
import com.trolltech.qt.xml.QDomDocument;
import com.trolltech.qt.xml.QDomElement;
import com.trolltech.qt.xml.QDomNode;
import com.trolltech.qt.xml.QDomNodeList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QUiLoader {
    private QIODevice inputDevice;
    private QWidget topParent;
    private QWidget uiWidget;
    private String xmlClassName = "";
    private int parseDepth;
    private Object parent;
    private Object object;
    private PropertyReceiver propertyReceiver;
    private HashMap<String, QWidget> widgetPool = new HashMap();
    private HashMap<String, QAction> actions = new HashMap();
    private HashMap<QLabel, String> buddies = new HashMap();
    private static HashSet<String> ignorableStrings;
    private static HashMap<String, PropertyHandler> typeHandlers;
    private static HashMap<String, PropertyHandler> propertyHandlers;

    public static QWidget load(QIODevice device) throws QUiLoaderException {
        return QUiLoader.load(device, null);
    }

    public static QWidget load(QIODevice device, QWidget parent) throws QUiLoaderException {
        QUiLoader loader = new QUiLoader(device, parent);
        loader.parse();
        return loader.widget();
    }

    private QUiLoader(QIODevice device, QWidget parent) {
        this.inputDevice = device;
        this.topParent = parent;
    }

    private void parse() throws QUiLoaderException {
        if (!this.inputDevice.isOpen() && !this.inputDevice.open(QIODevice.OpenModeFlag.ReadOnly)) {
            throw new QUiLoaderException("Unable to open iodevice: " + this.inputDevice);
        }
        QDomDocument doc = new QDomDocument();
        doc.setContent(this.inputDevice);
        this.object = this.topParent;
        this.parseChildren(doc, this.topParent);
        this.uiWidget = (QWidget)this.object;
        for (QAction qAction : this.actions.values()) {
            qAction.setParent(this.uiWidget);
        }
        for (Map.Entry entry : this.buddies.entrySet()) {
            QWidget buddy = this.widgetPool.get(entry.getValue());
            ((QLabel)entry.getKey()).setBuddy(buddy);
        }
    }

    private void parseChildren(QDomNode node, Object parent) throws QUiLoaderException {
        QDomNodeList children = node.childNodes();
        for (int i = 0; i < children.size(); ++i) {
            this.parent = parent;
            this.parse(children.at(i));
        }
    }

    private void parse(QDomNode domNode) throws QUiLoaderException {
        String name = domNode.nodeName();
        if (name.equals("ui")) {
            this.parseUiRoot(domNode);
        } else if (name.equals("widget")) {
            this.parseWidget(domNode);
        } else if (name.equals("layout")) {
            this.parseLayout(domNode);
        } else if (name.equals("property")) {
            this.parseProperty(domNode);
        } else if (name.equals("item")) {
            this.parseItem(domNode);
        } else if (name.equals("spacer")) {
            this.parseSpacer(domNode);
        } else if (name.equals("connections")) {
            this.parseConnections(domNode);
        } else if (name.equals("taborder")) {
            this.parseTabOrder(domNode);
        } else if (name.equals("tabstops")) {
            this.parseTabOrder(domNode);
        } else if (name.equals("addaction")) {
            this.parseAddAction(domNode);
        } else if (name.equals("attribute")) {
            this.parseAttribute(domNode);
        } else if (name.equals("action")) {
            this.parseAction(domNode);
        } else if (name.equals("class")) {
            this.parseClass(domNode);
        } else if (!ignorableStrings.contains(name)) {
            throw new QUiLoaderException("Unknown tag: " + name);
        }
    }

    private void parseUiRoot(QDomNode node) throws QUiLoaderException {
        QDomElement ui = node.toElement();
        String version = ui.attribute("version");
        if (!version.equals("4.0")) {
            throw new QUiLoaderException("Unsupported version: " + version + ", expected 4.0");
        }
        String language = ui.attribute("language");
        if (!language.equals("jambi")) {
            throw new QUiLoaderException("Unsupported language: '" + language + "', expected 'jambi'");
        }
        this.parseChildren(ui, this.topParent);
    }

    private void parseWidget(QDomNode node) throws QUiLoaderException {
        QDomElement widgetNode = node.toElement();
        QObject parent = (QObject)this.parent;
        String cls = widgetNode.attribute("class");
        String name = widgetNode.attribute("name");
        Class<? extends QObject> cl = this.loadClass(cls);
        QWidget widget = (QWidget)this.createInstance(cl, parent);
        if (widget instanceof QMenu) {
            this.actions.put(name, ((QMenu)widget).menuAction());
        }
        this.widgetPool.put(name, widget);
        widget.setObjectName(name);
        if (parent instanceof QMainWindow) {
            QMainWindow mainWindow = (QMainWindow)parent;
            if (name.equals("centralwidget")) {
                mainWindow.setCentralWidget(widget);
            } else if (name.equals("menubar")) {
                mainWindow.setMenuBar((QMenuBar)widget);
            } else if (name.equals("statusbar")) {
                mainWindow.setStatusBar((QStatusBar)widget);
            } else if (!(widget instanceof QToolBar) && !(widget instanceof QDockWidget)) {
                System.err.println("unhandled child of main window..." + widget + ", " + widget.objectName());
            }
        } else if (parent instanceof QTabWidget) {
            String title = widgetNode.namedItem("attribute").firstChild().firstChild().nodeValue();
            ((QTabWidget)parent).addTab(widget, title);
        } else if (parent instanceof QDockWidget) {
            ((QDockWidget)parent).setWidget(widget);
        }
        PropertyReceiver oldReceiver = this.swapPropertyReceiver(new QObjectPropertyReceiver(widget));
        this.parseChildren(node, widget);
        this.swapPropertyReceiver(oldReceiver);
        this.object = widget;
    }

    private static int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private void parseLayout(QDomNode node) throws QUiLoaderException {
        QDomElement layoutNode = node.toElement();
        Class<? extends QObject> cls = this.loadClass(layoutNode.attribute("class"));
        QLayout layout = null;
        try {
            layout = (QLayout)cls.newInstance();
        }
        catch (Exception e) {
            throw new QUiLoaderException("Failed to create layout: " + cls.getName(), e);
        }
        Object parent = this.parent;
        if (parent instanceof QWidget) {
            ((QWidget)parent).setLayout(layout);
        }
        PropertyReceiver oldReceiver = this.swapPropertyReceiver(new QObjectPropertyReceiver(layout));
        this.parseChildren(node, layout);
        this.swapPropertyReceiver(oldReceiver);
        this.object = layout;
    }

    private void parseItem(QDomNode node) throws QUiLoaderException {
        if (this.parent instanceof QLayout) {
            this.parseLayoutItem(node);
        } else if (this.parent instanceof QListWidget) {
            this.parseListWidgetItem(node);
        } else if (this.parent instanceof QComboBox) {
            this.parseComboBoxItem(node);
        } else {
            System.err.println("Unhandled 'item' for '" + this.parent + "'");
        }
    }

    private void parseComboBoxItem(QDomNode node) throws QUiLoaderException {
        ContentItemPropertyReceiver item = new ContentItemPropertyReceiver();
        PropertyReceiver oldReceiver = this.swapPropertyReceiver(item);
        this.parseChildren(node, this.parent);
        this.swapPropertyReceiver(oldReceiver);
        QComboBox box = (QComboBox)this.parent;
        box.addItem(item.icon, item.text);
    }

    private void parseLayoutItem(QDomNode node) throws QUiLoaderException {
        QDomElement itemNode = node.toElement();
        assert (this.parent instanceof QLayout);
        QLayout layout = (QLayout)this.parent;
        this.parseChildren(node, layout);
        Object child = this.object;
        if (layout instanceof QGridLayout) {
            int row = QUiLoader.parseInt(itemNode.attribute("row"), 0);
            int col = QUiLoader.parseInt(itemNode.attribute("column"), 0);
            int colspan = QUiLoader.parseInt(itemNode.attribute("colspan"), 1);
            int rowspan = QUiLoader.parseInt(itemNode.attribute("rowspan"), 1);
            QGridLayout grid = (QGridLayout)layout;
            if (child instanceof QWidget) {
                grid.addWidget((QWidget)child, row, col, rowspan, colspan);
            } else if (child instanceof QLayout) {
                grid.addLayout((QLayout)child, row, col, rowspan, colspan);
            } else if (child instanceof QLayoutItemInterface) {
                grid.addItem((QLayoutItemInterface)child, row, col, rowspan, colspan);
            }
        } else if (child instanceof QWidget) {
            layout.addWidget((QWidget)child);
        } else if (child instanceof QLayout) {
            ((QBoxLayout)layout).addLayout((QLayout)child);
        } else if (child instanceof QLayoutItem) {
            layout.addItem((QLayoutItem)child);
        }
    }

    private void parseListWidgetItem(QDomNode node) throws QUiLoaderException {
        ContentItemPropertyReceiver item = new ContentItemPropertyReceiver();
        PropertyReceiver oldReceiver = this.swapPropertyReceiver(item);
        this.parseChildren(node, this.parent);
        QListWidget listWidget = (QListWidget)this.parent;
        listWidget.addItem(item.listWidgetItem());
        this.swapPropertyReceiver(oldReceiver);
    }

    private void parseSpacer(QDomNode node) throws QUiLoaderException {
        PropertyReceiver old = this.swapPropertyReceiver(new SpacerPropertyReceiver());
        this.parseChildren(node, this.parent);
        this.object = ((SpacerPropertyReceiver)this.propertyReceiver).spacerItem();
        this.swapPropertyReceiver(old);
    }

    private void parseProperty(QDomNode node) throws QUiLoaderException {
        QDomElement e = node.toElement();
        String name = e.attribute("name");
        assert (!e.isNull());
        QDomElement val = e.firstChildElement();
        PropertyHandler handler = propertyHandlers.get(name);
        if (handler == null) {
            handler = typeHandlers.get(val.nodeName());
        }
        if (handler == null) {
            throw new QUiLoaderException("No handler for property " + name + ", of type: " + val.nodeName());
        }
        Object value = handler.create(val);
        this.propertyReceiver.setProperty(name, value);
    }

    private QObject createInstance(Class<? extends QObject> cl, QObject parent) throws QUiLoaderException {
        try {
            if (QWidget.class.isAssignableFrom(cl)) {
                if (parent instanceof QWidget) {
                    return cl.getConstructor(QWidget.class).newInstance((QWidget)parent);
                }
                return cl.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            if (QLayout.class.isAssignableFrom(cl)) {
                if (parent instanceof QWidget) {
                    Constructor<? extends QObject> ctor = cl.getConstructor(QWidget.class);
                    return ctor.newInstance(parent);
                }
                return (QLayout)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return cl.getConstructor(QObject.class).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new QUiLoaderException("Failed to create instance", e);
        }
    }

    private Class<? extends QObject> loadClass(String cls) throws QUiLoaderException {
        Class<QObject> cl;
        if (cls.equals("Line")) {
            return Line.class;
        }
        try {
            cl = Class.forName(cls).asSubclass(QObject.class);
        }
        catch (ClassNotFoundException e) {
            try {
                cl = Class.forName("com.trolltech.qt.gui." + cls).asSubclass(QObject.class);
            }
            catch (Exception ex) {
                throw new QUiLoaderException("Failed to load class", ex);
            }
        }
        catch (Exception e) {
            throw new QUiLoaderException("Failed to load class", e);
        }
        return cl;
    }

    private void setProperty(QObject o, String property, Object value) {
        try {
            if (property.equals("geometry") && o.isWidgetType() && ((QWidget)o).isWindow()) {
                QWidget window = (QWidget)o;
                QRect r = (QRect)value;
                if (r.x() == 0 && r.y() == 0) {
                    window.resize(r.width(), r.height());
                } else {
                    window.setGeometry(r);
                }
                return;
            }
            if (property.equals("shortcut") && o instanceof QAction && value instanceof String) {
                ((QAction)o).setShortcut((String)value);
                return;
            }
            if (property.endsWith("focusPolicy") && o instanceof QWidget && value instanceof Qt.FocusPolicy) {
                ((QWidget)o).setFocusPolicy((Qt.FocusPolicy)value);
                return;
            }
            if (property.equals("buddy") && o instanceof QLabel) {
                this.buddies.put((QLabel)o, (String)value);
                return;
            }
            if (property.equals("icon") && o instanceof QWidget && ((QWidget)o).isWindow()) {
                ((QWidget)o).setWindowIcon((QIcon)value);
                return;
            }
            if (property.endsWith("Margin") && o instanceof QLayout) {
                this.writeLayoutMargin((QLayout)o, property, value);
                return;
            }
            if (property.endsWith("Spacing") && o instanceof QGridLayout) {
                this.writeLayoutSpacing((QGridLayout)o, property, value);
                return;
            }
            if (value == null) {
                System.out.println("Null value for: " + property + ", " + value);
            }
            if (value != null) {
                o.setProperty(property, value);
            }
        }
        catch (Exception e) {
            System.err.println("setProperty failed: value=" + value + ", name=" + property + ", on=" + o);
            e.printStackTrace();
        }
    }

    private void writeLayoutMargin(QLayout l, String property, Object value) {
        int x = (Integer)value;
        QContentsMargins margins = l.getContentsMargins();
        if (property.equals("rightMargin")) {
            margins.right = x;
        } else if (property.equals("leftMargin")) {
            margins.left = x;
        } else if (property.equals("topMargin")) {
            margins.top = x;
        } else if (property.equals("bottomMargin")) {
            margins.bottom = x;
        }
        l.setContentsMargins(margins);
    }

    private void writeLayoutSpacing(QGridLayout o, String property, Object value) {
        if (property.equals("verticalSpacing")) {
            o.setVerticalSpacing((Integer)value);
        } else if (property.equals("horizontalSpacing")) {
            o.setHorizontalSpacing((Integer)value);
        }
    }

    private void parseConnections(QDomNode node) throws QUiLoaderException {
        QDomElement e = node.toElement();
        assert (!e.isNull());
        try {
            QDomElement el = e.firstChildElement();
            while (!el.isNull()) {
                if (el.nodeName().equals("connection")) {
                    int paren;
                    String senderName = el.namedItem("sender").firstChild().nodeValue();
                    String signalName = el.namedItem("signal").firstChild().nodeValue();
                    String receiverName = el.namedItem("receiver").firstChild().nodeValue();
                    String slotSignature = el.namedItem("slot").firstChild().nodeValue();
                    QObject sender = this.widgetPool.get(senderName);
                    if (sender == null) {
                        sender = this.actions.get(senderName);
                    }
                    if (sender == null) {
                        throw new QUiLoaderException("Unknown sender: '" + senderName + "'");
                    }
                    QObject receiver = this.widgetPool.get(receiverName);
                    if (receiver == null) {
                        throw new QUiLoaderException("Unknown sender: '" + receiverName + "'");
                    }
                    int lt = signalName.indexOf(60);
                    if (lt > 0) {
                        signalName = signalName.substring(0, lt);
                    }
                    if ((paren = signalName.indexOf(40)) > 0) {
                        signalName = signalName.substring(0, paren);
                    }
                    try {
                        QSignalEmitter.AbstractSignal signal = (QSignalEmitter.AbstractSignal)sender.getClass().getField(signalName).get(sender);
                        signal.connect(receiver, slotSignature);
                    }
                    catch (Exception ex) {
                        throw new QUiLoaderException("Connection failed: " + senderName + "." + signalName + " to " + receiverName + "." + slotSignature, ex);
                    }
                }
                el = el.nextSiblingElement();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseTabOrder(QDomNode node) {
        QDomElement e = node.toElement();
        if (e.isNull()) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        QDomElement el = e.firstChildElement();
        while (!el.isNull()) {
            assert (!el.isNull());
            if (el.nodeName().equals("tabstop")) {
                list.add(el.firstChild().nodeValue());
            }
            el = el.nextSiblingElement();
        }
        for (int i = 0; i < list.size() - 1; ++i) {
            QWidget w1 = this.widgetPool.get(list.get(i));
            QWidget w2 = this.widgetPool.get(list.get(i + 1));
            QWidget.setTabOrder(w1, w2);
        }
    }

    private void parseAddAction(QDomNode node) {
        QDomElement e = node.toElement();
        if (e.isNull()) {
            return;
        }
        String name = e.attribute("name");
        if (name.equals("separator")) {
            if (this.parent instanceof QMenu) {
                ((QMenu)this.parent).addSeparator();
            } else if (this.parent instanceof QToolBar) {
                ((QToolBar)this.parent).addSeparator();
            }
            return;
        }
        QAction action = this.existingAction(name);
        if (this.parent instanceof QWidget) {
            ((QWidget)this.parent).addAction(action);
        }
    }

    private QAction existingAction(String name) {
        QAction action = this.actions.get(name);
        if (action == null) {
            action = new QAction(null);
            action.setObjectName(name);
            this.actions.put(name, action);
        }
        return action;
    }

    private void parseAttribute(QDomNode node) throws QUiLoaderException {
        AttributeReceiver attr = new AttributeReceiver();
        PropertyReceiver defaultReceiver = this.swapPropertyReceiver(attr);
        this.parseProperty(node);
        this.swapPropertyReceiver(defaultReceiver);
    }

    private void parseAction(QDomNode node) throws QUiLoaderException {
        QDomElement e = node.toElement();
        if (e.isNull()) {
            return;
        }
        String name = e.attribute("name");
        QAction action = this.existingAction(name);
        QObjectPropertyReceiver rcv = new QObjectPropertyReceiver(action);
        PropertyReceiver old = this.swapPropertyReceiver(rcv);
        this.parseChildren(node, action);
        this.swapPropertyReceiver(old);
    }

    private void parseClass(QDomNode node) throws QUiLoaderException {
        QDomElement e = node.toElement();
        if (e.isNull()) {
            return;
        }
        QDomNode n = e.firstChild();
        if (!n.isNull()) {
            this.xmlClassName = n.nodeValue();
        }
    }

    private QWidget widget() {
        return this.uiWidget;
    }

    private Object swapObject(Object o) {
        Object x = this.object;
        this.object = o;
        return x;
    }

    private PropertyReceiver swapPropertyReceiver(PropertyReceiver recv) {
        PropertyReceiver r = this.propertyReceiver;
        this.propertyReceiver = recv;
        return r;
    }

    private QUiLoader self() {
        return this;
    }

    public static void main(String[] args) throws QUiLoaderException {
        QApplication.initialize(args);
        QFile file = new QFile(args[0]);
        long t1 = System.currentTimeMillis();
        QWidget w = QUiLoader.load(file);
        long t2 = System.currentTimeMillis();
        System.out.println("loading took: " + (t2 - t1));
        file.dispose();
        w.show();
        QApplication.exec();
    }

    static {
        typeHandlers = new HashMap();
        typeHandlers.put("cstring", new StringPropertyHandler());
        typeHandlers.put("rect", new RectPropertyHandler());
        typeHandlers.put("string", new StringPropertyHandler());
        typeHandlers.put("number", new NumberPropertyHandler());
        typeHandlers.put("sizepolicy", new SizePolicyPropertyHandler());
        typeHandlers.put("size", new SizePropertyHandler());
        typeHandlers.put("point", new PointPropertyHandler());
        typeHandlers.put("bool", new BoolPropertyHandler());
        typeHandlers.put("enum", new EnumPropertyHandler());
        typeHandlers.put("font", new FontPropertyHandler());
        typeHandlers.put("palette", new PalettePropertyHandler());
        typeHandlers.put("color", new ColorPropertyHandler());
        typeHandlers.put("pixmap", new PixmapPropertyHandler());
        typeHandlers.put("iconset", new IconsetPropertyHandler());
        typeHandlers.put("set", new SetPropertyHandler());
        propertyHandlers = new HashMap();
        propertyHandlers.put("orientation", new OrientationPropertyHandler());
        ignorableStrings = new HashSet();
        ignorableStrings.add("author");
        ignorableStrings.add("comment");
        ignorableStrings.add("customwidgets");
        ignorableStrings.add("exportmacro");
        ignorableStrings.add("pixmapfunction");
        ignorableStrings.add("resources");
    }

    private class AttributeReceiver
    implements PropertyReceiver {
        private AttributeReceiver() {
        }

        private QMainWindow mainWindow() {
            QWidget toplevel;
            QWidget qWidget = toplevel = QUiLoader.this.parent instanceof QWidget ? ((QWidget)QUiLoader.this.parent).window() : null;
            if (toplevel instanceof QMainWindow) {
                return (QMainWindow)toplevel;
            }
            return null;
        }

        public void setProperty(String name, Object value) {
            QMainWindow mw;
            if (name.equals("toolBarArea")) {
                QMainWindow mw2 = this.mainWindow();
                if (mw2 != null && QUiLoader.this.parent instanceof QToolBar) {
                    mw2.addToolBar(Qt.ToolBarArea.resolve((Integer)value), (QToolBar)QUiLoader.this.parent);
                }
            } else if (name.equals("dockWidgetArea") && (mw = this.mainWindow()) != null && QUiLoader.this.parent instanceof QDockWidget) {
                mw.addDockWidget(Qt.DockWidgetArea.resolve((Integer)value), (QDockWidget)QUiLoader.this.parent);
            }
        }
    }

    private class ContentItemPropertyReceiver
    implements PropertyReceiver {
        String text;
        QIcon icon;

        private ContentItemPropertyReceiver() {
        }

        public void setProperty(String name, Object value) {
            if (name.equals("text")) {
                this.text = (String)value;
            } else if (name.equals("icon")) {
                this.icon = (QIcon)value;
            }
        }

        QListWidgetItem listWidgetItem() {
            return new QListWidgetItem(this.icon, this.text);
        }
    }

    private class SpacerPropertyReceiver
    implements PropertyReceiver {
        Qt.Orientation orientation;
        QSize size;

        private SpacerPropertyReceiver() {
        }

        public void setProperty(String name, Object value) {
            if (name.equals("orientation")) {
                this.orientation = (Qt.Orientation)value;
            } else if (name.equals("sizeHint")) {
                this.size = (QSize)value;
            }
        }

        QSpacerItem spacerItem() {
            return new QSpacerItem(this.size.width(), this.size.height(), this.orientation == Qt.Orientation.Horizontal ? QSizePolicy.Policy.Expanding : QSizePolicy.Policy.Minimum, this.orientation == Qt.Orientation.Horizontal ? QSizePolicy.Policy.Minimum : QSizePolicy.Policy.Expanding);
        }
    }

    private class QObjectPropertyReceiver
    implements PropertyReceiver {
        QObject object;

        QObjectPropertyReceiver(QObject o) {
            this.object = o;
        }

        public void setProperty(String name, Object value) {
            if (name.equals("text") && !value.toString().equals("")) {
                value = QApplication.translate(QUiLoader.this.xmlClassName, value.toString());
            }
            QUiLoader.this.self().setProperty(this.object, name, value);
        }
    }

    private static interface PropertyReceiver {
        public void setProperty(String var1, Object var2);
    }
}

