/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.qt;

import griffon.core.GriffonApplication;
import griffon.core.GriffonController;
import griffon.core.controller.GriffonControllerAction;
import griffon.core.i18n.NoSuchMessageException;
import griffon.util.GriffonApplicationUtils;
import griffon.util.GriffonNameUtils;
import org.codehaus.griffon.runtime.core.controller.AbstractGriffonControllerActionManager;
import org.codehaus.griffon.runtime.qt.QtGriffonControllerAction;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QtGriffonControllerActionManager
extends AbstractGriffonControllerActionManager {
    private static final Logger LOG = LoggerFactory.getLogger(QtGriffonControllerActionManager.class);

    protected QtGriffonControllerActionManager(GriffonApplication app) {
        super(app);
    }

    protected GriffonControllerAction createControllerAction(GriffonController controller, String actionName) {
        return new QtGriffonControllerAction(controller, actionName);
    }

    protected GriffonControllerAction createAndConfigureAction(GriffonController controller, String actionName) {
        String rsWhatsThis;
        String rsVisible;
        String rsToolTip;
        String rsText;
        String rsStatusTip;
        String rsIconVisibleInMenu;
        String rsIconText;
        String rsIcon;
        String rsEnabled;
        String rsShortcut;
        String rsChecked;
        String rsCheckable;
        QtGriffonControllerAction action = (QtGriffonControllerAction)this.createControllerAction(controller, actionName);
        String normalizeNamed = GriffonNameUtils.capitalize((String)this.normalizeName(actionName));
        String keyPrefix = controller.getClass().getName() + ".action.";
        String rsAutoRepeat = this.message(keyPrefix, normalizeNamed, "autoRepeat", "false");
        if (!GriffonNameUtils.isBlank((String)rsAutoRepeat)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "autoRepeat" + " = " + rsAutoRepeat);
            }
            action.setAutoRepeat(DefaultTypeTransformation.castToBoolean((Object)rsAutoRepeat));
        }
        if (!GriffonNameUtils.isBlank((String)(rsCheckable = this.message(keyPrefix, normalizeNamed, "checkable", "false")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "checkable" + " = " + rsCheckable);
            }
            action.setCheckable(DefaultTypeTransformation.castToBoolean((Object)rsCheckable));
        }
        if (!GriffonNameUtils.isBlank((String)(rsChecked = this.message(keyPrefix, normalizeNamed, "checked", "false")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "checked" + " = " + rsChecked);
            }
            action.setChecked(DefaultTypeTransformation.castToBoolean((Object)rsChecked));
        }
        if (!GriffonNameUtils.isBlank((String)(rsShortcut = this.message(keyPrefix, normalizeNamed, "shortcut", "").toUpperCase()))) {
            if (!GriffonApplicationUtils.isMacOSX() && rsShortcut.contains("META") && !rsShortcut.contains("CTRL")) {
                rsShortcut = rsShortcut.replace("META", "CTRL");
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "shortcut" + " = " + rsShortcut);
            }
            action.setShortcut(rsShortcut);
        }
        if (!GriffonNameUtils.isBlank((String)(rsEnabled = this.message(keyPrefix, normalizeNamed, "enabled", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "enabled" + " = " + rsEnabled);
            }
            action.setEnabled(DefaultTypeTransformation.castToBoolean((Object)rsEnabled));
        }
        if (!GriffonNameUtils.isBlank((String)(rsIcon = this.message(keyPrefix, normalizeNamed, "icon", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "icon" + " = " + rsIcon);
            }
            action.setIcon(rsIcon);
        }
        if (!GriffonNameUtils.isBlank((String)(rsIconText = this.message(keyPrefix, normalizeNamed, "iconText", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "iconText" + " = " + rsIconText);
            }
            action.setIconText(rsIconText);
        }
        if (!GriffonNameUtils.isBlank((String)(rsIconVisibleInMenu = this.message(keyPrefix, normalizeNamed, "iconVisibleInMenu", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "iconVisibleInMenu" + " = " + rsIconVisibleInMenu);
            }
            action.setIconVisibleInMenu(DefaultTypeTransformation.castToBoolean((Object)rsIconVisibleInMenu));
        }
        if (!GriffonNameUtils.isBlank((String)(rsStatusTip = this.message(keyPrefix, normalizeNamed, "statusTip", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "statusTip" + " = " + rsStatusTip);
            }
            action.setStatusTip(rsStatusTip);
        }
        if (!GriffonNameUtils.isBlank((String)(rsText = this.message(keyPrefix, normalizeNamed, "text", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "text" + " = " + rsText);
            }
            action.setIconText(rsText);
        }
        if (!GriffonNameUtils.isBlank((String)(rsToolTip = this.message(keyPrefix, normalizeNamed, "toolTip", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "toolTip" + " = " + rsToolTip);
            }
            action.setToolTip(rsToolTip);
        }
        if (!GriffonNameUtils.isBlank((String)(rsVisible = this.message(keyPrefix, normalizeNamed, "visible", "true")))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "visible" + " = " + rsVisible);
            }
            action.setVisible(DefaultTypeTransformation.castToBoolean((Object)rsVisible));
        }
        if (!GriffonNameUtils.isBlank((String)(rsWhatsThis = this.message(keyPrefix, normalizeNamed, "whatsThis", "").toUpperCase()))) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(keyPrefix + normalizeNamed + "." + "whatsThis" + " = " + rsWhatsThis);
            }
            action.setWhatsThis(rsWhatsThis);
        }
        return action;
    }

    private String message(String key, String actionName, String subkey, String defaultValue) {
        try {
            return this.getApp().getMessage(key + actionName + "." + subkey);
        }
        catch (NoSuchMessageException nsme) {
            return this.getApp().getMessage("application.action." + actionName + "." + subkey, defaultValue);
        }
    }
}

