/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.qt;

import com.trolltech.qt.gui.QLayout;
import com.trolltech.qt.gui.QWidget;
import griffon.qt.factory.QLayoutFactory;
import griffon.qt.factory.QWidgetFactory;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import org.codehaus.griffon.runtime.builder.DefaultCompositeBuilderCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QtCompositeBuilderCustomizer
extends DefaultCompositeBuilderCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(QtCompositeBuilderCustomizer.class);

    public void registerBeanFactory(FactoryBuilderSupport builder, String name, String groupName, Class<?> beanClass) {
        if (QLayout.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using QLayoutFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new QLayoutFactory(beanClass));
        } else if (QWidget.class.isAssignableFrom(beanClass)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using QWidgetFactory");
            }
            builder.registerFactory(name, groupName, (Factory)new QWidgetFactory(beanClass));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering " + name + " with " + beanClass + " using default factory");
            }
            builder.registerBeanFactory(name, groupName, beanClass);
        }
    }
}

