/*
 * Decompiled with CFR 0.152.
 */
package griffon.qt.support;

import com.trolltech.qt.QSignalEmitter;
import groovy.lang.Closure;

public class Signals {
    private Signals() {
    }

    public static void connect(QSignalEmitter.AbstractSignal qsignal, Closure closure) {
        Signal signal = Signals.signalFor(closure);
        if (qsignal instanceof QSignalEmitter.Signal0) {
            signal = new Signal0(closure);
        }
        qsignal.connect((Object)signal, signal.methodName());
    }

    private static Signal signalFor(Closure closure) {
        switch (closure.getMaximumNumberOfParameters()) {
            case 0: {
                return new Signal0(closure);
            }
            case 1: {
                return new Signal1(closure);
            }
            case 2: {
                return new Signal2(closure);
            }
            case 3: {
                return new Signal3(closure);
            }
            case 4: {
                return new Signal4(closure);
            }
            case 5: {
                return new Signal5(closure);
            }
            case 6: {
                return new Signal6(closure);
            }
            case 7: {
                return new Signal7(closure);
            }
            case 8: {
                return new Signal8(closure);
            }
            case 9: {
                return new Signal9(closure);
            }
        }
        throw new IllegalArgumentException("Can't build a signal with " + closure.getMaximumNumberOfParameters() + "parameters");
    }

    public static final class Signal9<A, B, C, D, E, F, G, H, I>
    extends Signal {
        private final Closure closure;

        public Signal9(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d, E e, F f, G g, H h, I i) {
            this.closure.call(new Object[]{a, b, c, d, e, f, g, h, i});
        }

        @Override
        protected int argCount() {
            return 9;
        }
    }

    public static final class Signal8<A, B, C, D, E, F, G, H>
    extends Signal {
        private final Closure closure;

        public Signal8(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d, E e, F f, G g, H h) {
            this.closure.call(new Object[]{a, b, c, d, e, f, g, h});
        }

        @Override
        protected int argCount() {
            return 8;
        }
    }

    public static final class Signal7<A, B, C, D, E, F, G>
    extends Signal {
        private final Closure closure;

        public Signal7(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d, E e, F f, G g) {
            this.closure.call(new Object[]{a, b, c, d, e, f, g});
        }

        @Override
        protected int argCount() {
            return 7;
        }
    }

    public static final class Signal6<A, B, C, D, E, F>
    extends Signal {
        private final Closure closure;

        public Signal6(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d, E e, F f) {
            this.closure.call(new Object[]{a, b, c, d, e, f});
        }

        @Override
        protected int argCount() {
            return 6;
        }
    }

    public static final class Signal5<A, B, C, D, E>
    extends Signal {
        private final Closure closure;

        public Signal5(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d, E e) {
            this.closure.call(new Object[]{a, b, c, d, e});
        }

        @Override
        protected int argCount() {
            return 5;
        }
    }

    public static final class Signal4<A, B, C, D>
    extends Signal {
        private final Closure closure;

        public Signal4(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c, D d) {
            this.closure.call(new Object[]{a, b, c, d});
        }

        @Override
        protected int argCount() {
            return 4;
        }
    }

    public static final class Signal3<A, B, C>
    extends Signal {
        private final Closure closure;

        public Signal3(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b, C c) {
            this.closure.call(new Object[]{a, b, c});
        }

        @Override
        protected int argCount() {
            return 3;
        }
    }

    public static final class Signal2<A, B>
    extends Signal {
        private final Closure closure;

        public Signal2(Closure closure) {
            this.closure = closure;
        }

        public void call(A a, B b) {
            this.closure.call(new Object[]{a, b});
        }

        @Override
        protected int argCount() {
            return 2;
        }
    }

    public static final class Signal1<A>
    extends Signal {
        private final Closure closure;

        public Signal1(Closure closure) {
            this.closure = closure;
        }

        public void call(A a) {
            this.closure.call(a);
        }

        @Override
        protected int argCount() {
            return 1;
        }
    }

    public static final class Signal0
    extends Signal {
        private final Closure closure;

        public Signal0(Closure closure) {
            this.closure = closure;
        }

        public void call() {
            this.closure.call();
        }

        @Override
        protected int argCount() {
            return 0;
        }
    }

    private static abstract class Signal {
        private Signal() {
        }

        protected abstract int argCount();

        protected String methodName() {
            StringBuilder b = new StringBuilder("call(");
            boolean first = true;
            for (int i = 0; i < this.argCount(); ++i) {
                if (first) {
                    first = false;
                } else {
                    b.append(",");
                }
                b.append("Object");
            }
            b.append(")");
            return b.toString();
        }
    }
}

