/*
 * Decompiled with CFR 0.152.
 */
package griffon.qt.support;

import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QHideEvent;
import com.trolltech.qt.gui.QMainWindow;
import com.trolltech.qt.gui.QShowEvent;
import com.trolltech.qt.gui.QWidget;
import griffon.qt.support.event.QWidgetListener;
import griffon.qt.support.event.QWindowListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class QWindow
extends QMainWindow {
    private final List<QWindowListener> windowListeners = new CopyOnWriteArrayList<QWindowListener>();
    private final List<QWidgetListener> widgetListeners = new CopyOnWriteArrayList<QWidgetListener>();

    public void addWindowListener(QWindowListener listener) {
        if (null == listener || this.windowListeners.contains(listener)) {
            return;
        }
        this.windowListeners.add(listener);
    }

    public void addWidgetListener(QWidgetListener listener) {
        if (null == listener || this.widgetListeners.contains(listener)) {
            return;
        }
        this.widgetListeners.add(listener);
    }

    public void removeWindowListener(QWindowListener listener) {
        if (null == listener || !this.windowListeners.contains(listener)) {
            return;
        }
        this.windowListeners.remove(listener);
    }

    public void removeWidgetListener(QWidgetListener listener) {
        if (null == listener || !this.widgetListeners.contains(listener)) {
            return;
        }
        this.widgetListeners.remove(listener);
    }

    private void fireCloseEvent(QCloseEvent event) {
        for (QWindowListener listener : this.windowListeners) {
            listener.windowClosed(event, (QWidget)this);
        }
    }

    private void fireShowEvent(QShowEvent event) {
        for (QWidgetListener listener : this.widgetListeners) {
            listener.widgetShown(event, (QWidget)this);
        }
    }

    private void fireHideEvent(QHideEvent event) {
        for (QWidgetListener listener : this.widgetListeners) {
            listener.widgetHidden(event, (QWidget)this);
        }
    }

    protected void closeEvent(QCloseEvent arg__1) {
        super.closeEvent(arg__1);
        this.fireCloseEvent(arg__1);
    }

    protected void hideEvent(QHideEvent arg__1) {
        super.hideEvent(arg__1);
        this.fireHideEvent(arg__1);
    }

    protected void showEvent(QShowEvent arg__1) {
        super.showEvent(arg__1);
        this.fireShowEvent(arg__1);
    }
}

