/*
 * Decompiled with CFR 0.152.
 */
package griffon.qt.editors;

import com.trolltech.qt.gui.QColor;
import griffon.core.resources.editors.AbstractPropertyEditor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QColorPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof QColor) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, QColor.class);
        }
    }

    private void handleAsString(String str) {
        if (str.startsWith("#")) {
            int r = 0;
            int g = 0;
            int b = 0;
            int a = 255;
            switch (str.length()) {
                case 4: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(1)).toUpperCase());
                    g = this.parse(("" + str.charAt(2) + str.charAt(2)).toUpperCase());
                    b = this.parse(("" + str.charAt(3) + str.charAt(3)).toUpperCase());
                    break;
                }
                case 5: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(1)).toUpperCase());
                    g = this.parse(("" + str.charAt(2) + str.charAt(2)).toUpperCase());
                    b = this.parse(("" + str.charAt(3) + str.charAt(3)).toUpperCase());
                    a = this.parse(("" + str.charAt(4) + str.charAt(4)).toUpperCase());
                    break;
                }
                case 7: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(2)).toUpperCase());
                    g = this.parse(("" + str.charAt(3) + str.charAt(4)).toUpperCase());
                    b = this.parse(("" + str.charAt(5) + str.charAt(6)).toUpperCase());
                    break;
                }
                case 9: {
                    r = this.parse(("" + str.charAt(1) + str.charAt(2)).toUpperCase());
                    g = this.parse(("" + str.charAt(3) + str.charAt(4)).toUpperCase());
                    b = this.parse(("" + str.charAt(5) + str.charAt(6)).toUpperCase());
                    a = this.parse(("" + str.charAt(7) + str.charAt(8)).toUpperCase());
                    break;
                }
                default: {
                    throw this.illegalValue(str, QColor.class);
                }
            }
            try {
                super.setValue((Object)new QColor(r, g, b, a));
            }
            catch (NumberFormatException e) {
                throw this.illegalValue(str, QColor.class, e);
            }
        }
        try {
            Field colorField = QColor.class.getDeclaredField(str);
            super.setValue(colorField.get(null));
        }
        catch (NoSuchFieldException e) {
            throw this.illegalValue(str, QColor.class, e);
        }
        catch (IllegalAccessException e) {
            throw this.illegalValue(str, QColor.class, e);
        }
    }

    private void handleAsList(List list) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.addAll(list);
        switch (list.size()) {
            case 3: {
                values.add(255);
                break;
            }
            case 4: {
                break;
            }
            default: {
                throw this.illegalValue(list, QColor.class);
            }
        }
        int valuesSize = values.size();
        for (int i = 0; i < valuesSize; ++i) {
            Object val = values.get(i);
            if (val instanceof Number) {
                values.set(i, this.parse((Number)val));
                continue;
            }
            if (!(val instanceof CharSequence)) continue;
            values.set(i, this.parse(String.valueOf(val)));
        }
        super.setValue((Object)new QColor(((Integer)values.get(0)).intValue(), ((Integer)values.get(1)).intValue(), ((Integer)values.get(2)).intValue(), ((Integer)values.get(3)).intValue()));
    }

    private void handleAsMap(Map map) {
        int r = this.getMapValue(map, "red", 0);
        int g = this.getMapValue(map, "green", 0);
        int b = this.getMapValue(map, "blue", 0);
        int a = this.getMapValue(map, "alpha", 255);
        super.setValue((Object)new QColor(r, g, b, a));
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(String.valueOf(val).trim(), 16) & 0xFF;
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, QColor.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue() & 0xFF;
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, QColor.class);
    }

    private void handleAsNumber(Number value) {
        int c = this.parse(value);
        super.setValue((Object)new QColor(c, c, c, 255));
    }
}

