/*
 * Decompiled with CFR 0.152.
 */
package griffon.qt;

import com.trolltech.qt.gui.QCloseEvent;
import com.trolltech.qt.gui.QHideEvent;
import com.trolltech.qt.gui.QShowEvent;
import com.trolltech.qt.gui.QWidget;
import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.qt.QtGriffonApplication;
import griffon.qt.support.QWindow;
import griffon.qt.support.event.QWidgetAdapter;
import griffon.qt.support.event.QWindowAdapter;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final QtGriffonApplication app;
    private final WindowHelper windowHelper = new WindowHelper();
    private final WidgetHelper widgetHelper = new WidgetHelper();
    private final Map<String, QWindow> windows = new ConcurrentHashMap<String, QWindow>();

    public WindowManager(QtGriffonApplication app) {
        this.app = app;
    }

    public QWindow findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            return this.windows.get(name);
        }
        return null;
    }

    public String findWindowName(QWindow window) {
        if (window != null) {
            for (Map.Entry<String, QWindow> entry : this.windows.entrySet()) {
                if (entry.getValue() != window) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public QWindow getStartingWindow() {
        int index;
        QWindow window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"qt.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("qt.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.values().iterator().next();
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            int i = 0;
            Iterator<QWindow> iter = this.windows.values().iterator();
            while (iter.hasNext()) {
                if (i == index) {
                    window = iter.next();
                    break;
                }
                ++i;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting window is " + (Object)((Object)window));
        }
        return window;
    }

    public Collection<QWindow> getWindows() {
        return Collections.unmodifiableCollection(this.windows.values());
    }

    public void attach(String name, QWindow window) {
        if (window == null || this.windows.values().contains((Object)window)) {
            return;
        }
        window.addWindowListener(this.windowHelper);
        window.addWidgetListener(this.widgetHelper);
        this.windows.put(name, window);
    }

    public void detach(QWindow window) {
        if (window == null) {
            return;
        }
        if (this.windows.values().contains((Object)window)) {
            window.removeWindowListener(this.windowHelper);
            window.removeWidgetListener(this.widgetHelper);
            this.windows.remove(this.findWindowName(window));
        }
    }

    public void show(final QWindow window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, WindowManager.this.app);
            }
        });
    }

    public void hide(final QWindow window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, WindowManager.this.app);
            }
        });
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (QWindow window : this.windows.values()) {
            if (!window.isVisible()) continue;
            this.hide(window);
        }
    }

    public void handleClose(QWindow widget) {
        if (this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
            return;
        }
        int visibleWindows = 0;
        for (QWindow window : this.windows.values()) {
            if (!window.isVisible()) continue;
            ++visibleWindows;
        }
        Boolean autoShutdown = (Boolean)this.app.getConfig().flatten().get("application.autoShutdown");
        if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue() && !this.app.shutdown()) {
            this.show(widget);
        }
    }

    private class WidgetHelper
    extends QWidgetAdapter {
        private WidgetHelper() {
        }

        @Override
        public void widgetShown(QShowEvent e, QWidget widget) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(widget));
        }

        @Override
        public void widgetHidden(QHideEvent e, QWidget widget) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(widget));
        }
    }

    private class WindowHelper
    extends QWindowAdapter {
        private WindowHelper() {
        }

        @Override
        public void windowClosed(QCloseEvent event, QWidget widget) {
            if (WindowManager.this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
                return;
            }
            int visibleWindows = 0;
            for (QWindow window : WindowManager.this.windows.values()) {
                if (!window.isVisible()) continue;
                ++visibleWindows;
            }
            if (visibleWindows > 1) {
                WindowManager.this.hide((QWindow)widget);
            }
            Boolean autoShutdown = (Boolean)WindowManager.this.app.getConfig().flatten().get("application.autoShutdown");
            if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to shutdown application");
                }
                if (!WindowManager.this.app.shutdown()) {
                    WindowManager.this.show((QWindow)widget);
                }
            }
        }
    }
}

