/*
 * Decompiled with CFR 0.152.
 */
package griffon.qt;

import com.trolltech.qt.gui.QApplication;
import com.trolltech.qt.gui.QWidget;
import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.qt.ConfigurableWindowDisplayHandler;
import griffon.qt.QtGriffonApplication;
import griffon.qt.QtUIThreadHandler;
import griffon.qt.WindowDisplayHandler;
import griffon.qt.WindowManager;
import griffon.qt.support.QWindow;
import griffon.util.GriffonExceptionHandler;
import griffon.util.UIThreadHandler;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;

public abstract class AbstractQtGriffonApplication
extends AbstractGriffonApplication
implements QtGriffonApplication,
StandaloneGriffonApplication {
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();
    private static final Class[] CTOR_ARGS = new Class[]{String[].class};

    public AbstractQtGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractQtGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    @Override
    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new QtUIThreadHandler();
    }

    @Override
    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        QWindow startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.callReady(startingWindow);
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        System.exit(0);
    }

    public Object createApplicationContainer() {
        final QWidget[] window = new QWidget[1];
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                window[0] = new QWindow();
            }
        });
        return window[0];
    }

    protected void callReady(QWindow startingWindow) {
        this.ready();
        QApplication.exec();
        System.gc();
    }

    public static void run(Class applicationClass, String[] args) {
        GriffonExceptionHandler.registerExceptionHandler();
        StandaloneGriffonApplication app = null;
        try {
            app = (StandaloneGriffonApplication)applicationClass.getDeclaredConstructor(CTOR_ARGS).newInstance(new Object[]{args});
            app.bootstrap();
            app.realize();
            app.show();
        }
        catch (InstantiationException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (IllegalAccessException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (InvocationTargetException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
        catch (NoSuchMethodException e) {
            GriffonExceptionHandler.sanitize((Throwable)e).printStackTrace();
        }
    }
}

