/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import processing.core.PApplet;
import processing.net.Client;

public class Server
implements Runnable {
    PApplet parent;
    Method serverEventMethod;
    Thread thread;
    ServerSocket server;
    int port;
    public int clientCount;
    public Client[] clients;
    int lastAvailable = -1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Server(PApplet parent, int port) {
        this.parent = parent;
        this.port = port;
        try {
            this.server = new ServerSocket(this.port);
            this.clients = new Client[10];
            this.thread = new Thread(this);
            this.thread.start();
            parent.registerDispose((Object)this);
            try {
                Class<?> clazz = parent.getClass();
                Class[] classArray = new Class[2];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("processing.net.Server");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[0] = clazz2;
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("processing.net.Client");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                classArray[1] = clazz3;
                this.serverEventMethod = clazz.getMethod("serverEvent", classArray);
            }
            catch (Exception exception) {}
        }
        catch (IOException e) {
            e.printStackTrace();
            this.thread = null;
        }
    }

    public void disconnect(Client client) {
        client.dispose();
        int index = this.clientIndex(client);
        if (index != -1) {
            this.removeIndex(index);
        }
    }

    protected void removeIndex(int index) {
        --this.clientCount;
        int i = index;
        while (i < this.clientCount) {
            this.clients[i] = this.clients[i + 1];
            ++i;
        }
        this.clients[this.clientCount] = null;
    }

    protected void addClient(Client client) {
        if (this.clientCount == this.clients.length) {
            this.clients = (Client[])PApplet.expand((Object)this.clients);
        }
        this.clients[this.clientCount++] = client;
    }

    protected int clientIndex(Client client) {
        int i = 0;
        while (i < this.clientCount) {
            if (this.clients[i] == client) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client available() {
        Client[] clientArray = this.clients;
        synchronized (this.clients) {
            int index = this.lastAvailable + 1;
            if (index >= this.clientCount) {
                index = 0;
            }
            int i = 0;
            while (i < this.clientCount) {
                int which = (index + i) % this.clientCount;
                Client client = this.clients[which];
                if (client.available() > 0) {
                    this.lastAvailable = which;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return client;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    public void stop() {
        this.dispose();
    }

    public void dispose() {
        try {
            this.thread = null;
            if (this.clients != null) {
                int i = 0;
                while (i < this.clientCount) {
                    this.disconnect(this.clients[i]);
                    ++i;
                }
                this.clientCount = 0;
                this.clients = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        while (Thread.currentThread() == this.thread) {
            try {
                Socket socket = this.server.accept();
                Client client = new Client(this.parent, socket);
                Client[] clientArray = this.clients;
                // MONITORENTER : this.clients
                this.addClient(client);
                if (this.serverEventMethod != null) {
                    try {
                        this.serverEventMethod.invoke((Object)this.parent, this, client);
                    }
                    catch (Exception e) {
                        System.err.println("Disabling serverEvent() for port " + this.port);
                        e.printStackTrace();
                        this.serverEventMethod = null;
                    }
                }
                // MONITOREXIT : clientArray
            }
            catch (IOException e) {
                e.printStackTrace();
                this.thread = null;
            }
            try {
                Thread.sleep(8L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void write(int data) {
        int index = 0;
        while (index < this.clientCount) {
            this.clients[index].write(data);
            if (this.clients[index].active()) {
                ++index;
                continue;
            }
            this.removeIndex(index);
        }
    }

    public void write(byte[] data) {
        int index = 0;
        while (index < this.clientCount) {
            this.clients[index].write(data);
            if (this.clients[index].active()) {
                ++index;
                continue;
            }
            this.removeIndex(index);
        }
    }

    public void write(String data) {
        int index = 0;
        while (index < this.clientCount) {
            this.clients[index].write(data);
            if (this.clients[index].active()) {
                ++index;
                continue;
            }
            this.removeIndex(index);
        }
    }
}

