/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.processing.artifact;

import griffon.core.GriffonApplication;
import griffon.core.GriffonClass;
import griffon.core.GriffonController;
import griffon.core.GriffonModel;
import griffon.core.GriffonMvcArtifact;
import griffon.core.GriffonView;
import griffon.core.MVCClosure;
import griffon.core.MVCGroup;
import griffon.core.UIThreadManager;
import griffon.plugins.processing.artifact.GriffonProcessingView;
import groovy.lang.Closure;
import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.codehaus.griffon.runtime.builder.UberInterceptorMetaClass;
import org.codehaus.griffon.runtime.core.ResourceLocator;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import processing.core.PApplet;

public abstract class AbstractGriffonProcessingView
extends PApplet
implements GriffonProcessingView {
    private GriffonApplication app;
    private final Logger log;
    private MetaClass myMetaClass;
    private final ResourceLocator resourceLocator = new ResourceLocator();

    public AbstractGriffonProcessingView() {
        this.log = LoggerFactory.getLogger((String)("griffon.app.processing." + this.getClass().getName()));
    }

    public void mvcGroupInit(Map<String, Object> args) {
    }

    public void mvcGroupDestroy() {
    }

    public GriffonApplication getApp() {
        return this.app;
    }

    public void setApp(GriffonApplication app) {
        this.app = app;
    }

    public Object newInstance(Class clazz, String type) {
        return GriffonApplicationHelper.newInstance((GriffonApplication)this.app, (Class)clazz, (String)type);
    }

    public MetaClass getMetaClass() {
        if (this.myMetaClass == null) {
            Class<?> clazz = this.getClass();
            this.myMetaClass = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
            if (!(this.myMetaClass instanceof ExpandoMetaClass) || !(this.myMetaClass instanceof UberInterceptorMetaClass)) {
                this.myMetaClass = new ExpandoMetaClass(clazz, true, true);
                this.log.debug("Upgrading MetaClass to " + this.myMetaClass);
                this.myMetaClass.initialize();
                GroovySystem.getMetaClassRegistry().setMetaClass(clazz, this.myMetaClass);
            }
        }
        return this.myMetaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.myMetaClass = metaClass;
        GroovySystem.getMetaClassRegistry().setMetaClass(this.getClass(), metaClass);
    }

    public GriffonClass getGriffonClass() {
        return this.app.getArtifactManager().findGriffonClass(this.getClass());
    }

    public boolean isUIThread() {
        return UIThreadManager.getInstance().isUIThread();
    }

    public void execAsync(Runnable runnable) {
        this.execInsideUIAsync(runnable);
    }

    public void execSync(Runnable runnable) {
        this.execInsideUISync(runnable);
    }

    public void execOutside(Runnable runnable) {
        this.execOutsideUI(runnable);
    }

    public void execInsideUIAsync(Runnable runnable) {
        UIThreadManager.getInstance().executeAsync(runnable);
    }

    public void execInsideUISync(Runnable runnable) {
        UIThreadManager.getInstance().executeSync(runnable);
    }

    public void execOutsideUI(Runnable runnable) {
        UIThreadManager.getInstance().executeOutside(runnable);
    }

    public Future execFuture(ExecutorService executorService, Closure closure) {
        return UIThreadManager.getInstance().executeFuture(executorService, (Callable)closure);
    }

    public Future execFuture(Closure closure) {
        return UIThreadManager.getInstance().executeFuture((Callable)closure);
    }

    public Future execFuture(ExecutorService executorService, Callable callable) {
        return UIThreadManager.getInstance().executeFuture(executorService, callable);
    }

    public Future execFuture(Callable callable) {
        return UIThreadManager.getInstance().executeFuture(callable);
    }

    public Logger getLog() {
        return this.log;
    }

    public MVCGroup buildMVCGroup(String mvcType) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, null, Collections.emptyMap());
    }

    public MVCGroup buildMVCGroup(String mvcType, String mvcName) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, mvcName, Collections.emptyMap());
    }

    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    public MVCGroup buildMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, null, args);
    }

    public MVCGroup buildMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    public MVCGroup buildMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getApp().getMvcGroupManager().buildMVCGroup(mvcType, mvcName, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, null, Collections.emptyMap());
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, Map<String, Object> args) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, null, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, mvcName, Collections.emptyMap());
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(Map<String, Object> args, String mvcType, String mvcName) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    public List<? extends GriffonMvcArtifact> createMVCGroup(String mvcType, String mvcName, Map<String, Object> args) {
        return this.getApp().getMvcGroupManager().createMVCGroup(mvcType, mvcName, args);
    }

    public void destroyMVCGroup(String mvcName) {
        this.getApp().getMvcGroupManager().destroyMVCGroup(mvcName);
    }

    public void withMVCGroup(String mvcType, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, Collections.emptyMap(), handler);
    }

    public void withMVCGroup(String mvcType, String mvcName, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.emptyMap(), handler);
    }

    public void withMVCGroup(String mvcType, Map<String, Object> args, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public void withMVCGroup(Map<String, Object> args, String mvcType, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, Closure handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, Collections.emptyMap(), handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, Collections.emptyMap(), handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, null, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(String mvcType, String mvcName, Map<String, Object> args, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVCGroup(Map<String, Object> args, String mvcType, String mvcName, MVCClosure<M, V, C> handler) {
        this.getApp().getMvcGroupManager().withMVCGroup(mvcType, mvcName, args, handler);
    }

    public InputStream getResourceAsStream(String name) {
        return this.resourceLocator.getResourceAsStream(name);
    }

    public URL getResourceAsURL(String name) {
        return this.resourceLocator.getResourceAsURL(name);
    }

    public List<URL> getResources(String name) {
        return this.resourceLocator.getResources(name);
    }
}

