/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.prefs;

import griffon.core.GriffonApplication;
import griffon.core.resources.editors.ExtendedPropertyEditor;
import griffon.core.resources.editors.PropertyEditorResolver;
import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.NodeChangeListener;
import griffon.plugins.preferences.Preference;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.PreferenceChangeListener;
import griffon.plugins.preferences.PreferencesAware;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesNode;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonExceptionHandler;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPreferencesManager
implements PreferencesManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPreferencesManager.class);
    private static final Object[] NO_ARGS = new Object[0];
    protected final GriffonApplication app;
    private final InstanceStore instanceStore = new InstanceStore();

    public AbstractPreferencesManager(GriffonApplication app) {
        this.app = app;
        app.addApplicationEventListener(GriffonApplication.Event.NEW_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object[] args) {
                Object instance = args[2];
                AbstractPreferencesManager.this.injectPreferences(instance);
            }
        });
        app.addApplicationEventListener(GriffonApplication.Event.DESTROY_INSTANCE.getName(), new RunnableWithArgs(){

            public void run(Object[] args) {
                Object instance = args[2];
                if (AbstractPreferencesManager.this.instanceStore.contains(instance)) {
                    AbstractPreferencesManager.this.instanceStore.remove(instance);
                }
            }
        });
    }

    protected void init() {
        this.getPreferences().addNodeChangeListener(new NodeChangeListener(){

            @Override
            public void nodeChanged(NodeChangeEvent event) {
                if (event.getType() == NodeChangeEvent.Type.ADDED) {
                    for (InstanceContainer instanceContainer : AbstractPreferencesManager.this.instanceStore) {
                        if (!instanceContainer.containsPartialPath(event.getPath())) continue;
                        AbstractPreferencesManager.this.injectPreferences(instanceContainer.instance());
                    }
                }
            }
        });
        this.getPreferences().addPreferencesChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChanged(PreferenceChangeEvent event) {
                for (InstanceContainer instanceContainer : AbstractPreferencesManager.this.instanceStore) {
                    String path;
                    if (!instanceContainer.containsPath(path = "/".equals(path = event.getPath()) ? event.getKey() : path + "." + event.getKey())) continue;
                    FieldDescriptor fd = (FieldDescriptor)instanceContainer.fields.get(path);
                    Object value = event.getNewValue();
                    if (null != value && !fd.field.getType().isAssignableFrom(value.getClass())) {
                        value = AbstractPreferencesManager.this.convertValue(fd.field.getType(), value, fd.format);
                    }
                    AbstractPreferencesManager.this.setFieldValue(instanceContainer.instance(), fd.field, fd.fqFieldName, value);
                }
            }
        });
    }

    public GriffonApplication getApp() {
        return this.app;
    }

    @Override
    public void save(Object instance) {
        if (instance == null) {
            return;
        }
        LinkedList<PreferenceDescriptor> fieldsToSaved = new LinkedList<PreferenceDescriptor>();
        Class<?> klass = instance.getClass();
        do {
            this.harvestFields(klass, instance, fieldsToSaved);
        } while (null != (klass = klass.getSuperclass()));
        this.doSavePreferences(instance, fieldsToSaved);
    }

    protected void injectPreferences(Object instance) {
        if (null == instance) {
            return;
        }
        LinkedList<PreferenceDescriptor> fieldsToBeInjected = new LinkedList<PreferenceDescriptor>();
        Class<?> klass = instance.getClass();
        do {
            this.harvestFields(klass, instance, fieldsToBeInjected);
        } while (null != (klass = klass.getSuperclass()));
        this.doPreferencesInjection(instance, fieldsToBeInjected);
        if (instance.getClass().getAnnotation(PreferencesAware.class) != null && !this.instanceStore.contains(instance)) {
            LinkedList<FieldDescriptor> fields = new LinkedList<FieldDescriptor>();
            for (PreferenceDescriptor pd : fieldsToBeInjected) {
                fields.add(new FieldDescriptor(pd.field, pd.fqFieldName, pd.path, pd.format));
            }
            this.instanceStore.add(instance, fields);
        }
    }

    protected void harvestFields(Class klass, Object instance, List<PreferenceDescriptor> fieldsToBeInjected) {
        for (Field field : klass.getDeclaredFields()) {
            Preference annotation;
            if (field.isSynthetic() || null == (annotation = field.getAnnotation(Preference.class))) continue;
            String fqFieldName = field.getDeclaringClass().getName().replace('$', '.') + "." + field.getName();
            String path = "/" + field.getDeclaringClass().getName().replace('$', '/').replace('.', '/') + "." + field.getName();
            String key = annotation.key();
            Object[] args = annotation.args();
            String defaultValue = annotation.defaultValue();
            String resolvedPath = !GriffonNameUtils.isBlank((String)key) ? key : path;
            String format = annotation.format();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Field " + fqFieldName + " of instance " + instance + " [path='" + resolvedPath + "', args='" + Arrays.toString(args) + "', defaultValue='" + defaultValue + "', format='" + format + "'] is marked for preference injection.");
            }
            fieldsToBeInjected.add(new PreferenceDescriptor(field, fqFieldName, resolvedPath, (String[])args, defaultValue, format));
        }
    }

    protected void doPreferencesInjection(Object instance, List<PreferenceDescriptor> fieldsToBeInjected) {
        for (PreferenceDescriptor pd : fieldsToBeInjected) {
            Object value = this.resolvePreference(pd.path, pd.args, pd.defaultValue);
            if (null == value) continue;
            if (!pd.field.getType().isAssignableFrom(value.getClass())) {
                value = this.convertValue(pd.field.getType(), value, pd.format);
            }
            this.setFieldValue(instance, pd.field, pd.fqFieldName, value);
        }
    }

    protected void doSavePreferences(Object instance, List<PreferenceDescriptor> fieldsToSaved) {
        for (PreferenceDescriptor pd : fieldsToSaved) {
            Object value = this.getFieldValue(instance, pd.field, pd.fqFieldName);
            String[] parsedPath = this.parsePath(pd.path);
            PreferencesNode node = this.getPreferences().node(parsedPath[0]);
            String key = parsedPath[1];
            if (value != null) {
                PropertyEditor propertyEditor;
                if (!GriffonNameUtils.isBlank((String)pd.format) && (propertyEditor = this.resolvePropertyEditor(value.getClass(), pd.format)) != null) {
                    propertyEditor.setValue(value);
                    value = propertyEditor.getAsText();
                }
                node.putAt(key, value);
                continue;
            }
            node.remove(key);
        }
    }

    protected Object resolvePreference(String path, String[] args, String defaultValue) {
        String key;
        String[] parsedPath = this.parsePath(path);
        PreferencesNode node = this.getPreferences().node(parsedPath[0]);
        if (node.containsKey(key = parsedPath[1])) {
            return this.evalPreferenceWithArguments(node.getAt(key), args);
        }
        node.putAt(key, defaultValue);
        return defaultValue;
    }

    protected Object evalPreferenceWithArguments(Object value, Object[] args) {
        if (value instanceof Closure) {
            Closure closure = (Closure)value;
            return closure.call(args);
        }
        if (value instanceof CallableWithArgs) {
            CallableWithArgs callable = (CallableWithArgs)value;
            return callable.call(args);
        }
        if (value instanceof CharSequence) {
            return this.formatPreferenceValue(String.valueOf(value), args);
        }
        return value;
    }

    protected String formatPreferenceValue(String message, Object[] args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Formatting message={} args={}", (Object)message, (Object)Arrays.toString(args));
        }
        if (args == null || args.length == 0) {
            return message;
        }
        return MessageFormat.format(message, args);
    }

    protected Object convertValue(Class<?> type, Object value, String format) {
        PropertyEditor propertyEditor = this.resolvePropertyEditor(type, format);
        if (null == propertyEditor) {
            return value;
        }
        if (value instanceof CharSequence) {
            propertyEditor.setAsText(String.valueOf(value));
        } else {
            propertyEditor.setValue(value);
        }
        return propertyEditor.getValue();
    }

    protected PropertyEditor resolvePropertyEditor(Class<?> type, String format) {
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(type);
        if (propertyEditor instanceof ExtendedPropertyEditor) {
            ((ExtendedPropertyEditor)propertyEditor).setFormat(format);
        }
        return propertyEditor;
    }

    protected void setFieldValue(Object instance, Field field, String fqFieldName, Object value) {
        block4: {
            String setter = GriffonNameUtils.getSetterName((String)field.getName());
            try {
                InvokerHelper.invokeMethod((Object)instance, (String)setter, (Object)value);
            }
            catch (MissingMethodException mme) {
                try {
                    field.setAccessible(true);
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn("Cannot set value on field " + fqFieldName + " of instance " + instance, GriffonExceptionHandler.sanitize((Throwable)e));
                }
            }
        }
    }

    protected Object getFieldValue(Object instance, Field field, String fqFieldName) {
        String getter = GriffonNameUtils.getGetterName((String)field.getName());
        try {
            return InvokerHelper.invokeMethod((Object)instance, (String)getter, (Object)NO_ARGS);
        }
        catch (MissingMethodException mme) {
            try {
                field.setAccessible(true);
                return field.get(instance);
            }
            catch (IllegalAccessException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Cannot get value on field " + fqFieldName + " of instance " + instance, GriffonExceptionHandler.sanitize((Throwable)e));
                }
                return null;
            }
        }
    }

    protected String[] parsePath(String path) {
        int split = path.lastIndexOf(".");
        String head = split < 0 ? path : path.substring(0, split);
        String tail = split > 0 ? path.substring(split + 1) : null;
        head = head.replace('.', '/');
        return new String[]{head, tail};
    }

    private static class FieldDescriptor {
        private final Field field;
        private final String fqFieldName;
        private final String path;
        private final String format;

        private FieldDescriptor(Field field, String fqFieldName, String path, String format) {
            this.field = field;
            this.fqFieldName = fqFieldName;
            this.path = path;
            this.format = format;
        }
    }

    private static class PreferenceDescriptor {
        private final Field field;
        private final String fqFieldName;
        private final String path;
        private final String[] args;
        private final String defaultValue;
        private final String format;

        private PreferenceDescriptor(Field field, String fqFieldName, String path, String[] args, String defaultValue, String format) {
            this.field = field;
            this.fqFieldName = fqFieldName;
            this.path = path;
            this.args = args;
            this.defaultValue = defaultValue;
            this.format = format;
        }
    }

    private static class InstanceContainer {
        private final WeakReference<Object> instance;
        private final Map<String, FieldDescriptor> fields = new LinkedHashMap<String, FieldDescriptor>();

        private InstanceContainer(Object instance, List<FieldDescriptor> fields) {
            this.instance = new WeakReference<Object>(instance);
            for (FieldDescriptor fd : fields) {
                this.fields.put(fd.path, fd);
            }
        }

        private Object instance() {
            return this.instance.get();
        }

        private boolean containsPath(String path) {
            for (String p : this.fields.keySet()) {
                if (!p.equals(path)) continue;
                return true;
            }
            return false;
        }

        public boolean containsPartialPath(String path) {
            for (String p : this.fields.keySet()) {
                if (!p.startsWith(path + ".")) continue;
                return true;
            }
            return false;
        }
    }

    private static class InstanceStore
    implements Iterable<InstanceContainer> {
        private final List<InstanceContainer> instances = new CopyOnWriteArrayList<InstanceContainer>();

        private InstanceStore() {
        }

        private void add(Object instance, List<FieldDescriptor> fields) {
            if (null == instance) {
                return;
            }
            this.instances.add(new InstanceContainer(instance, fields));
        }

        private void remove(Object instance) {
            InstanceContainer instance1;
            Object candidate;
            if (null == instance) {
                return;
            }
            InstanceContainer subject = null;
            Iterator<InstanceContainer> i$ = this.instances.iterator();
            while (i$.hasNext() && !instance.equals(candidate = (subject = (instance1 = i$.next())).instance())) {
            }
            if (subject != null) {
                this.instances.remove(subject);
            }
        }

        private boolean contains(Object instance) {
            if (null == instance) {
                return false;
            }
            for (InstanceContainer instanceContainer : this.instances) {
                Object candidate = instanceContainer.instance();
                if (!instance.equals(candidate)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Iterator<InstanceContainer> iterator() {
            final Iterator<InstanceContainer> it = this.instances.iterator();
            return new Iterator<InstanceContainer>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public InstanceContainer next() {
                    return (InstanceContainer)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
        }
    }
}

