/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.prefs;

import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.NodeChangeListener;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.PreferenceChangeListener;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPreferences
implements Preferences {
    private final List<NodeChangeListener> nodeChangeListeners = new ArrayList<NodeChangeListener>();
    private final List<PreferenceChangeListener> changeListeners = new ArrayList<PreferenceChangeListener>();

    @Override
    public void addNodeChangeListener(NodeChangeListener listener) {
        if (listener == null || this.nodeChangeListeners.contains(listener)) {
            return;
        }
        this.nodeChangeListeners.add(listener);
    }

    @Override
    public void removeNodeChangeListener(NodeChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.nodeChangeListeners.remove(listener);
    }

    @Override
    public NodeChangeListener[] getNodeChangeListeners() {
        return this.nodeChangeListeners.toArray(new NodeChangeListener[this.nodeChangeListeners.size()]);
    }

    @Override
    public void addPreferencesChangeListener(PreferenceChangeListener listener) {
        if (listener == null || this.changeListeners.contains(listener)) {
            return;
        }
        this.changeListeners.add(listener);
    }

    @Override
    public void removePreferencesChangeListener(PreferenceChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.changeListeners.remove(listener);
    }

    @Override
    public PreferenceChangeListener[] getPreferencesChangeListeners() {
        return this.changeListeners.toArray(new PreferenceChangeListener[this.changeListeners.size()]);
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent event) {
        for (PreferenceChangeListener listener : this.changeListeners) {
            listener.preferenceChanged(event);
        }
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        for (NodeChangeListener listener : this.nodeChangeListeners) {
            listener.nodeChanged(event);
        }
    }

    @Override
    public PreferencesNode node(Class<?> clazz) {
        return this.getRoot().node(clazz);
    }

    @Override
    public PreferencesNode node(String path) {
        return this.getRoot().node(path);
    }

    @Override
    public PreferencesNode removeNode(Class<?> clazz) {
        return this.getRoot().removeNode(clazz);
    }

    @Override
    public PreferencesNode removeNode(String path) {
        return this.getRoot().removeNode(path);
    }
}

