/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.preferences.persistors;

import griffon.core.ApplicationHandler;
import griffon.core.GriffonApplication;
import griffon.core.resources.editors.PropertyEditorResolver;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesNode;
import griffon.plugins.preferences.PreferencesPersistor;
import griffon.util.ConfigUtils;
import griffon.util.Metadata;
import groovy.json.JsonBuilder;
import groovy.json.JsonSlurper;
import java.beans.PropertyEditor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPreferencesPersistor
implements PreferencesPersistor,
ApplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPreferencesPersistor.class);
    private static final String KEY_PREFERENCES_PERSISTOR_LOCATION = "preferences.persistor.location";
    private final GriffonApplication app;

    public JsonPreferencesPersistor(GriffonApplication app) {
        this.app = app;
    }

    public GriffonApplication getApp() {
        return this.app;
    }

    private InputStream inputStream() throws IOException {
        File file;
        String fileName = this.resolvePreferencesFileName();
        if (LOG.isInfoEnabled()) {
            LOG.info("Reading preferences from " + fileName);
        }
        if (!(file = new File(fileName)).exists()) {
            file.getParentFile().mkdirs();
        }
        return new FileInputStream(file);
    }

    private OutputStream outputStream() throws IOException {
        File file;
        String fileName = this.resolvePreferencesFileName();
        if (LOG.isInfoEnabled()) {
            LOG.info("Writing preferences to " + fileName);
        }
        if (!(file = new File(fileName)).exists()) {
            file.getParentFile().mkdirs();
        }
        return new FileOutputStream(file);
    }

    private String resolvePreferencesFileName() {
        String defaultLocation = System.getProperty("user.home") + File.separator + "." + Metadata.getCurrent().getApplicationName() + File.separator + "preferences" + File.separator + "default.json";
        return ConfigUtils.getConfigValueAsString((Map)this.app.getConfig(), (String)KEY_PREFERENCES_PERSISTOR_LOCATION, (String)defaultLocation);
    }

    @Override
    public Preferences read(PreferencesManager preferencesManager) throws IOException {
        InputStreamReader reader = new InputStreamReader(this.inputStream());
        Object o = null;
        try {
            o = new JsonSlurper().parse((Reader)reader);
        }
        catch (NullPointerException npe) {
            return preferencesManager.getPreferences();
        }
        reader.close();
        if (!(o instanceof Map)) {
            throw new IllegalArgumentException("Top node of persisted Preferences is not a Map!");
        }
        PreferencesNode node = preferencesManager.getPreferences().getRoot();
        Map map = (Map)o;
        this.readInto(map, node);
        return preferencesManager.getPreferences();
    }

    @Override
    public void write(PreferencesManager preferencesManager) throws IOException {
        PreferencesNode node = preferencesManager.getPreferences().getRoot();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.writeTo(node, map);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.outputStream()));
        writer.write(new JsonBuilder(map).toPrettyString());
        writer.flush();
        writer.close();
    }

    private void readInto(Map<String, Object> map, PreferencesNode node) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.readInto((Map)value, node.node(key));
                continue;
            }
            if (value instanceof List || value instanceof Number || value instanceof Boolean || value instanceof CharSequence) {
                node.putAt(key, value);
                continue;
            }
            throw new IllegalArgumentException("Invalid value for '" + node.path() + "." + key + "' => " + value);
        }
    }

    private void writeTo(PreferencesNode node, Map<String, Object> map) {
        for (String key : node.keys()) {
            Object value = node.getAt(key);
            if (value == null) continue;
            map.put(key, this.convertValue(value));
        }
        for (Map.Entry<String, PreferencesNode> child : node.children().entrySet()) {
            LinkedHashMap<String, Object> childMap = new LinkedHashMap<String, Object>();
            this.writeTo(child.getValue(), childMap);
            map.put(child.getKey(), childMap);
        }
    }

    private Object convertValue(Object value) {
        if (value == null || value instanceof Boolean || value instanceof Number || value instanceof CharSequence) {
            return value;
        }
        if (value instanceof Map) {
            LinkedHashMap<String, Object> tmp = new LinkedHashMap<String, Object>();
            Map source = (Map)value;
            for (Object key : source.keySet()) {
                Object val = source.get(key);
                if (val == null) continue;
                tmp.put(String.valueOf(key), this.convertValue(val));
            }
            return tmp;
        }
        if (value instanceof Collection) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            List source = (List)value;
            for (Object val : source) {
                tmp.add(this.convertValue(val));
            }
            return tmp;
        }
        if (value.getClass().isArray()) {
            Object[] source;
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (Object val : source = (Object[])value) {
                tmp.add(this.convertValue(val));
            }
            return tmp;
        }
        PropertyEditor propertyEditor = PropertyEditorResolver.findEditor(value.getClass());
        if (propertyEditor != null) {
            propertyEditor.setValue(value);
            return propertyEditor.getAsText();
        }
        return value;
    }
}

