/*
 * Decompiled with CFR 0.152.
 */
import griffon.core.GriffonApplication;
import griffon.plugins.preferences.PreferencesManager;
import griffon.plugins.preferences.PreferencesPersistor;
import griffon.plugins.preferences.factories.PreferencesManagerFactory;
import griffon.plugins.preferences.factories.PreferencesPersistorFactory;
import griffon.plugins.preferences.util.PreferencesManagerHolder;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigUtils;
import griffon.util.GriffonExceptionHandler;
import griffon.util.RunnableWithArgs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import org.codehaus.griffon.runtime.core.AbstractGriffonAddon;
import org.codehaus.griffon.runtime.util.GriffonApplicationHelper;

public class PreferencesGriffonAddon
extends AbstractGriffonAddon {
    private static final String KEY_PREFERENCES_MANAGER_FACTORY = "preferences.manager.factory";
    private static final String KEY_PREFERENCES_PERSISTOR_FACTORY = "preferences.persistor.factory";
    private static final String DEFAULT_PREFERENCES_MANAGER_FACTORY = "org.codehaus.griffon.runtime.prefs.factories.DefaultPreferencesManagerFactory";
    private static final String DEFAULT_PREFERENCES_PERSISTOR_FACTORY = "org.codehaus.griffon.runtime.prefs.factories.JsonPreferencesPersistorFactory";

    public PreferencesGriffonAddon() {
        super(ApplicationHolder.getApplication());
    }

    public void addonPostInit(GriffonApplication app) {
        boolean preferencesWereRead;
        PreferencesPersistor preferencesPersistor;
        PreferencesManager preferencesManager;
        block4: {
            preferencesManager = this.initializePreferencesManager(app);
            preferencesPersistor = this.initializePreferencesPersistor(app);
            preferencesWereRead = false;
            try {
                preferencesPersistor.read(preferencesManager);
                preferencesWereRead = true;
            }
            catch (FileNotFoundException fnfe) {
                preferencesWereRead = true;
            }
            catch (IOException e) {
                if (!this.getLog().isWarnEnabled()) break block4;
                this.getLog().warn("Cannot read preferences", GriffonExceptionHandler.sanitize((Throwable)e));
            }
        }
        if (preferencesWereRead) {
            app.addApplicationEventListener(GriffonApplication.Event.SHUTDOWN_START.getName(), new RunnableWithArgs(){

                public void run(Object[] args) {
                    block2: {
                        try {
                            preferencesPersistor.write(preferencesManager);
                        }
                        catch (IOException e) {
                            if (!PreferencesGriffonAddon.this.getLog().isWarnEnabled()) break block2;
                            PreferencesGriffonAddon.this.getLog().warn("Cannot persist preferences", GriffonExceptionHandler.sanitize((Throwable)e));
                        }
                    }
                }
            });
        }
    }

    private PreferencesManager initializePreferencesManager(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), (String)KEY_PREFERENCES_MANAGER_FACTORY, (String)DEFAULT_PREFERENCES_MANAGER_FACTORY);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Using " + className + " as PreferencesManagerFactory");
        }
        PreferencesManagerFactory factory = (PreferencesManagerFactory)GriffonApplicationHelper.safeNewInstance((String)className);
        PreferencesManager preferencesManager = factory.create(app);
        PreferencesManagerHolder.setPreferencesManager(preferencesManager);
        return preferencesManager;
    }

    private PreferencesPersistor initializePreferencesPersistor(GriffonApplication app) {
        String className = ConfigUtils.getConfigValueAsString((Map)app.getConfig(), (String)KEY_PREFERENCES_PERSISTOR_FACTORY, (String)DEFAULT_PREFERENCES_PERSISTOR_FACTORY);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Using " + className + " as PreferencesPersistorFactory");
        }
        PreferencesPersistorFactory factory = (PreferencesPersistorFactory)GriffonApplicationHelper.safeNewInstance((String)className);
        return factory.create(app);
    }
}

