/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.prefs;

import griffon.plugins.preferences.NodeChangeEvent;
import griffon.plugins.preferences.PreferenceChangeEvent;
import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.griffon.runtime.prefs.AbstractPreferencesNode;

public class DefaultPreferencesNode
extends AbstractPreferencesNode {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Map<String, PreferencesNode> nodes = new LinkedHashMap<String, PreferencesNode>();

    public DefaultPreferencesNode(Preferences preferences, String name) {
        this(preferences, null, name);
    }

    public DefaultPreferencesNode(Preferences preferences, PreferencesNode parent, String name) {
        super(preferences, parent, name);
    }

    @Override
    public Object getAt(String key) {
        return this.properties.get(key);
    }

    @Override
    public void putAt(String key, Object value) {
        Object oldValue = this.properties.get(key);
        this.properties.put(key, value);
        if (!this.areEqual(oldValue, value)) {
            this.firePreferencesChanged(this.path(), key, oldValue, value);
        }
    }

    private void firePreferencesChanged(String path, String key, Object oldValue, Object newValue) {
        this.preferences.preferenceChanged(new PreferenceChangeEvent(path, key, oldValue, newValue));
    }

    @Override
    public void remove(String key) {
        Object oldValue = this.properties.remove(key);
        if (oldValue != null) {
            this.firePreferencesChanged(this.path(), key, oldValue, null);
        }
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String[] keys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public Map<String, PreferencesNode> children() {
        return Collections.unmodifiableMap(this.nodes);
    }

    @Override
    public DefaultPreferencesNode createChildNode(String nodeName) {
        return new DefaultPreferencesNode(this.preferences, this, nodeName);
    }

    @Override
    public void storeChildNode(String nodeName, PreferencesNode node) {
        this.nodes.put(nodeName, node);
        this.preferences.nodeChanged(new NodeChangeEvent(node.path(), NodeChangeEvent.Type.ADDED));
    }

    @Override
    public PreferencesNode removeChildNode(String nodeName) {
        PreferencesNode node = this.nodes.remove(nodeName);
        if (node != null) {
            this.preferences.nodeChanged(new NodeChangeEvent(node.path(), NodeChangeEvent.Type.REMOVED));
        }
        return node;
    }

    @Override
    public PreferencesNode getChildNode(String nodeName) {
        return this.nodes.get(nodeName);
    }
}

