/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.prefs;

import griffon.plugins.preferences.Preferences;
import griffon.plugins.preferences.PreferencesNode;
import griffon.util.GriffonNameUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public abstract class AbstractPreferencesNode
implements PreferencesNode {
    protected final Preferences preferences;
    protected PreferencesNode parent;
    protected final String name;
    private String path;

    public AbstractPreferencesNode(Preferences preferences, PreferencesNode parent, String name) {
        this.preferences = preferences;
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String path() {
        if (null == this.path) {
            this.path = null == this.parent ? "/" : (this.parent.isRoot() ? this.parent.path() + this.name : this.parent.path() + "/" + this.name);
        }
        return this.path;
    }

    @Override
    public PreferencesNode parent() {
        return this.parent;
    }

    @Override
    public boolean isRoot() {
        return this.path().equals("/");
    }

    @Override
    public PreferencesNode merge(PreferencesNode other) {
        if (other != null) {
            for (String key : other.keys()) {
                this.putAt(key, other.getAt(key));
            }
            for (Map.Entry<String, PreferencesNode> child : other.children().entrySet()) {
                String childNodeName = child.getKey();
                PreferencesNode newChild = this.children().get(childNodeName);
                if (newChild == null) {
                    newChild = this.createChildNode(childNodeName);
                }
                newChild.merge(child.getValue());
                this.storeChildNode(childNodeName, newChild);
            }
        }
        return this;
    }

    protected boolean areEqual(Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return true;
        }
        if (oldValue == null && newValue != null || oldValue != null && newValue == null) {
            return false;
        }
        if (oldValue instanceof Map && newValue instanceof Map) {
            return DefaultGroovyMethods.equals((Map)((Map)oldValue), (Map)((Map)newValue));
        }
        if (oldValue instanceof Set && newValue instanceof Set) {
            return DefaultGroovyMethods.equals((Set)((Set)oldValue), (Set)((Set)newValue));
        }
        if (oldValue instanceof List && newValue instanceof List) {
            return DefaultGroovyMethods.equals((List)((List)oldValue), (List)((List)newValue));
        }
        return oldValue.equals(newValue);
    }

    @Override
    public PreferencesNode node(Class<?> clazz) {
        return clazz != null ? this.node(clazz.getName()) : null;
    }

    @Override
    public PreferencesNode node(String path) {
        String[] parsedPath = this.parsePath(path);
        if (parsedPath == null) {
            return null;
        }
        String nodeName = parsedPath[0];
        PreferencesNode node = this.getChildNode(nodeName);
        if (node == null) {
            node = this.createChildNode(nodeName);
            this.storeChildNode(nodeName, node);
        }
        if (!GriffonNameUtils.isBlank((String)parsedPath[1])) {
            node = node.node(parsedPath[1]);
        }
        return node;
    }

    @Override
    public PreferencesNode removeNode(Class<?> clazz) {
        return clazz != null ? this.removeNode(clazz.getName()) : null;
    }

    @Override
    public PreferencesNode removeNode(String path) {
        String[] parsedPath = this.parsePath(path);
        if (parsedPath == null) {
            return null;
        }
        String nodeName = parsedPath[0];
        PreferencesNode node = this.getChildNode(nodeName);
        if (node != null) {
            node = !GriffonNameUtils.isBlank((String)parsedPath[1]) ? node.removeNode(parsedPath[1]) : this.removeChildNode(nodeName);
        }
        return node;
    }

    private String[] parsePath(String path) {
        int split;
        if (GriffonNameUtils.isBlank((String)path) || !this.isRoot() && path.startsWith("/") || path.endsWith("/")) {
            return null;
        }
        path = path.replace('.', "/".charAt(0));
        if (this.isRoot() && path.startsWith("/")) {
            path = path.substring(1);
        }
        String head = (split = path.indexOf("/")) < 0 ? path : path.substring(0, split);
        String tail = split > 0 ? path.substring(split + 1) : null;
        return new String[]{head, tail};
    }
}

