/*
 * Decompiled with CFR 0.152.
 */
package griffon.pivot.editors;

import griffon.core.resources.editors.AbstractPropertyEditor;
import java.util.List;
import java.util.Map;
import org.apache.pivot.wtk.Bounds;

public class BoundsPropertyEditor
extends AbstractPropertyEditor {
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    public void setValue(Object value) {
        if (null == value) {
            return;
        }
        if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Bounds) {
            super.setValue(value);
        } else {
            throw this.illegalValue(value, Bounds.class);
        }
    }

    private void handleAsString(String str) {
        String[] parts = str.split(",");
        switch (parts.length) {
            case 4: {
                int x = this.parseValue(parts[0]);
                int y = this.parseValue(parts[1]);
                int w = this.parseValue(parts[2]);
                int h = this.parseValue(parts[3]);
                super.setValue((Object)new Bounds(x, y, w, h));
                break;
            }
            default: {
                throw this.illegalValue(str, Bounds.class);
            }
        }
    }

    private void handleAsList(List list) {
        switch (list.size()) {
            case 4: {
                int x = this.parseValue(list.get(0));
                int y = this.parseValue(list.get(1));
                int w = this.parseValue(list.get(2));
                int h = this.parseValue(list.get(3));
                super.setValue((Object)new Bounds(x, y, w, h));
                break;
            }
            default: {
                throw this.illegalValue(list, Bounds.class);
            }
        }
    }

    private void handleAsMap(Map map) {
        int x = this.getMapValue(map, "x", 0);
        int y = this.getMapValue(map, "y", 0);
        int w = this.getMapValue(map, "width", 0);
        int h = this.getMapValue(map, "height", 0);
        super.setValue((Object)new Bounds(x, y, w, h));
    }

    private int parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Bounds.class);
    }

    private int parse(String val) {
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Bounds.class, e);
        }
    }

    private int parse(Number val) {
        return val.intValue();
    }

    private int getMapValue(Map map, String key, int defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Bounds.class);
    }
}

