/*
 * Decompiled with CFR 0.152.
 */
package griffon.pivot;

import griffon.core.ApplicationPhase;
import griffon.core.GriffonApplication;
import griffon.core.ShutdownHandler;
import griffon.pivot.PivotGriffonApplication;
import griffon.pivot.support.adapters.WindowStateAdapter;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowManager
implements ShutdownHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WindowManager.class);
    private final PivotGriffonApplication app;
    private final WindowStateHelper windowStateHelper = new WindowStateHelper();
    private final List<Window> windows = new CopyOnWriteArrayList<Window>();
    private boolean hideBeforeHandler = false;

    public WindowManager(PivotGriffonApplication app) {
        this.app = app;
    }

    public Window findWindow(String name) {
        if (!GriffonNameUtils.isBlank((String)name)) {
            for (Window window : this.windows) {
                if (!name.equals(window.getName())) continue;
                return window;
            }
        }
        return null;
    }

    public Window getAt(int index) {
        return this.windows.get(index);
    }

    public Window getStartingWindow() {
        int index;
        Window window = null;
        Object value = ConfigUtils.getConfigValue((Map)this.app.getConfig(), (String)"pivot.windowManager.startingWindow");
        if (LOG.isDebugEnabled()) {
            LOG.debug("pivot.windowManager.startingWindow configured to " + value);
        }
        if (value == null || value instanceof ConfigObject) {
            if (this.windows.size() > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No startingWindow configured, selecting the first one in the list of windows");
                }
                window = this.windows.get(0);
            }
        } else if (value instanceof String) {
            String windowName = (String)value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window " + windowName + " as starting window");
            }
            window = this.findWindow(windowName);
        } else if (value instanceof Number && (index = ((Number)value).intValue()) >= 0 && index < this.windows.size()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Selecting window at index " + index + " as starting window");
            }
            window = this.windows.get(index);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting Window is " + window.getName());
        }
        return window;
    }

    public List<Window> getWindows() {
        return Collections.unmodifiableList(this.windows);
    }

    public void attach(Window window) {
        if (window == null || this.windows.contains(window)) {
            return;
        }
        window.getWindowStateListeners().add((Object)this.windowStateHelper);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Attaching window with name: '" + window.getName() + "' at index " + this.windows.size() + " " + window);
        }
        this.windows.add(window);
    }

    public void detach(Window window) {
        if (window == null) {
            return;
        }
        if (this.windows.contains(window)) {
            window.getWindowStateListeners().remove((Object)this.windowStateHelper);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Detaching window with name: '" + window.getName() + "' at index " + this.windows.indexOf(window) + " " + window);
            }
            this.windows.remove(window);
        }
    }

    public void show(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Showing window with name: '" + window.getName() + "' at index " + WindowManager.this.windows.indexOf(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().show(window, WindowManager.this.app);
            }
        });
    }

    public void show(String name) {
        Window window = this.findWindow(name);
        if (window != null) {
            this.show(window);
        }
    }

    public void hide(final Window window) {
        if (window == null) {
            return;
        }
        this.app.execInsideUISync(new Runnable(){

            @Override
            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Hiding window with name: '" + window.getName() + "' at index " + WindowManager.this.windows.indexOf(window) + " " + window);
                }
                WindowManager.this.app.resolveWindowDisplayHandler().hide(window, WindowManager.this.app);
            }
        });
    }

    public void hide(String name) {
        Window window = this.findWindow(name);
        if (window != null) {
            this.hide(window);
        }
    }

    public boolean canShutdown(GriffonApplication app) {
        return true;
    }

    public void onShutdown(GriffonApplication app) {
        for (Window window : this.windows) {
            if (!window.isVisible()) continue;
            this.hide(window);
        }
    }

    public boolean isHideBeforeHandler() {
        return this.hideBeforeHandler;
    }

    public void setHideBeforeHandler(boolean hideBeforeHandler) {
        this.hideBeforeHandler = hideBeforeHandler;
    }

    private class WindowStateHelper
    extends WindowStateAdapter {
        private WindowStateHelper() {
        }

        @Override
        public Vote previewWindowClose(Window arg0) {
            if (WindowManager.this.app.getPhase() == ApplicationPhase.SHUTDOWN) {
                return Vote.APPROVE;
            }
            int visibleWindows = 0;
            for (Window window : WindowManager.this.windows) {
                if (!window.isVisible()) continue;
                ++visibleWindows;
            }
            if (WindowManager.this.isHideBeforeHandler() || visibleWindows > 1) {
                WindowManager.this.hide(arg0);
            }
            Boolean autoShutdown = (Boolean)WindowManager.this.app.getConfig().flatten().get("application.autoShutdown");
            if (visibleWindows <= 1 && autoShutdown != null && autoShutdown.booleanValue()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Attempting to shutdown application");
                }
                if (!WindowManager.this.app.shutdown()) {
                    WindowManager.this.show(arg0);
                }
            }
            return Vote.APPROVE;
        }

        @Override
        public void windowOpened(Window arg0) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_SHOWN.getName(), Arrays.asList(arg0));
        }

        @Override
        public void windowClosed(Window arg0, Display arg1, Window arg2) {
            WindowManager.this.app.event(GriffonApplication.Event.WINDOW_HIDDEN.getName(), Arrays.asList(arg0));
        }
    }
}

