/*
 * Decompiled with CFR 0.152.
 */
package griffon.pivot;

import griffon.util.GriffonExceptionHandler;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.griffon.runtime.util.AbstractUIThreadHandler;

public class PivotUIThreadHandler
extends AbstractUIThreadHandler {
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = new GriffonExceptionHandler();

    public boolean isUIThread() {
        return EventQueue.isDispatchThread();
    }

    public void executeAsync(Runnable runnable) {
        EventQueue.invokeLater(runnable);
    }

    public void executeSync(Runnable runnable) {
        if (this.isUIThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), e);
            }
            catch (InvocationTargetException e) {
                UNCAUGHT_EXCEPTION_HANDLER.uncaughtException(Thread.currentThread(), e.getTargetException());
            }
        }
    }
}

