/*
 * Decompiled with CFR 0.152.
 */
package griffon.pivot;

import griffon.core.GriffonApplication;
import griffon.pivot.DefaultWindowDisplayHandler;
import griffon.pivot.PivotGriffonApplication;
import griffon.pivot.WindowDisplayHandler;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import griffon.util.RunnableWithArgs;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.Map;
import org.apache.pivot.wtk.Window;

public class ConfigurableWindowDisplayHandler
implements WindowDisplayHandler {
    private static final WindowDisplayHandler DEFAULT_WINDOW_DISPLAY_HANDLER = new DefaultWindowDisplayHandler();

    @Override
    public void show(Window window, PivotGriffonApplication application) {
        Object handler;
        Map<String, Object> options;
        String name = window.getName();
        if (!GriffonNameUtils.isBlank((String)name) && !(options = this.windowBlock(application, name)).isEmpty()) {
            handler = options.get("show");
            if (this.canBeRun(handler)) {
                this.run(handler, window, application);
                return;
            }
            if (options.get("handler") instanceof WindowDisplayHandler) {
                ((WindowDisplayHandler)options.get("handler")).show(window, application);
                return;
            }
        }
        if (!(options = this.windowManagerBlock(application)).isEmpty() && this.canBeRun(handler = options.get("defaultShow"))) {
            this.run(handler, window, application);
            return;
        }
        this.fetchDefaultWindowDisplayHandler(application).show(window, application);
    }

    @Override
    public void hide(Window window, PivotGriffonApplication application) {
        Object handler;
        Map<String, Object> options;
        String name = window.getName();
        if (!GriffonNameUtils.isBlank((String)name) && !(options = this.windowBlock(application, name)).isEmpty()) {
            handler = options.get("hide");
            if (this.canBeRun(handler)) {
                this.run(handler, window, application);
                return;
            }
            if (options.get("handler") instanceof WindowDisplayHandler) {
                ((WindowDisplayHandler)options.get("handler")).hide(window, application);
                return;
            }
        }
        if (!(options = this.windowManagerBlock(application)).isEmpty() && this.canBeRun(handler = options.get("defaultHide"))) {
            this.run(handler, window, application);
            return;
        }
        this.fetchDefaultWindowDisplayHandler(application).hide(window, application);
    }

    private boolean canBeRun(Object obj) {
        return obj instanceof Closure || obj instanceof RunnableWithArgs;
    }

    private void run(Object obj, Window window, GriffonApplication application) {
        if (obj instanceof Closure) {
            ((Closure)obj).call(new Object[]{window, application});
        } else {
            ((RunnableWithArgs)obj).run(new Object[]{window, application});
        }
    }

    private Map<String, Object> windowManagerBlock(GriffonApplication application) {
        Map<String, Object> block = (Map<String, Object>)ConfigUtils.getConfigValue((Map)application.getConfig(), (String)"pivot.windowManager");
        return block != null ? block : Collections.emptyMap();
    }

    private Map<String, Object> windowBlock(GriffonApplication application, String windowName) {
        Map<String, Object> options = this.windowManagerBlock(application);
        Map<String, Object> block = (Map<String, Object>)options.get(windowName);
        return block != null ? block : Collections.emptyMap();
    }

    private WindowDisplayHandler fetchDefaultWindowDisplayHandler(GriffonApplication application) {
        Object handler = this.windowManagerBlock(application).get("defaultHandler");
        return handler instanceof WindowDisplayHandler ? (WindowDisplayHandler)handler : DEFAULT_WINDOW_DISPLAY_HANDLER;
    }
}

