/*
 * Decompiled with CFR 0.152.
 */
package griffon.pivot;

import griffon.application.StandaloneGriffonApplication;
import griffon.core.UIThreadManager;
import griffon.pivot.ConfigurableWindowDisplayHandler;
import griffon.pivot.PivotGriffonApplication;
import griffon.pivot.PivotUIThreadHandler;
import griffon.pivot.WindowDisplayHandler;
import griffon.pivot.WindowManager;
import griffon.pivot.support.DisplayHolder;
import griffon.util.UIThreadHandler;
import groovy.lang.Closure;
import java.util.Arrays;
import org.apache.pivot.collections.Map;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Window;
import org.codehaus.griffon.runtime.core.AbstractGriffonApplication;

public abstract class AbstractPivotGriffonApplication
extends AbstractGriffonApplication
implements PivotGriffonApplication,
StandaloneGriffonApplication {
    private final WindowManager windowManager;
    private WindowDisplayHandler windowDisplayHandler;
    private final WindowDisplayHandler defaultWindowDisplayHandler = new ConfigurableWindowDisplayHandler();

    public AbstractPivotGriffonApplication() {
        this(EMPTY_ARGS);
    }

    public AbstractPivotGriffonApplication(String[] args) {
        super(args);
        this.windowManager = new WindowManager(this);
        UIThreadManager.getInstance().setUIThreadHandler(this.getUIThreadHandler());
        this.addShutdownHandler(this.windowManager);
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public WindowDisplayHandler getWindowDisplayHandler() {
        return this.windowDisplayHandler;
    }

    @Override
    public void setWindowDisplayHandler(WindowDisplayHandler windowDisplayHandler) {
        this.windowDisplayHandler = windowDisplayHandler;
    }

    protected UIThreadHandler getUIThreadHandler() {
        return new PivotUIThreadHandler();
    }

    @Override
    public final WindowDisplayHandler resolveWindowDisplayHandler() {
        return this.windowDisplayHandler != null ? this.windowDisplayHandler : this.defaultWindowDisplayHandler;
    }

    public void bootstrap() {
        this.initialize();
    }

    public void realize() {
        this.startup();
    }

    public void show() {
        Window startingWindow = this.windowManager.getStartingWindow();
        this.windowManager.show(startingWindow);
        this.callReady(startingWindow);
    }

    public boolean shutdown() {
        if (super.shutdown()) {
            this.exit();
        }
        return false;
    }

    public void exit() {
        System.exit(0);
    }

    public Object createApplicationContainer() {
        final Window[] window = new Window[1];
        UIThreadManager.getInstance().executeSync(new Runnable(){

            @Override
            public void run() {
                window[0] = new Window();
            }
        });
        return window[0];
    }

    protected void callReady(Window startingWindow) {
        this.ready();
    }

    public void startup(Display display, Map<String, String> properties) throws Exception {
        DisplayHolder.setDisplay(display);
        this.bootstrap();
        this.realize();
        this.show();
    }

    public boolean shutdown(boolean optional) {
        this.shutdown();
        return false;
    }

    public void suspend() {
        this.event("AppSuspend", Arrays.asList(this));
    }

    public void resume() {
        this.event("AppResume", Arrays.asList(this));
    }

    public void schedule(long delay, Closure callback) {
        ApplicationContext.scheduleCallback((Runnable)callback, (long)delay);
    }

    public void scheduleRecurring(long period, Closure callback) {
        ApplicationContext.scheduleRecurringCallback((Runnable)callback, (long)period);
    }

    public void scheduleRecurring(long delay, long period, Closure callback) {
        ApplicationContext.scheduleRecurringCallback((Runnable)callback, (long)delay, (long)period);
    }

    public void queue(Closure callback) {
        this.queue(false, callback);
    }

    public void queue(boolean wait, Closure callback) {
        ApplicationContext.queueCallback((Runnable)callback, (boolean)wait);
    }

    public ApplicationContext.ResourceCacheDictionary getResourceCache() {
        return ApplicationContext.getResourceCache();
    }
}

