/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.perf4j;

import griffon.plugins.perf4j.AbstractPerf4jProvider;
import griffon.plugins.perf4j.NoopStopWatch;
import griffon.util.ApplicationHolder;
import griffon.util.ConfigUtils;
import griffon.util.GriffonNameUtils;
import groovy.util.ConfigObject;
import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.perf4j.StopWatch;
import org.perf4j.slf4j.Slf4JStopWatch;

public class DefaultPerf4jProvider
extends AbstractPerf4jProvider {
    private static final DefaultPerf4jProvider INSTANCE = new DefaultPerf4jProvider();

    public static DefaultPerf4jProvider getInstance() {
        return INSTANCE;
    }

    private DefaultPerf4jProvider() {
    }

    @Override
    protected StopWatch getPerf4jStopWatch(Map<String, Object> params) {
        long longVal;
        ConfigObject config = DefaultPerf4jProvider.mergeParams(params);
        Slf4JStopWatch stopWatch = DefaultPerf4jProvider.createStopwatch(config);
        int intVal = DefaultPerf4jProvider.getInt(config, "exceptionPriority", Integer.MIN_VALUE);
        if (intVal != Integer.MIN_VALUE) {
            stopWatch.setExceptionPriority(intVal);
        }
        boolean normalAndSlowSuffixesEnabled = DefaultPerf4jProvider.getBoolean(config, "normalAndSlowSuffixesEnabled", false);
        stopWatch.setNormalAndSlowSuffixesEnabled(normalAndSlowSuffixesEnabled);
        intVal = DefaultPerf4jProvider.getInt(config, "normalPriority", Integer.MIN_VALUE);
        if (intVal != Integer.MIN_VALUE) {
            stopWatch.setNormalPriority(intVal);
        }
        if (normalAndSlowSuffixesEnabled) {
            String stringVal = DefaultPerf4jProvider.getString(config, "normalSuffix", "");
            if (!GriffonNameUtils.isBlank((String)stringVal)) {
                stopWatch.setNormalSuffix(stringVal);
            }
            if (!GriffonNameUtils.isBlank((String)(stringVal = DefaultPerf4jProvider.getString(config, "slowSuffix", "")))) {
                stopWatch.setSlowSuffix(stringVal);
            }
        }
        if ((longVal = DefaultPerf4jProvider.getLong(config, "timeThreshold", Long.MIN_VALUE)) != Long.MIN_VALUE) {
            stopWatch.setTimeThreshold(longVal);
        }
        return stopWatch;
    }

    private static Slf4JStopWatch createStopwatch(ConfigObject config) {
        String tag = ConfigUtils.getConfigValueAsString((Map)config, (String)"tag", (String)"");
        String message = ConfigUtils.getConfigValueAsString((Map)config, (String)"message", (String)"");
        if (ConfigUtils.getConfigValueAsBoolean((Map)config, (String)"enabled", (boolean)true)) {
            return !GriffonNameUtils.isBlank((String)message) ? new Slf4JStopWatch(tag, message) : new Slf4JStopWatch(tag);
        }
        return new NoopStopWatch();
    }

    private static ConfigObject mergeParams(Map<String, Object> params) {
        ConfigObject config = new ConfigObject();
        ConfigObject per4jConfig = (ConfigObject)ApplicationHolder.getApplication().getConfig().get((Object)"perf4j");
        if (null != per4jConfig) {
            config.merge(per4jConfig);
        }
        if (null != params) {
            config.putAll(params);
        }
        return config;
    }

    private static int getInt(ConfigObject config, String key, int defaultValue) {
        return ConfigUtils.getConfigValueAsInt((Map)config, (String)key, (int)defaultValue);
    }

    private static boolean getBoolean(ConfigObject config, String key, boolean defaultValue) {
        return ConfigUtils.getConfigValueAsBoolean((Map)config, (String)key, (boolean)defaultValue);
    }

    private static String getString(ConfigObject config, String key, String defaultValue) {
        return ConfigUtils.getConfigValueAsString((Map)config, (String)key, (String)defaultValue);
    }

    private static long getLong(ConfigObject config, String key, long defaultValue) {
        Object value = ConfigUtils.getConfigValue((Map)config, (String)key, (Object)defaultValue);
        return DefaultTypeTransformation.castToNumber((Object)value).longValue();
    }
}

