/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.dialog.task;

import com.ezware.common.Markup;
import com.ezware.common.OperatingSystem;
import com.ezware.dialog.task.IconComboBoxModel;
import com.ezware.dialog.task.LookAndFeel;
import com.ezware.dialog.task.TaskDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class TaskDialogTestBed
extends JFrame {
    private final JCheckBox cbDebug = new JCheckBox("Debug");
    private final JPanel pDetails = new JPanel();
    private final JPanel pFooter = new JPanel();
    private final JPanel pCommons = new JPanel();
    private final JTextField txCheckBoxText;
    private final JTextField txFooterText;
    private final JTextField txInstruction = new JTextField();
    private final JTextField txTitle = new JTextField();
    private final JComboBox cbIcon = new JComboBox();
    private final JTextArea txText = new JTextArea();
    private final JCheckBox cbDetailsExpanded = new JCheckBox("Expanded");
    private final JTextField txCollapsedLabel = new JTextField("More Details");
    private final JTextField txExpandedLabel = new JTextField("Fewer Details");
    private final JComboBox cbFooterIcon = new JComboBox();
    private final JCheckBox cbFooterCheckBoxSelected = new JCheckBox("Check Box Selected");
    private final JComboBox cbLaf = new JComboBox(LookAndFeel.getComboModel(lafs));
    private final JLabel lblLookAndFeel = new JLabel("Look And Feel");
    private static UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();

    public TaskDialogTestBed(int lafIndex) {
        this.setResizable(false);
        this.setTitle("Task  Dialog Test Bed");
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout((LayoutManager)new MigLayout("", "[pref!][238.00,grow][][-91.00][pref!,grow]", "[pref!,grow][pref!][][]"));
        this.pCommons.setBorder(new TitledBorder(null, "", 4, 2, null, null));
        this.getContentPane().add((Component)this.pCommons, "cell 0 0 5 1,grow");
        this.pCommons.setLayout((LayoutManager)new MigLayout("", "[46px][352px,grow]", "[][][][48px,grow]"));
        JLabel lblTitle = new JLabel("Title");
        lblTitle.setHorizontalAlignment(11);
        this.pCommons.add((Component)lblTitle, "cell 0 0,alignx trailing");
        this.txTitle.setText("Application Error");
        this.pCommons.add((Component)this.txTitle, "cell 1 0,growx");
        JLabel lbInstruction = new JLabel("Instruction");
        lbInstruction.setHorizontalAlignment(11);
        this.pCommons.add((Component)lbInstruction, "cell 0 1,alignx trailing");
        this.txInstruction.setText("CRASH AND BURN!");
        this.pCommons.add((Component)this.txInstruction, "cell 1 1,growx");
        JLabel lbIcon = new JLabel("Icon");
        lbIcon.setHorizontalAlignment(11);
        this.pCommons.add((Component)lbIcon, "cell 0 2,growx,aligny center");
        this.pCommons.add((Component)this.cbIcon, "cell 1 2,alignx left,aligny top");
        JLabel lbText = new JLabel("Text");
        lbText.setHorizontalAlignment(11);
        this.pCommons.add((Component)lbText, "cell 0 3,growx,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        this.pCommons.add((Component)scrollPane, "cell 1 3,grow");
        this.txText.setText("The applicaiton has performed an illegal action.\n This action has been logged and reported.");
        this.txText.setFont(this.txInstruction.getFont());
        scrollPane.setViewportView(this.txText);
        this.pDetails.setBorder(new TitledBorder(null, " Details ", 4, 2, null, null));
        this.getContentPane().add((Component)this.pDetails, "cell 0 1 5 1,grow");
        this.pDetails.setLayout((LayoutManager)new MigLayout("", "[80px][318px,grow]", "[20px][20px][23px]"));
        this.cbDetailsExpanded.setHorizontalAlignment(11);
        this.pDetails.add((Component)this.cbDetailsExpanded, "cell 1 2,alignx right,aligny top");
        this.pDetails.add((Component)this.txCollapsedLabel, "cell 1 0,growx,aligny top");
        JLabel lbCollapsedLabel = new JLabel("Collapsed Label");
        lbCollapsedLabel.setHorizontalAlignment(11);
        this.pDetails.add((Component)lbCollapsedLabel, "cell 0 0,growx,aligny center");
        JLabel lbExpandedLabel = new JLabel("Expanded Label");
        lbExpandedLabel.setHorizontalAlignment(11);
        this.pDetails.add((Component)lbExpandedLabel, "cell 0 1,growx,aligny center");
        this.pDetails.add((Component)this.txExpandedLabel, "cell 1 1,growx,aligny top");
        JButton button = new JButton("Show Task Dialog");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialogTestBed.this.showTaskDialog();
            }
        });
        this.pFooter.setBorder(new TitledBorder(null, "Footer", 4, 2, null, null));
        this.getContentPane().add((Component)this.pFooter, "cell 0 2 5 1,grow");
        this.pFooter.setLayout((LayoutManager)new MigLayout("", "[78px][231px,grow]", "[23px][20px][20px][20px]"));
        JLabel lbFooterText = new JLabel("Text");
        lbFooterText.setHorizontalAlignment(11);
        this.pFooter.add((Component)lbFooterText, "cell 0 0,growx,aligny center");
        this.txFooterText = new JTextField();
        this.txFooterText.setText("Your application chrashed because a developer forgot to write a unit test");
        this.txFooterText.setColumns(10);
        this.pFooter.add((Component)this.txFooterText, "cell 1 0,growx,aligny top");
        JLabel lbFooterIcon = new JLabel("Icon");
        lbFooterIcon.setHorizontalAlignment(11);
        this.pFooter.add((Component)lbFooterIcon, "cell 0 1,alignx right,aligny center");
        this.pFooter.add((Component)this.cbFooterIcon, "cell 1 1,alignx left,aligny top");
        JLabel lbCheckBoxText = new JLabel("Check Box Text");
        lbCheckBoxText.setHorizontalAlignment(11);
        this.pFooter.add((Component)lbCheckBoxText, "cell 0 2,alignx left,aligny center");
        this.txCheckBoxText = new JTextField();
        this.txCheckBoxText.setText("Perform this action every time");
        this.txCheckBoxText.setColumns(10);
        this.pFooter.add((Component)this.txCheckBoxText, "cell 1 2,growx,aligny top");
        this.cbFooterCheckBoxSelected.setHorizontalAlignment(11);
        this.pFooter.add((Component)this.cbFooterCheckBoxSelected, "cell 1 3,alignx right");
        this.getContentPane().add((Component)this.lblLookAndFeel, "cell 0 3,alignx trailing");
        this.getContentPane().add((Component)this.cbLaf, "cell 1 3,alignx left");
        this.cbDebug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDialog.setDebugMode(TaskDialogTestBed.this.cbDebug.isSelected());
            }
        });
        this.getContentPane().add((Component)this.cbDebug, "cell 2 3,grow");
        this.getContentPane().add((Component)button, "cell 4 3,alignx trailing");
        this.cbLaf.setSelectedIndex(lafIndex);
        this.cbLaf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LookAndFeel laf = (LookAndFeel)TaskDialogTestBed.this.cbLaf.getSelectedItem();
                        try {
                            UIManager.setLookAndFeel(laf.getName());
                            SwingUtilities.updateComponentTreeUI(TaskDialogTestBed.this);
                            TaskDialogTestBed.this.getContentPane().validate();
                            TaskDialogTestBed.this.pack();
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        this.updateIconModels();
        this.cbIcon.setSelectedIndex(3);
    }

    private void updateIconModels() {
        this.cbIcon.setModel(new IconComboBoxModel(TaskDialog.StandardIcon.values()));
        this.cbFooterIcon.setModel(new IconComboBoxModel(TaskDialog.StandardIcon.values(), 16, 16));
    }

    private void showTaskDialog() {
        TaskDialog dlg = new TaskDialog(null, this.txTitle.getText());
        dlg.setInstruction(this.txInstruction.getText());
        dlg.setText(this.txText.getText());
        dlg.setIcon((Icon)this.cbIcon.getSelectedItem());
        dlg.getDetails().setExpandableComponent(new JLabel(Markup.toHTML("Here are some details.\n 123456789")));
        dlg.getDetails().setCollapsedLabel(this.txCollapsedLabel.getText());
        dlg.getDetails().setExpandedLabel(this.txExpandedLabel.getText());
        dlg.getDetails().setExpanded(this.cbDetailsExpanded.isSelected());
        dlg.getFooter().setText(this.txFooterText.getText());
        dlg.getFooter().setIcon((Icon)this.cbFooterIcon.getSelectedItem());
        dlg.getFooter().setCheckBoxText(this.txCheckBoxText.getText());
        dlg.getFooter().setCheckBoxSelected(this.cbFooterCheckBoxSelected.isSelected());
        dlg.addPropertyListener("result", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println("Result is set to " + evt.getNewValue());
            }
        });
        dlg.show();
    }

    public static void main(String[] args) {
        System.out.println("Running on " + (Object)((Object)OperatingSystem.getCurrent()));
        int index = 0;
        String sysLaf = UIManager.getSystemLookAndFeelClassName();
        int i = 0;
        while (i < lafs.length) {
            if (lafs[i].getClassName().equals(sysLaf)) {
                index = i;
                break;
            }
            ++i;
        }
        try {
            UIManager.setLookAndFeel(lafs[index].getClassName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        final int lafIndex = index;
        Locale.setDefault(new Locale("es", "ES"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TaskDialogTestBed testBed = new TaskDialogTestBed(lafIndex);
                testBed.pack();
                testBed.setLocationRelativeTo(null);
                testBed.setVisible(true);
            }
        });
    }

    static abstract class TaskDialogExample
    implements Runnable {
        protected String title;

        TaskDialogExample() {
        }

        protected abstract TaskDialog getDialog();

        public String toString() {
            if (this.title == null) {
                this.title = this.getDialog().getTitle();
            }
            return this.title;
        }

        @Override
        public void run() {
            this.getDialog().show();
        }
    }
}

