/*
 * Decompiled with CFR 0.152.
 */
package com.ezware.dialog.task;

import com.ezware.common.EmptyIcon;
import com.ezware.common.Strings;
import com.ezware.common.SwingBean;
import com.ezware.dialog.task.ContentDesignFactory;
import com.ezware.dialog.task.IContentDesign;
import com.ezware.dialog.task.design.TaskDialogContent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class TaskDialog
extends SwingBean {
    private static final String INSTANCE_PROPERTY = "task.dialog.instance";
    private static final String DEBUG_PROPERTY = "task.dialog.debug";
    static final String I18N_PREFIX = "@@";
    private static final String LOCALE_BUNDLE_NAME = "task-dialog";
    private static IContentDesign design = ContentDesignFactory.getDesignByOperatingSystem();
    private static final KeyStroke KS_ESCAPE;
    private static final KeyStroke KS_ENTER;
    private static final KeyStroke KS_F1;
    private Locale resourceBundleLocale = null;
    private ResourceBundle resourceBundle = null;
    private Command result = StandardCommand.CANCEL;
    private final JDialog dlg;
    private final TaskDialogContent content;
    private Set<Command> commands = new LinkedHashSet<StandardCommand>(Arrays.asList(StandardCommand.OK));
    private final List<ValidationListener> validationListeners = new ArrayList<ValidationListener>();

    static {
        TaskDialog.getDesign().updateUIDefaults();
        KS_ESCAPE = KeyStroke.getKeyStroke(27, 0);
        KS_ENTER = KeyStroke.getKeyStroke(10, 0);
        KS_F1 = KeyStroke.getKeyStroke(112, 0);
    }

    static final IContentDesign getDesign() {
        return design;
    }

    public static final String makeKey(String text) {
        return I18N_PREFIX + text;
    }

    public static final TaskDialog getInstance(Component source) {
        Window w = SwingUtilities.getWindowAncestor(source);
        if (w instanceof JDialog) {
            JComponent c = (JComponent)((JDialog)w).getContentPane();
            return (TaskDialog)c.getClientProperty(INSTANCE_PROPERTY);
        }
        return null;
    }

    public static final void setDebugMode(boolean debug) {
        if (debug) {
            System.setProperty(DEBUG_PROPERTY, "true");
        } else {
            System.clearProperty(DEBUG_PROPERTY);
        }
    }

    public static final boolean isDebugMode() {
        return System.getProperty(DEBUG_PROPERTY) != null;
    }

    public TaskDialog(Window parent, String title) {
        Window pWnd = parent;
        if (pWnd == null) {
            pWnd = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            while (pWnd != null && !pWnd.isVisible() && pWnd.getParent() != null) {
                pWnd = (Window)pWnd.getParent();
            }
        }
        this.dlg = new JDialog(pWnd);
        this.dlg.setMinimumSize(new Dimension(300, 150));
        this.setResizable(false);
        this.setModalityType(JDialog.DEFAULT_MODALITY_TYPE);
        this.dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TaskDialog.this.result = StandardCommand.CANCEL;
            }
        });
        this.setTitle(title);
        this.content = design.buildContent();
        this.dlg.setContentPane(this.content);
        JComponent c = (JComponent)this.dlg.getContentPane();
        c.putClientProperty(INSTANCE_PROPERTY, this);
    }

    public Dialog.ModalityType getModalityType() {
        return this.dlg.getModalityType();
    }

    public void setModalityType(Dialog.ModalityType modalityType) {
        this.dlg.setModalityType(modalityType);
    }

    public boolean isResizable() {
        return this.dlg.isResizable();
    }

    public void setResizable(boolean resizable) {
        this.dlg.setResizable(resizable);
    }

    public final void addValidationListener(ValidationListener listener) {
        if (listener != null) {
            this.validationListeners.add(listener);
        }
    }

    public final void removeValidationListener(ValidationListener listener) {
        if (listener != null) {
            this.validationListeners.remove(listener);
        }
    }

    public final void fireValidationFinished(boolean validationResult) {
        ListIterator<ValidationListener> iter = this.validationListeners.listIterator();
        while (iter.hasPrevious()) {
            iter.previous().validationFinished(validationResult);
        }
    }

    public Locale getLocale() {
        return this.dlg.getLocale();
    }

    public void setLocale(Locale locale) {
        this.dlg.setLocale(locale);
    }

    private final synchronized ResourceBundle getLocaleBundle() {
        Locale currentLocale = this.getLocale();
        if (!currentLocale.equals(this.resourceBundleLocale)) {
            this.resourceBundleLocale = currentLocale;
            this.resourceBundle = ResourceBundle.getBundle(LOCALE_BUNDLE_NAME, this.resourceBundleLocale, this.getClass().getClassLoader());
        }
        return this.resourceBundle;
    }

    public String getLocalizedString(String key) {
        try {
            return this.getLocaleBundle().getString(key);
        }
        catch (MissingResourceException ex) {
            return String.format("<%s>", key);
        }
    }

    public String getString(String text) {
        return text.startsWith(I18N_PREFIX) ? this.getLocalizedString(text.substring(I18N_PREFIX.length())) : text;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.content.setCommands(this.commands, TaskDialog.getDesign().isCommandButtonSizeLocked());
        }
        if (!this.firePropertyChange("visible", this.isVisible(), visible)) {
            return;
        }
        if (visible) {
            this.dlg.pack();
            this.dlg.setLocationRelativeTo(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
            this.dlg.setVisible(true);
        } else {
            this.dlg.dispose();
        }
    }

    public boolean isVisible() {
        return this.dlg.isVisible();
    }

    public Command getResult() {
        return this.result;
    }

    public void setResult(Command result) {
        this.result = result;
        this.firePropertyChange("result", null, result);
    }

    public Command show() {
        this.setVisible(true);
        return this.getResult();
    }

    public String toString() {
        return this.getTitle();
    }

    public String getTitle() {
        return this.dlg.getTitle();
    }

    public void setTitle(String title) {
        this.dlg.setTitle(this.getString(title));
    }

    public void setIcon(Icon icon) {
        if (this.firePropertyChange("icon", this.getIcon(), icon)) {
            this.content.setMainIcon(icon);
        }
    }

    public Icon getIcon() {
        return this.content.getMainIcon();
    }

    public void setInstruction(String instruction) {
        if (this.firePropertyChange("instruction", this.getInstruction(), instruction)) {
            this.content.setInstruction(instruction);
        }
    }

    public String getInstruction() {
        return this.content.getInstruction();
    }

    public void setText(String text) {
        if (this.firePropertyChange("text", this.getText(), text)) {
            this.content.setMainText(text);
        }
    }

    public String getText() {
        return this.content.getMainText();
    }

    public void setFixedComponent(JComponent c) {
        this.content.setComponent(c);
    }

    public JComponent getFixedComponent() {
        return this.content.getComponent();
    }

    public Details getDetails() {
        return this.content;
    }

    public Footer getFooter() {
        return this.content;
    }

    public void setCommands(Collection<Command> commands) {
        this.commands = new LinkedHashSet<Command>(commands);
    }

    public void setCommands(Command ... commands) {
        this.setCommands(Arrays.asList(commands));
    }

    public Collection<Command> getCommands() {
        return this.commands;
    }

    public boolean isCommandsVisible() {
        return this.content.isCommandsVisible();
    }

    public void setCommandsVisible(boolean visible) {
        this.content.setCommandsVisible(visible);
    }

    static /* synthetic */ KeyStroke access$0() {
        return KS_ENTER;
    }

    static /* synthetic */ KeyStroke access$1() {
        return KS_ESCAPE;
    }

    static /* synthetic */ KeyStroke access$2() {
        return KS_F1;
    }

    public static interface Command {
        public String getTitle();

        public CommandTag getTag();

        public String getDescription();

        public boolean isClosing();

        public int getWaitInterval();

        public boolean isEnabled(boolean var1);

        public KeyStroke getKeyStroke();
    }

    public static enum CommandTag {
        OK("ok", TaskDialog.access$0(), true, true),
        CANCEL("cancel", TaskDialog.access$1(), true),
        HELP("help", TaskDialog.access$2(), false),
        HELP2("help2", "Help", TaskDialog.access$2(), false),
        YES("yes", TaskDialog.access$0(), true, true),
        NO("yes", TaskDialog.access$1(), true),
        APPLY("apply"),
        NEXT("next", true, false),
        BACK("back"),
        FINISH("finish", TaskDialog.access$0(), true, true),
        LEFT("left"),
        RIGHT("right");

        private String tag;
        private final String defaultTitle;
        private boolean useValidationResult = false;
        private boolean closing;
        private KeyStroke defaultKeyStroke;

        private CommandTag(String tag, String defaultTitle, KeyStroke defaultKeyStroke, boolean useValidationResult, boolean closing) {
            this.tag = "tag " + tag;
            this.defaultTitle = TaskDialog.makeKey(Strings.isEmpty(defaultTitle) ? Strings.capitalize(tag) : defaultTitle);
            this.useValidationResult = useValidationResult;
            this.closing = closing;
            this.defaultKeyStroke = defaultKeyStroke;
        }

        private CommandTag(String tag, String defaultTitle, KeyStroke defaultKeyStroke, boolean closing) {
            this(tag, defaultTitle, defaultKeyStroke, false, closing);
        }

        private CommandTag(String tag, KeyStroke defaultKeyStroke, boolean closing) {
            this(tag, null, defaultKeyStroke, false, closing);
        }

        private CommandTag(String tag, boolean closing) {
            this(tag, null, closing);
        }

        private CommandTag(String tag) {
            this(tag, false);
        }

        private CommandTag(String tag, KeyStroke defaultKeyStroke, boolean useValidationResult, boolean closing) {
            this(tag, null, defaultKeyStroke, useValidationResult, closing);
        }

        private CommandTag(String tag, boolean useValidationResult, boolean closing) {
            this(tag, null, useValidationResult, closing);
        }

        public String getDefaultTitle() {
            return this.defaultTitle;
        }

        public String toString() {
            return this.tag;
        }

        public boolean isEnabled(boolean validationResult) {
            return this.useValidationResult ? validationResult : true;
        }

        public boolean isClosing() {
            return this.closing;
        }

        public KeyStroke getDefaultKeyStroke() {
            return this.defaultKeyStroke;
        }
    }

    public static abstract class CustomCommand
    implements Command {
        private final StandardCommand command;

        public CustomCommand(StandardCommand command) {
            if (command == null) {
                throw new IllegalArgumentException("Command should not be null");
            }
            this.command = command;
        }

        @Override
        public String getDescription() {
            return this.command.getDescription();
        }

        @Override
        public CommandTag getTag() {
            return this.command.getTag();
        }

        @Override
        public String getTitle() {
            return this.command.getTitle();
        }

        @Override
        public boolean isClosing() {
            return this.command.isClosing();
        }

        @Override
        public int getWaitInterval() {
            return this.command.getWaitInterval();
        }

        @Override
        public boolean isEnabled(boolean validationResult) {
            return this.command.isEnabled(validationResult);
        }

        public boolean equals(Object obj) {
            return this.command.equals(obj);
        }

        public int hashCode() {
            return this.command.hashCode();
        }

        @Override
        public KeyStroke getKeyStroke() {
            return this.command.getKeyStroke();
        }
    }

    public static interface Details {
        public String getCollapsedLabel();

        public void setCollapsedLabel(String var1);

        public String getExpandedLabel();

        public void setExpandedLabel(String var1);

        public boolean isExpanded();

        public void setExpanded(boolean var1);

        public void setAlwaysExpanded(boolean var1);

        public boolean isAlwaysExpanded();

        public JComponent getExpandableComponent();

        public void setExpandableComponent(JComponent var1);
    }

    public static interface Footer {
        public boolean isCheckBoxSelected();

        public void setCheckBoxSelected(boolean var1);

        public String getCheckBoxText();

        public void setCheckBoxText(String var1);

        public Icon getIcon();

        public void setIcon(Icon var1);

        public String getText();

        public void setText(String var1);
    }

    public static enum StandardCommand implements Command
    {
        OK(CommandTag.OK),
        CANCEL(CommandTag.CANCEL);

        private final CommandTag tag;

        private StandardCommand(CommandTag tag) {
            this.tag = tag;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public CommandTag getTag() {
            return this.tag;
        }

        @Override
        public String getTitle() {
            return this.tag.getDefaultTitle();
        }

        @Override
        public boolean isClosing() {
            return this.tag.isClosing();
        }

        @Override
        public int getWaitInterval() {
            return 0;
        }

        @Override
        public boolean isEnabled(boolean validationResult) {
            return this.tag.isEnabled(validationResult);
        }

        @Override
        public KeyStroke getKeyStroke() {
            return this.tag.getDefaultKeyStroke();
        }

        public Command derive(final String title, final int waitInterval) {
            return new CustomCommand(this){

                @Override
                public String getTitle() {
                    return title;
                }

                @Override
                public int getWaitInterval() {
                    return waitInterval;
                }
            };
        }

        public Command derive(final String title) {
            return new CustomCommand(this){

                @Override
                public String getTitle() {
                    return title;
                }
            };
        }
    }

    public static enum StandardIcon implements Icon
    {
        INFO("OptionPane.informationIcon"),
        QUESTION("OptionPane.questionIcon"),
        WARNING("OptionPane.warningIcon"),
        ERROR("OptionPane.errorIcon");

        private final String key;
        private Icon emptyIcon;

        private StandardIcon(String key) {
            this.key = key;
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getIcon().paintIcon(c, g, x, y);
        }

        private synchronized Icon getIcon() {
            Icon icon = UIManager.getIcon(this.key);
            return icon == null ? this.getEmptyIcon() : icon;
        }

        private synchronized Icon getEmptyIcon() {
            if (this.emptyIcon == null) {
                this.emptyIcon = EmptyIcon.hidden();
            }
            return this.emptyIcon;
        }
    }

    public static interface ValidationListener {
        public void validationFinished(boolean var1);
    }
}

