/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.orientdb;

import com.orientechnologies.orient.core.db.ODatabase;
import griffon.plugins.orientdb.OrientdbProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrientdbProvider
implements OrientdbProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOrientdbProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withOrientdb(Closure<R> closure) {
        return this.withOrientdb(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withOrientdb(String databaseName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (closure != null) {
            ODatabase database = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            try {
                Object object = closure.call(new Object[]{databaseName, database});
                return (R)object;
            }
            finally {
                database.close();
            }
        }
        return null;
    }

    @Override
    public <R> R withOrientdb(CallableWithArgs<R> callable) {
        return this.withOrientdb(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withOrientdb(String databaseName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)databaseName)) {
            databaseName = DEFAULT;
        }
        if (callable != null) {
            ODatabase database = this.getDatabase(databaseName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing statement on databaseName '" + databaseName + "'");
            }
            try {
                callable.setArgs(new Object[]{databaseName, database});
                Object object = callable.call();
                return (R)object;
            }
            finally {
                database.close();
            }
        }
        return null;
    }

    protected abstract ODatabase getDatabase(String var1);
}

