/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.orientdb.OrientdbAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.OrientdbAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleOrientdbAware
extends EclipseAnnotationHandler<OrientdbAware> {
    private final EclipseOrientdbAwareHandler handler = new EclipseOrientdbAwareHandler();

    public void handle(AnnotationValues<OrientdbAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(OrientdbAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.orientdb.OrientdbContributionHandler", (Annotation)source);
        this.handler.addOrientdbProviderField(type);
        this.handler.addOrientdbProviderAccessors(type);
        this.handler.addOrientdbContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseOrientdbAwareHandler
    extends OrientdbAwareHandler<EclipseType> {
        private EclipseOrientdbAwareHandler() {
        }
    }
}

