/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.test;

import com.orientechnologies.common.test.SpeedTestAbstract;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(alwaysRun=true)
public abstract class SpeedTestGroup {
    protected static final int TIME_WAIT = 1000;
    protected List<SpeedTestAbstract> tests = new ArrayList<SpeedTestAbstract>();
    protected HashMap<String, TreeMap<Long, String>> results = new HashMap();

    protected SpeedTestGroup() {
    }

    public void go() {
        for (SpeedTestAbstract test : this.tests) {
            test.data().go(test);
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected SpeedTestAbstract addTest(SpeedTestAbstract test) {
        test.data.setTestGroup(this);
        this.tests.add(test);
        return test;
    }

    public void setResult(String iResultType, String iTestName, long iResult) {
        TreeMap<Long, String> result = this.results.get(iResultType);
        if (result == null) {
            result = new TreeMap();
            this.results.put(iResultType, result);
        }
        result.put(iResult, iTestName);
    }

    @AfterClass
    protected void tearDown() throws Exception {
        this.printResults();
    }

    protected void printResults() {
        System.out.println("FINAL RESULTS (faster is the first one):");
        for (Map.Entry<String, TreeMap<Long, String>> result : this.results.entrySet()) {
            System.out.println("+ " + result.getKey() + ":");
            int i = 1;
            long refValue = 0L;
            for (Map.Entry<Long, String> entry : result.getValue().entrySet()) {
                if (i == 1) {
                    System.out.println(" " + i++ + ": " + entry.getValue() + " = " + entry.getKey());
                    refValue = entry.getKey();
                    continue;
                }
                System.out.println(" " + i++ + ": " + entry.getValue() + " = " + entry.getKey() + " (+" + (entry.getKey() * 100L / refValue - 100L) + "%)");
            }
            System.out.println();
        }
    }
}

