/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.profiler.OProfilerMBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OProfiler
implements OProfilerMBean {
    private long recording = -1L;
    private Map<String, Long> counters;
    private Map<String, OProfilerEntry> chronos;
    private Map<String, OProfilerEntry> stats;
    private Map<OProfilerHookValue, String> hooks;
    private Date lastReset;
    private volatile Timer timer;
    private volatile boolean autoDumpReset;
    protected static final OProfiler instance = new OProfiler();

    public OProfiler() {
        this.init();
    }

    public OProfiler(String iRecording) {
        if (iRecording.equalsIgnoreCase("true")) {
            this.startRecording();
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCounter(String iStatName, long iPlus) {
        if (iStatName == null) {
            return;
        }
        if (this.recording < 0L) {
            return;
        }
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long stat = this.counters.get(iStatName);
            long oldValue = stat == null ? 0L : stat;
            stat = new Long(oldValue + iPlus);
            this.counters.put(iStatName, stat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCounter(String iStatName) {
        if (iStatName == null) {
            return -1L;
        }
        if (this.recording < 0L) {
            return -1L;
        }
        Map<String, Long> map = this.counters;
        synchronized (map) {
            Long stat = this.counters.get(iStatName);
            if (stat == null) {
                return -1L;
            }
            return stat;
        }
    }

    @Override
    public String dump() {
        float maxMem = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        float totMem = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        float freeMem = maxMem - totMem;
        long now = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder();
        buffer.append("\nOrientDB profiler dump of ");
        buffer.append(new Date(now));
        buffer.append(" after ");
        buffer.append((now - this.recording) / 1000L);
        buffer.append(" secs of profiling");
        buffer.append(String.format("\nFree memory: %2.2fMb (%2.2f%%) - Total memory: %2.2fMb - Max memory: %2.2fMb - CPUs: %d", Float.valueOf(freeMem), Float.valueOf(freeMem * 100.0f / maxMem), Float.valueOf(totMem), Float.valueOf(maxMem), Runtime.getRuntime().availableProcessors()));
        buffer.append("\n");
        buffer.append(this.dumpHookValues());
        buffer.append("\n");
        buffer.append(this.dumpCounters());
        buffer.append("\n\n");
        buffer.append(this.dumpStats());
        buffer.append("\n\n");
        buffer.append(this.dumpChronos());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<String, Object> map;
        this.lastReset = new Date();
        if (this.counters != null) {
            map = this.counters;
            synchronized (map) {
                this.counters.clear();
            }
        }
        if (this.chronos != null) {
            map = this.chronos;
            synchronized (map) {
                this.chronos.clear();
            }
        }
        if (this.stats != null) {
            map = this.stats;
            synchronized (map) {
                this.stats.clear();
            }
        }
    }

    @Override
    public long startChrono() {
        if (this.recording < 0L) {
            return -1L;
        }
        return System.currentTimeMillis();
    }

    @Override
    public long stopChrono(String iName, long iStartTime) {
        return this.updateEntry(this.chronos, iName, System.currentTimeMillis() - iStartTime);
    }

    public long updateStat(String iName, long iValue) {
        return this.updateEntry(this.stats, iName, iValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String dumpCounters() {
        if (this.recording < 0L) {
            return "Counters: <no recording>";
        }
        StringBuilder buffer = new StringBuilder();
        Map<String, Long> map = this.counters;
        synchronized (map) {
            buffer.append("DUMPING COUNTERS (last reset on: " + this.lastReset.toString() + ")...");
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            buffer.append(String.format("\n%50s | Value                                                             |", "Name"));
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> keys = new ArrayList<String>(this.counters.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                Long stat = this.counters.get(k);
                buffer.append(String.format("\n%-50s | %-65d |", k, stat));
            }
        }
        buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
        return buffer.toString();
    }

    @Override
    public String dumpChronos() {
        return this.dumpEntries(this.chronos, new StringBuilder("DUMPING CHRONOS (last reset on: " + this.lastReset.toString() + "). Times in ms..."));
    }

    public String dumpStats() {
        return this.dumpEntries(this.stats, new StringBuilder("DUMPING STATISTICS (last reset on: " + this.lastReset.toString() + "). Times in ms..."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpHookValues() {
        if (this.recording < 0L) {
            return "HookValues: <no recording>";
        }
        StringBuilder buffer = new StringBuilder();
        Map<OProfilerHookValue, String> map = this.hooks;
        synchronized (map) {
            if (this.hooks.size() == 0) {
                return "";
            }
            buffer.append("HOOK VALUES:");
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            buffer.append(String.format("\n%50s | Value                                                             |", "Name"));
            buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> names = new ArrayList<String>(this.hooks.values());
            Collections.sort(names);
            block3: for (String k : names) {
                for (Map.Entry<OProfilerHookValue, String> v : this.hooks.entrySet()) {
                    if (!v.getValue().equals(k)) continue;
                    OProfilerHookValue hook = v.getKey();
                    if (hook == null) continue block3;
                    Object hookValue = hook.getValue();
                    buffer.append(String.format("\n%-50s | %-65s |", k, hookValue != null ? hookValue.toString() : "null"));
                    continue block3;
                }
            }
        }
        buffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
        return buffer.toString();
    }

    public Object getHookValue(String iName) {
        for (Map.Entry<OProfilerHookValue, String> v : this.hooks.entrySet()) {
            OProfilerHookValue h;
            if (!v.getValue().equals(iName) || (h = v.getKey()) == null) continue;
            return h.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getCountersAsString() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            String[] output = new String[this.counters.size()];
            int i = 0;
            for (Map.Entry<String, Long> entry : this.counters.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChronosAsString() {
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            String[] output = new String[this.chronos.size()];
            int i = 0;
            for (Map.Entry<String, OProfilerEntry> entry : this.chronos.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStatsAsString() {
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            String[] output = new String[this.stats.size()];
            int i = 0;
            for (Map.Entry<String, OProfilerEntry> entry : this.stats.entrySet()) {
                output[i++] = entry.getKey() + ": " + entry.getValue().toString();
            }
            return output;
        }
    }

    @Override
    public Date getLastReset() {
        return this.lastReset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCounters() {
        Map<String, Long> map = this.counters;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.counters.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getHooks() {
        Map<OProfilerHookValue, String> map = this.hooks;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.hooks.values());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChronos() {
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.chronos.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getStats() {
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            ArrayList<String> list = new ArrayList<String>(this.stats.keySet());
            Collections.sort(list);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerEntry getStat(String iStatName) {
        Map<String, OProfilerEntry> map = this.stats;
        synchronized (map) {
            return this.stats.get(iStatName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OProfilerEntry getChrono(String iChronoName) {
        Map<String, OProfilerEntry> map = this.chronos;
        synchronized (map) {
            return this.chronos.get(iChronoName);
        }
    }

    @Override
    public boolean isRecording() {
        return this.recording > -1L;
    }

    @Override
    public OProfilerMBean startRecording() {
        this.recording = System.currentTimeMillis();
        return this;
    }

    @Override
    public OProfilerMBean stopRecording() {
        this.recording = -1L;
        return this;
    }

    public static OProfiler getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHookValue(String iName, OProfilerHookValue iHookValue) {
        if (this.recording < 0L) {
            return;
        }
        Map<OProfilerHookValue, String> map = this.hooks;
        synchronized (map) {
            for (Map.Entry<OProfilerHookValue, String> entry : this.hooks.entrySet()) {
                if (!entry.getValue().equals(iName)) continue;
                this.hooks.remove(entry.getKey());
                break;
            }
            this.hooks.put(iHookValue, iName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHookValue(String iName) {
        if (this.recording < 0L) {
            return;
        }
        Map<OProfilerHookValue, String> map = this.hooks;
        synchronized (map) {
            for (Map.Entry<OProfilerHookValue, String> entry : this.hooks.entrySet()) {
                if (!entry.getValue().equals(iName)) continue;
                this.hooks.remove(entry.getKey());
                break;
            }
        }
    }

    private void init() {
        this.counters = new HashMap<String, Long>();
        this.chronos = new HashMap<String, OProfilerEntry>();
        this.stats = new HashMap<String, OProfilerEntry>();
        this.hooks = new WeakHashMap<OProfilerHookValue, String>();
        this.lastReset = new Date();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long updateEntry(Map<String, OProfilerEntry> iValues, String iName, long iValue) {
        if (this.recording < 0L) {
            return iValue;
        }
        Map<String, OProfilerEntry> map = iValues;
        synchronized (map) {
            OProfilerEntry c = iValues.get(iName);
            if (c == null) {
                c = new OProfilerEntry();
                iValues.put(iName, c);
            }
            c.name = iName;
            ++c.items;
            c.last = iValue;
            c.total += c.last;
            c.average = c.total / c.items;
            if (c.last < c.min) {
                c.min = c.last;
            }
            if (c.last > c.max) {
                c.max = c.last;
            }
            return c.last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String dumpEntries(Map<String, OProfilerEntry> iValues, StringBuilder iBuffer) {
        if (this.recording < 0L) {
            return "<no recording>";
        }
        Map<String, OProfilerEntry> map = iValues;
        synchronized (map) {
            if (iValues.size() == 0) {
                return "";
            }
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            iBuffer.append(String.format("\n%50s | %10s %10s %10s %10s %10s %10s |", "Name", "last", "total", "min", "max", "average", "items"));
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            ArrayList<String> keys = new ArrayList<String>(iValues.keySet());
            Collections.sort(keys);
            for (String k : keys) {
                OProfilerEntry c = iValues.get(k);
                iBuffer.append(String.format("\n%-50s | %10d %10d %10d %10d %10d %10d |", k, c.last, c.total, c.min, c.max, c.average, c.items));
            }
            iBuffer.append(String.format("\n%50s +-------------------------------------------------------------------+", ""));
            return iBuffer.toString();
        }
    }

    public void setAutoDump(int iSeconds) {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (iSeconds > 0) {
            int ms = iSeconds * 1000;
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                public void run() {
                    System.out.println(OProfiler.getInstance().dump());
                    if (OProfiler.this.autoDumpReset) {
                        OProfiler.this.reset();
                    }
                }
            }, ms, (long)ms);
        }
    }

    public void setAutoDumpReset(boolean iNewValue) {
        this.autoDumpReset = iNewValue;
    }

    public class OProfilerEntry {
        public String name = null;
        public long items = 0L;
        public long last = 0L;
        public long min = 999999999L;
        public long max = 0L;
        public long average = 0L;
        public long total = 0L;

        public String toString() {
            return "Chrono [average=" + this.average + ", items=" + this.items + ", last=" + this.last + ", max=" + this.max + ", min=" + this.min + ", name=" + this.name + ", total=" + this.total + "]";
        }
    }

    public static interface OProfilerHookValue {
        public Object getValue();
    }
}

