/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.parser.OStringParser;
import java.util.Arrays;

public abstract class OBaseParser {
    public String text;
    public String textUpperCase;
    private transient StringBuilder parserLastWord = new StringBuilder();
    private transient int currentPos = 0;
    private transient int previousPos = 0;
    private transient char parserLastSeparator = (char)32;

    protected abstract void throwSyntaxErrorException(String var1);

    public String getSyntax() {
        return "?";
    }

    protected String parserOptionalWord(boolean iUpperCase) {
        this.previousPos = this.currentPos;
        this.parserNextWord(iUpperCase);
        if (this.parserLastWord.length() == 0) {
            return null;
        }
        return this.parserLastWord.toString();
    }

    protected String parseOptionalWord(boolean iUpperCase, String ... iWords) {
        this.parserNextWord(iUpperCase);
        if (iWords.length > 0) {
            if (this.parserLastWord.length() == 0) {
                return null;
            }
            boolean found = false;
            for (String w : iWords) {
                if (!this.parserLastWord.toString().equals(w)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
            }
        }
        return this.parserLastWord.toString();
    }

    protected int parserGoBack() {
        this.currentPos = this.previousPos;
        return this.currentPos;
    }

    protected String parseRequiredWord(boolean iUpperCase) {
        return this.parserRequiredWord(iUpperCase, "Syntax error", null);
    }

    protected String parserRequiredWord(boolean iUpperCase, String iCustomMessage) {
        return this.parserRequiredWord(iUpperCase, iCustomMessage, null);
    }

    protected String parserRequiredWord(boolean iUpperCase, String iCustomMessage, String iSeparators) {
        if (iSeparators == null) {
            iSeparators = " =><(),\r\n";
        }
        this.parserNextWord(iUpperCase, iSeparators);
        if (this.parserLastWord.length() == 0) {
            this.throwSyntaxErrorException(iCustomMessage);
        }
        return this.parserLastWord.toString();
    }

    protected void parserRequiredKeyword(String ... iWords) {
        this.parserNextWord(true, " \r\n,()");
        if (this.parserLastWord.length() == 0) {
            this.throwSyntaxErrorException("Cannot find expected keyword '" + Arrays.toString(iWords) + "'");
        }
        boolean found = false;
        for (String w : iWords) {
            if (!this.parserLastWord.toString().equals(w)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
        }
    }

    protected boolean parserOptionalKeyword(String ... iWords) {
        this.parserNextWord(true, " \r\n,");
        if (this.parserLastWord.length() == 0) {
            return false;
        }
        boolean found = iWords.length == 0;
        for (String w : iWords) {
            if (!this.parserLastWord.toString().equals(w)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.throwSyntaxErrorException("Found unexpected keyword '" + this.parserLastWord + "' while it was expected '" + Arrays.toString(iWords) + "'");
        }
        return true;
    }

    protected boolean parserSkipWhiteSpaces() {
        this.currentPos = OStringParser.jumpWhiteSpaces(this.text, this.currentPos, -1);
        return this.currentPos > -1;
    }

    protected boolean parserSetCurrentPosition(int iPosition) {
        this.currentPos = iPosition;
        if (this.currentPos >= this.text.length()) {
            this.currentPos = -1;
        }
        return this.currentPos > -1;
    }

    protected boolean parserMoveCurrentPosition(int iOffset) {
        if (this.currentPos < 0) {
            return false;
        }
        return this.parserSetCurrentPosition(this.currentPos + iOffset);
    }

    protected void parserNextWord(boolean iForceUpperCase) {
        this.parserNextWord(iForceUpperCase, " =><(),\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parserNextWord(boolean iForceUpperCase, String iSeparatorChars) {
        char c;
        String text2Use;
        this.previousPos = this.currentPos;
        this.parserLastWord.setLength(0);
        this.parserSkipWhiteSpaces();
        if (this.currentPos == -1) {
            return;
        }
        char stringBeginChar = ' ';
        String string = text2Use = iForceUpperCase ? this.textUpperCase : this.text;
        while (this.currentPos < text2Use.length()) {
            c = text2Use.charAt(this.currentPos);
            boolean found = false;
            for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                if (iSeparatorChars.charAt(sepIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++this.currentPos;
        }
        try {
            while (this.currentPos < text2Use.length()) {
                c = text2Use.charAt(this.currentPos);
                if (c == '\'' || c == '\"') {
                    if (stringBeginChar != ' ') {
                        if (stringBeginChar == c) {
                            stringBeginChar = ' ';
                        }
                    } else {
                        stringBeginChar = c;
                    }
                } else if (stringBeginChar == ' ') {
                    for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                        if (iSeparatorChars.charAt(sepIndex) != c || this.parserLastWord.length() <= 0) continue;
                        this.parserLastSeparator = c;
                        return;
                    }
                }
                this.parserLastWord.append(c);
                ++this.currentPos;
            }
            this.parserLastSeparator = (char)32;
        }
        finally {
            if (this.currentPos >= text2Use.length()) {
                this.currentPos = -1;
            }
        }
    }

    public char parserGetLastSeparator() {
        return this.parserLastSeparator;
    }

    public void parserSetLastSeparator(char iSeparator) {
        this.parserLastSeparator = iSeparator;
    }

    public int parserGetPreviousPosition() {
        return this.previousPos;
    }

    public boolean parserIsEnded() {
        return this.currentPos == -1;
    }

    public int parserGetCurrentPosition() {
        return this.currentPos;
    }

    public char parserGetCurrentChar() {
        if (this.currentPos < 0) {
            return ' ';
        }
        return this.text.charAt(this.currentPos);
    }

    public String parserGetLastWord() {
        return this.parserLastWord.toString();
    }

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase) {
        return OBaseParser.nextWord(iText, iTextUpperCase, ioCurrentPosition, ioWord, iForceUpperCase, " =><(),");
    }

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase, String iSeparatorChars) {
        ioWord.setLength(0);
        ioCurrentPosition = OStringParser.jumpWhiteSpaces(iText, ioCurrentPosition, -1);
        if (ioCurrentPosition < 0) {
            return -1;
        }
        OBaseParser.getWordStatic(iForceUpperCase ? iTextUpperCase : iText, ioCurrentPosition, iSeparatorChars, ioWord);
        if (ioWord.length() > 0) {
            ioCurrentPosition += ioWord.length();
        }
        return ioCurrentPosition;
    }

    public static void getWordStatic(CharSequence iText, int iBeginIndex, String iSeparatorChars, StringBuilder ioBuffer) {
        char c;
        int i;
        ioBuffer.setLength(0);
        char stringBeginChar = ' ';
        for (i = iBeginIndex; i < iText.length(); ++i) {
            c = iText.charAt(i);
            boolean found = false;
            for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                if (iSeparatorChars.charAt(sepIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++iBeginIndex;
        }
        for (i = iBeginIndex; i < iText.length(); ++i) {
            c = iText.charAt(i);
            if (c == '\'' || c == '\"') {
                if (stringBeginChar != ' ') {
                    if (stringBeginChar == c) {
                        stringBeginChar = ' ';
                    }
                } else {
                    stringBeginChar = c;
                }
            } else if (stringBeginChar == ' ') {
                for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                    if (iSeparatorChars.charAt(sepIndex) != c || ioBuffer.length() <= 0) continue;
                    return;
                }
            }
            ioBuffer.append(c);
        }
    }
}

