/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLogManager {
    private boolean debug = true;
    private boolean info = true;
    private boolean warn = true;
    private boolean error = true;
    private Level minimumLevel = Level.SEVERE;
    private static final String DEFAULT_LOG = "com.orientechnologies";
    private static final OLogManager instance = new OLogManager();

    protected OLogManager() {
    }

    public void setConsoleLevel(String iLevel) {
        this.setLevel(iLevel, ConsoleHandler.class);
    }

    public void setFileLevel(String iLevel) {
        this.setLevel(iLevel, FileHandler.class);
    }

    public void log(Object iRequester, Level iLevel, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (iMessage != null) {
            Logger log;
            Logger logger = log = iRequester != null ? Logger.getLogger(iRequester.getClass().getName()) : Logger.getLogger(DEFAULT_LOG);
            if (log.isLoggable(iLevel)) {
                String msg = String.format(iMessage, iAdditionalArgs);
                if (iException != null) {
                    log.log(iLevel, msg, iException);
                } else {
                    log.log(iLevel, msg, iAdditionalArgs);
                }
            }
        }
    }

    public void debug(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, null, iAdditionalArgs);
        }
    }

    public void debug(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, iException, iAdditionalArgs);
        }
    }

    public void debug(Object iRequester, String iMessage, Throwable iException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) {
        this.debug(iRequester, iMessage, iException, iAdditionalArgs);
        if (iExceptionClass != null) {
            try {
                throw iExceptionClass.getConstructor(String.class, Throwable.class).newInstance(iMessage, iException);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    public void info(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            this.log(iRequester, Level.INFO, iMessage, null, iAdditionalArgs);
        }
    }

    public void info(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            this.log(iRequester, Level.INFO, iMessage, iException, iAdditionalArgs);
        }
    }

    public void warn(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            this.log(iRequester, Level.WARNING, iMessage, null, iAdditionalArgs);
        }
    }

    public void warn(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            this.log(iRequester, Level.WARNING, iMessage, iException, iAdditionalArgs);
        }
    }

    public void config(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        this.log(iRequester, Level.CONFIG, iMessage, null, iAdditionalArgs);
    }

    public void error(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        this.log(iRequester, Level.SEVERE, iMessage, null, iAdditionalArgs);
    }

    public void error(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isErrorEnabled()) {
            this.log(iRequester, Level.SEVERE, iMessage, iException, iAdditionalArgs);
        }
    }

    public void error(Object iRequester, String iMessage, Throwable iException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) {
        this.error(iRequester, iMessage, iException, iAdditionalArgs);
        String msg = String.format(iMessage, iAdditionalArgs);
        if (iExceptionClass != null) {
            try {
                throw iExceptionClass.getConstructor(String.class, Throwable.class).newInstance(msg, iException);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (SecurityException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                // empty catch block
            }
        }
    }

    public void error(Object iRequester, String iMessage, Class<? extends OException> iExceptionClass) {
        this.error(iRequester, iMessage, (Throwable)null, new Object[0]);
        try {
            throw iExceptionClass.getConstructor(String.class).newInstance(iMessage);
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    public void exception(String iMessage, Exception iNestedException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) throws OException {
        Constructor<? extends OException> c;
        if (iMessage == null) {
            return;
        }
        String msg = String.format(iMessage, iAdditionalArgs);
        OException exceptionToThrow = null;
        try {
            if (iNestedException != null) {
                c = iExceptionClass.getConstructor(String.class, Throwable.class);
                exceptionToThrow = c.newInstance(msg, iNestedException);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exceptionToThrow == null) {
            try {
                c = iExceptionClass.getConstructor(String.class);
                exceptionToThrow = c.newInstance(msg);
            }
            catch (SecurityException e1) {
            }
            catch (NoSuchMethodException e1) {
            }
            catch (IllegalArgumentException e1) {
            }
            catch (InstantiationException e1) {
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException e1) {
                // empty catch block
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        throw new IllegalArgumentException("Cannot create the exception of type: " + iExceptionClass);
    }

    public boolean isWarn() {
        return this.warn;
    }

    public void setWarnEnabled(boolean warn) {
        this.warn = warn;
    }

    public void setInfoEnabled(boolean info) {
        this.info = info;
    }

    public void setDebugEnabled(boolean debug) {
        this.debug = debug;
    }

    public void setErrorEnabled(boolean error) {
        this.error = error;
    }

    public boolean isLevelEnabled(Level level) {
        if (level.equals(Level.FINER) || level.equals(Level.FINE) || level.equals(Level.FINEST)) {
            return this.debug;
        }
        if (level.equals(Level.INFO)) {
            return this.info;
        }
        if (level.equals(Level.WARNING)) {
            return this.warn;
        }
        if (level.equals(Level.SEVERE)) {
            return this.error;
        }
        return false;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public boolean isInfoEnabled() {
        return this.info;
    }

    public boolean isWarnEnabled() {
        return this.warn;
    }

    public boolean isErrorEnabled() {
        return this.error;
    }

    public static OLogManager instance() {
        return instance;
    }

    public Level setLevel(String iLevel, Class<? extends Handler> iHandler) {
        Level level;
        Level level2 = level = iLevel != null ? Level.parse(iLevel.toUpperCase(Locale.ENGLISH)) : Level.INFO;
        if (level.intValue() < this.minimumLevel.intValue()) {
            this.minimumLevel = level;
            if (level.equals(Level.FINER) || level.equals(Level.FINE) || level.equals(Level.FINEST)) {
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = true;
            } else if (level.equals(Level.INFO)) {
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = false;
            } else if (level.equals(Level.WARNING)) {
                this.error = true;
                this.warn = true;
                this.info = false;
                this.debug = false;
            } else if (level.equals(Level.SEVERE)) {
                this.error = true;
                this.warn = false;
                this.info = false;
                this.debug = false;
            }
        }
        Logger log = Logger.getLogger(DEFAULT_LOG);
        for (Handler h : log.getHandlers()) {
            if (!h.getClass().isAssignableFrom(iHandler)) continue;
            h.setLevel(level);
            break;
        }
        return level;
    }

    public static void installCustomFormatter() {
        try {
            Logger log = Logger.getLogger("");
            if (log.getHandlers().length == 0) {
                ConsoleHandler h = new ConsoleHandler();
                h.setFormatter(new OLogFormatter());
                log.addHandler(h);
            } else {
                for (Handler h : log.getHandlers()) {
                    if (!(h instanceof ConsoleHandler) || h.getFormatter().getClass().equals(OLogFormatter.class)) continue;
                    h.setFormatter(new OLogFormatter());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error while installing custom formatter. Logging could be disabled. Cause: " + e.toString());
        }
    }
}

