/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OConsoleApplication;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.log.OLogManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TTYConsoleReader
implements OConsoleReader {
    private static final String HISTORY_FILE_NAME = ".orientdb_history";
    private static int MAX_HISTORY_ENTRIES = 50;
    public static int END_CHAR = 70;
    public static int BEGIN_CHAR = 72;
    public static int DEL_CHAR = 126;
    public static int DOWN_CHAR = 66;
    public static int UP_CHAR = 65;
    public static int RIGHT_CHAR = 67;
    public static int LEFT_CHAR = 68;
    public static int HORIZONTAL_TAB_CHAR = 9;
    public static int VERTICAL_TAB_CHAR = 11;
    public static int BACKSPACE_CHAR = 127;
    public static int NEW_LINE_CHAR = 10;
    public static int UNIT_SEPARATOR_CHAR = 31;
    protected int currentPos = 0;
    protected List<String> history = new ArrayList<String>();
    protected String historyBuffer;
    protected Reader inStream;
    protected PrintStream outStream;
    protected OConsoleApplication console;

    public TTYConsoleReader() {
        File file = this.getHistoryFile(true);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String historyEntry = reader.readLine();
            while (historyEntry != null) {
                this.history.add(historyEntry);
                historyEntry = reader.readLine();
            }
            if (System.getProperty("file.encoding") != null) {
                this.inStream = new InputStreamReader(System.in, System.getProperty("file.encoding"));
                this.outStream = new PrintStream((OutputStream)System.out, false, System.getProperty("file.encoding"));
            } else {
                this.inStream = new InputStreamReader(System.in);
                this.outStream = System.out;
            }
        }
        catch (FileNotFoundException fnfe) {
            OLogManager.instance().error((Object)this, "History file not found", (Throwable)fnfe, "");
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error reading history file.", (Throwable)ioe, "");
        }
    }

    public String readLine() {
        String consoleInput = "";
        try {
            StringBuffer buffer = new StringBuffer();
            this.currentPos = 0;
            this.historyBuffer = null;
            int historyNum = this.history.size();
            boolean hintedHistory = false;
            while (true) {
                int i;
                StringBuffer cleaner;
                boolean escape = false;
                boolean ctrl = false;
                int next = this.inStream.read();
                if (next == 27) {
                    escape = true;
                    this.inStream.read();
                    next = this.inStream.read();
                }
                if (escape) {
                    if (next == 49) {
                        this.inStream.read();
                        next = this.inStream.read();
                    }
                    if (next == 53) {
                        ctrl = true;
                        next = this.inStream.read();
                    }
                    if (ctrl) {
                        if (next == RIGHT_CHAR) {
                            this.currentPos = buffer.indexOf(" ", this.currentPos) + 1;
                            if (this.currentPos == 0) {
                                this.currentPos = buffer.length();
                            }
                            cleaner = new StringBuffer();
                            for (i = 0; i < buffer.length(); ++i) {
                                cleaner.append(" ");
                            }
                            this.rewriteConsole(cleaner, true);
                            this.rewriteConsole(buffer, false);
                            continue;
                        }
                        if (next != LEFT_CHAR) continue;
                        this.currentPos = this.currentPos > 1 && this.currentPos < buffer.length() && buffer.charAt(this.currentPos - 1) == ' ' ? buffer.lastIndexOf(" ", this.currentPos - 2) + 1 : buffer.lastIndexOf(" ", this.currentPos) + 1;
                        if (this.currentPos < 0) {
                            this.currentPos = 0;
                        }
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next == UP_CHAR && !this.history.isEmpty()) {
                        if (this.history.size() <= 0) continue;
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        if (!(hintedHistory || historyNum != this.history.size() && buffer.toString().equals(this.history.get(historyNum)))) {
                            if (buffer.length() > 0) {
                                hintedHistory = true;
                                this.historyBuffer = buffer.toString();
                            } else {
                                this.historyBuffer = null;
                            }
                        }
                        buffer = (historyNum = this.getHintedHistoryIndexUp(historyNum)) > -1 ? new StringBuffer(this.history.get(historyNum)) : new StringBuffer(this.historyBuffer);
                        this.currentPos = buffer.length();
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next == DOWN_CHAR && !this.history.isEmpty()) {
                        if (this.history.size() <= 0) continue;
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        historyNum = this.getHintedHistoryIndexDown(historyNum);
                        buffer = historyNum == this.history.size() ? (this.historyBuffer != null ? new StringBuffer(this.historyBuffer) : new StringBuffer("")) : new StringBuffer(this.history.get(historyNum));
                        this.currentPos = buffer.length();
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next == RIGHT_CHAR) {
                        if (this.currentPos >= buffer.length()) continue;
                        ++this.currentPos;
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next == LEFT_CHAR) {
                        if (this.currentPos <= 0) continue;
                        --this.currentPos;
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next == END_CHAR) {
                        this.currentPos = buffer.length();
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                        continue;
                    }
                    if (next != BEGIN_CHAR) continue;
                    this.currentPos = 0;
                    cleaner = new StringBuffer();
                    for (i = 0; i < buffer.length(); ++i) {
                        cleaner.append(" ");
                    }
                    this.rewriteConsole(cleaner, true);
                    this.rewriteConsole(buffer, false);
                    continue;
                }
                if (next == NEW_LINE_CHAR) break;
                if (next == BACKSPACE_CHAR) {
                    if (buffer.length() > 0 && this.currentPos > 0) {
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        buffer.deleteCharAt(this.currentPos - 1);
                        --this.currentPos;
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                    }
                } else if (next == DEL_CHAR) {
                    if (buffer.length() > 0 && this.currentPos >= 0 && this.currentPos < buffer.length()) {
                        cleaner = new StringBuffer();
                        for (i = 0; i < buffer.length(); ++i) {
                            cleaner.append(" ");
                        }
                        buffer.deleteCharAt(this.currentPos);
                        this.rewriteConsole(cleaner, true);
                        this.rewriteConsole(buffer, false);
                    }
                } else if (next == HORIZONTAL_TAB_CHAR) {
                    cleaner = new StringBuffer();
                    for (i = 0; i < buffer.length(); ++i) {
                        cleaner.append(" ");
                    }
                    buffer = this.writeHint(buffer);
                    this.rewriteConsole(cleaner, true);
                    this.rewriteConsole(buffer, false);
                    this.currentPos = buffer.length();
                } else if (next > UNIT_SEPARATOR_CHAR && next < BACKSPACE_CHAR || next > BACKSPACE_CHAR) {
                    cleaner = new StringBuffer();
                    for (i = 0; i < buffer.length(); ++i) {
                        cleaner.append(" ");
                    }
                    if (this.currentPos == buffer.length()) {
                        buffer.append((char)next);
                    } else {
                        buffer.insert(this.currentPos, (char)next);
                    }
                    ++this.currentPos;
                    this.rewriteConsole(cleaner, true);
                    this.rewriteConsole(buffer, false);
                } else {
                    this.outStream.println();
                    this.outStream.print(buffer);
                }
                historyNum = this.history.size();
                hintedHistory = false;
            }
            this.outStream.println();
            consoleInput = buffer.toString();
            this.history.remove(consoleInput);
            this.history.add(consoleInput);
            historyNum = this.history.size();
            this.writeHistory(historyNum);
        }
        catch (IOException e) {
            return null;
        }
        if (consoleInput.equals("clear")) {
            this.outStream.flush();
            for (int i = 0; i < 150; ++i) {
                this.outStream.println();
            }
            this.outStream.print("\r");
            this.outStream.print("orientdb> ");
            return this.readLine();
        }
        return consoleInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHistory(int historyNum) throws IOException {
        if (historyNum <= MAX_HISTORY_ENTRIES) {
            File historyFile = this.getHistoryFile(false);
            BufferedWriter writer = new BufferedWriter(new FileWriter(historyFile));
            try {
                for (String historyEntry : this.history) {
                    writer.write(historyEntry);
                    writer.newLine();
                }
            }
            finally {
                writer.flush();
                writer.close();
            }
        }
        File historyFile = this.getHistoryFile(false);
        BufferedWriter writer = new BufferedWriter(new FileWriter(historyFile));
        try {
            for (String historyEntry : this.history.subList(historyNum - MAX_HISTORY_ENTRIES - 1, historyNum - 1)) {
                writer.write(historyEntry);
                writer.newLine();
            }
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    private StringBuffer writeHint(StringBuffer buffer) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (Method method : this.console.getConsoleMethods().keySet()) {
            String command = OConsoleApplication.getClearName(method.getName());
            if (!command.startsWith(buffer.toString())) continue;
            suggestions.add(command);
        }
        if (suggestions.size() > 1) {
            StringBuffer hintBuffer = new StringBuffer();
            String[] bufferComponents = buffer.toString().split(" ");
            HashSet<String> bufferPart = new HashSet<String>();
            String suggestionPart = null;
            boolean appendSpace = true;
            for (String suggestion : suggestions) {
                int i;
                String[] suggestionComponents = suggestion.split(" ");
                hintBuffer.append("* " + suggestion + " ");
                hintBuffer.append("\n");
                suggestionPart = "";
                if (bufferComponents.length == 0 || buffer.length() == 0) {
                    suggestionPart = null;
                    continue;
                }
                if (bufferComponents.length == 1) {
                    bufferPart.add(suggestionComponents[0]);
                    if (bufferPart.size() > 1) {
                        suggestionPart = bufferComponents[0];
                        appendSpace = false;
                        continue;
                    }
                    suggestionPart = suggestionComponents[0];
                    continue;
                }
                bufferPart.add(suggestionComponents[bufferComponents.length - 1]);
                if (bufferPart.size() > 1) {
                    for (i = 0; i < bufferComponents.length; ++i) {
                        suggestionPart = suggestionPart + bufferComponents[i];
                        if (i < bufferComponents.length - 1) {
                            suggestionPart = suggestionPart + " ";
                        }
                        appendSpace = false;
                    }
                    continue;
                }
                for (i = 0; i < suggestionComponents.length; ++i) {
                    suggestionPart = suggestionPart + suggestionComponents[i] + " ";
                }
            }
            if (suggestionPart != null) {
                buffer = new StringBuffer();
                buffer.append(suggestionPart);
                if (appendSpace) {
                    buffer.append(" ");
                }
            }
            hintBuffer.append("-----------------------------\n");
            this.rewriteHintConsole(hintBuffer);
        } else if (suggestions.size() > 0) {
            buffer = new StringBuffer();
            buffer.append((String)suggestions.get(0));
            buffer.append(" ");
        }
        return buffer;
    }

    public void setConsole(OConsoleApplication iConsole) {
        this.console = iConsole;
    }

    public OConsoleApplication getConsole() {
        return this.console;
    }

    private void rewriteConsole(StringBuffer buffer, boolean cleaner) {
        this.outStream.print("\r");
        this.outStream.print("orientdb> ");
        if (this.currentPos < buffer.length() && buffer.length() > 0 && !cleaner) {
            this.outStream.print("\u001b[0m" + buffer.substring(0, this.currentPos) + "\u001b[0;30;47m" + buffer.substring(this.currentPos, this.currentPos + 1) + "\u001b[0m" + buffer.substring(this.currentPos + 1) + "\u001b[0m");
        } else {
            this.outStream.print(buffer);
        }
    }

    private void rewriteHintConsole(StringBuffer buffer) {
        this.outStream.print("\r");
        this.outStream.print(buffer);
    }

    private int getHintedHistoryIndexUp(int historyNum) {
        if (this.historyBuffer != null && !this.historyBuffer.equals("")) {
            for (int i = historyNum - 1; i >= 0; --i) {
                if (!this.history.get(i).startsWith(this.historyBuffer)) continue;
                return i;
            }
            return -1;
        }
        return historyNum > 0 ? historyNum - 1 : 0;
    }

    private int getHintedHistoryIndexDown(int historyNum) throws IOException {
        if (this.historyBuffer != null && !this.historyBuffer.equals("")) {
            for (int i = historyNum + 1; i < this.history.size(); ++i) {
                if (!this.history.get(i).startsWith(this.historyBuffer)) continue;
                return i;
            }
            return this.history.size();
        }
        return historyNum < this.history.size() ? historyNum + 1 : this.history.size();
    }

    private File getHistoryFile(boolean read) {
        File file = new File(HISTORY_FILE_NAME);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Error creating history file.", (Throwable)ioe, "");
            }
        } else if (!read) {
            file.delete();
            try {
                file.createNewFile();
            }
            catch (IOException ioe) {
                OLogManager.instance().error((Object)this, "Error creating history file.", (Throwable)ioe, "");
            }
        }
        return file;
    }
}

