/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OAlwaysGreaterKey;
import com.orientechnologies.common.collection.OAlwaysLessKey;
import com.orientechnologies.common.comparator.ODefaultComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCompositeKey
implements Comparable<OCompositeKey>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Object> keys;
    private final Comparator<Object> comparator;

    public OCompositeKey(List<?> keys) {
        this.keys = new ArrayList<Object>(keys.size());
        this.comparator = ODefaultComparator.INSTANCE;
        for (Object key : keys) {
            this.addKey(key);
        }
    }

    public OCompositeKey(Object ... keys) {
        this.keys = new ArrayList<Object>(keys.length);
        this.comparator = ODefaultComparator.INSTANCE;
        for (Object key : keys) {
            this.addKey(key);
        }
    }

    public OCompositeKey() {
        this.keys = new ArrayList<Object>();
        this.comparator = ODefaultComparator.INSTANCE;
    }

    public List<Object> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    public void addKey(Object key) {
        if (key instanceof OCompositeKey) {
            OCompositeKey compositeKey = (OCompositeKey)key;
            for (Object inKey : compositeKey.keys) {
                this.addKey(inKey);
            }
        } else {
            this.keys.add(key);
        }
    }

    @Override
    public int compareTo(OCompositeKey otherKey) {
        Iterator<Object> inIter = this.keys.iterator();
        Iterator<Object> outIter = otherKey.keys.iterator();
        while (inIter.hasNext() && outIter.hasNext()) {
            Object inKey = inIter.next();
            Object outKey = outIter.next();
            if (outKey instanceof OAlwaysGreaterKey) {
                return -1;
            }
            if (outKey instanceof OAlwaysLessKey) {
                return 1;
            }
            int result = this.comparator.compare(inKey, outKey);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCompositeKey that = (OCompositeKey)o;
        return this.keys.equals(that.keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    public String toString() {
        return "OCompositeKey{keys=" + this.keys + '}';
    }
}

