/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.serialization;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.serialization.OLazyObjectCustomSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectCustomSerializerSet<TYPE>
extends HashSet<TYPE>
implements OLazyObjectCustomSerializer,
Serializable {
    private static final long serialVersionUID = -7698875159671927472L;
    private final ORecord<?> sourceRecord;
    private final Set<Object> underlying;
    private boolean converted = false;
    private final Class<?> deserializeClass;

    public OObjectCustomSerializerSet(Class<?> iDeserializeClass, ORecord<?> iSourceRecord, Set<Object> iRecordSource) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordSource;
        this.deserializeClass = iDeserializeClass;
    }

    public OObjectCustomSerializerSet(Class<?> iDeserializeClass, ORecord<?> iSourceRecord, Set<Object> iRecordSource, Set<? extends TYPE> iSourceCollection) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordSource;
        this.deserializeClass = iDeserializeClass;
        this.convertAll();
        this.addAll((Collection<? extends TYPE>)iSourceCollection);
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectCustomSerializerIterator(this.deserializeClass, this.sourceRecord, this.underlying.iterator());
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        boolean underlyingContains = this.underlying.contains(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, o));
        return underlyingContains || super.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return super.toArray(a);
    }

    @Override
    public boolean add(TYPE e) {
        this.underlying.add(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, e));
        return super.add(e);
    }

    @Override
    public boolean remove(Object e) {
        this.underlying.remove(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, e));
        return super.remove(e);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (super.contains(o) || this.underlying.contains(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean modified = false;
        this.setDirty();
        for (TYPE o : c) {
            modified = this.add(o) || modified;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<TYPE> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            this.remove(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.underlying.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setDirty();
        boolean modified = super.removeAll(c);
        for (Object o : c) {
            modified = modified || this.underlying.remove(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, o));
        }
        return modified;
    }

    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public String toString() {
        return this.underlying.toString();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted) {
            return;
        }
        super.clear();
        for (Object o : this.underlying) {
            super.add(OObjectEntitySerializer.deserializeFieldValue(this.deserializeClass, o));
        }
        this.converted = true;
    }
}

