/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.serialization;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.serialization.OLazyObjectCustomSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectCustomSerializerList<TYPE>
implements List<TYPE>,
OLazyObjectCustomSerializer,
Serializable {
    private static final long serialVersionUID = -8541477416577361792L;
    private ORecord<?> sourceRecord;
    private final List<Object> serializedList;
    private final ArrayList<Object> list = new ArrayList();
    private boolean converted = false;
    private final Class<?> deserializeClass;

    public OObjectCustomSerializerList(Class<?> iDeserializeClass, ORecord<?> iSourceRecord, List<Object> iRecordList) {
        this.sourceRecord = iSourceRecord;
        this.serializedList = iRecordList;
        this.deserializeClass = iDeserializeClass;
        for (int i = 0; i < iRecordList.size(); ++i) {
            this.list.add(i, null);
        }
    }

    public OObjectCustomSerializerList(Class<?> iDeserializeClass, ORecord<?> iSourceRecord, List<Object> iRecordList, Collection<? extends TYPE> iSourceList) {
        this.sourceRecord = iSourceRecord;
        this.serializedList = iRecordList;
        this.deserializeClass = iDeserializeClass;
        this.addAll((Collection<? extends TYPE>)iSourceList);
        for (int i = iSourceList.size(); i < iRecordList.size(); ++i) {
            this.list.add(i, null);
        }
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectCustomSerializerIterator(this.deserializeClass, this.sourceRecord, this.serializedList.iterator());
    }

    @Override
    public boolean contains(Object o) {
        boolean underlyingContains = this.serializedList.contains(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, o));
        return underlyingContains || this.list.contains(o);
    }

    @Override
    public boolean add(TYPE element) {
        this.serializedList.add(OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, element));
        return this.list.add(element);
    }

    @Override
    public void add(int index, TYPE element) {
        this.setDirty();
        this.serializedList.add(index, OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, element));
        this.list.add(index, element);
    }

    @Override
    public TYPE get(int index) {
        Object o = this.list.get(index);
        if (o == null) {
            Object toDeserialize = this.serializedList.get(index);
            o = OObjectEntitySerializer.deserializeFieldValue(this.deserializeClass, toDeserialize);
            this.list.set(index, o);
        }
        return (TYPE)o;
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public Object[] toArray() {
        this.convertAll();
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.convertAll();
        return this.list.toArray(a);
    }

    @Override
    public int size() {
        return this.serializedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.serializedList.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        int indexOfO = this.list.indexOf(o);
        this.serializedList.remove(indexOfO);
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean dirty = false;
        for (TYPE element : c) {
            dirty = this.add(element) || dirty;
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean addAll(int index, Collection<? extends TYPE> c) {
        for (TYPE element : c) {
            this.add(index, element);
            ++index;
        }
        if (c.size() > 0) {
            this.setDirty();
        }
        return c.size() > 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean dirty = true;
        for (Object o : c) {
            dirty = dirty || this.remove(o);
        }
        if (dirty) {
            this.setDirty();
        }
        return dirty;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<TYPE> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            this.remove(e);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.setDirty();
        this.serializedList.clear();
        this.list.clear();
    }

    @Override
    public TYPE set(int index, TYPE element) {
        this.serializedList.set(index, OObjectEntitySerializer.serializeFieldValue(this.deserializeClass, element));
        return (TYPE)this.list.set(index, element);
    }

    @Override
    public TYPE remove(int index) {
        this.serializedList.remove(index);
        return (TYPE)this.list.remove(index);
    }

    @Override
    public ListIterator<TYPE> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<TYPE> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<TYPE> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            this.convert(i);
        }
        this.converted = true;
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private void convert(int iIndex) {
        if (this.converted) {
            return;
        }
        Object o = this.list.get(iIndex);
        if (o == null) {
            o = this.serializedList.get(iIndex);
            this.list.set(iIndex, OObjectEntitySerializer.deserializeFieldValue(this.deserializeClass, o));
        }
    }

    protected boolean indexLoaded(int iIndex) {
        return this.list.get(iIndex) != null;
    }

    public String toString() {
        return this.list.toString();
    }
}

