/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.serialization;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import java.io.Serializable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectCustomSerializerIterator<TYPE>
implements Iterator<TYPE>,
Serializable {
    private static final long serialVersionUID = -4012483076050044405L;
    private final ORecord<?> sourceRecord;
    private final Iterator<? extends Object> underlying;
    private final Class<?> deserializeClass;

    public OObjectCustomSerializerIterator(Class<?> iDeserializeClass, ORecord<?> iSourceRecord, Iterator<? extends Object> iIterator) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iIterator;
        this.deserializeClass = iDeserializeClass;
    }

    @Override
    public TYPE next() {
        Object value = this.underlying.next();
        return (TYPE)OObjectEntitySerializer.deserializeFieldValue(this.deserializeClass, value);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public void remove() {
        this.underlying.remove();
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }
}

