/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enumerations;

import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.object.enumerations.OLazyObjectEnumSerializer;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectEnumLazyMap<TYPE extends Enum>
extends HashMap<Object, Object>
implements Serializable,
OLazyObjectEnumSerializer {
    private static final long serialVersionUID = -8606432090996808181L;
    private final ORecord<?> sourceRecord;
    private final Map<Object, Object> underlying;
    private boolean converted = false;
    private final Class<Enum> enumClass;

    public OObjectEnumLazyMap(Class<Enum> iEnumClass, ORecord<?> iSourceRecord, Map<Object, Object> iRecordMap) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordMap;
        this.converted = iRecordMap.isEmpty();
        this.enumClass = iEnumClass;
    }

    public OObjectEnumLazyMap(Class<Enum> iEnumClass, ORecord<?> iSourceRecord, Map<Object, Object> iRecordMap, Map<Object, Object> iSourceMap) {
        this(iEnumClass, iSourceRecord, iRecordMap);
        this.putAll(iSourceMap);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean containsKey(Object k) {
        return this.underlying.containsKey(k);
    }

    @Override
    public boolean containsValue(Object o) {
        boolean underlyingContains = this.underlying.containsValue(o.toString());
        return underlyingContains || super.containsValue(o);
    }

    @Override
    public Object put(Object iKey, Object e) {
        this.setDirty();
        this.underlying.put(iKey, ((Enum)e).name());
        return super.put(iKey, e);
    }

    @Override
    public Object remove(Object iKey) {
        this.underlying.remove((String)iKey);
        this.setDirty();
        return super.remove(iKey);
    }

    @Override
    public void clear() {
        this.converted = true;
        this.underlying.clear();
        super.clear();
        this.setDirty();
    }

    public boolean isConverted() {
        return this.converted;
    }

    @Override
    public String toString() {
        return this.underlying.toString();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        this.convertAll();
        return super.entrySet();
    }

    @Override
    public Object get(Object iKey) {
        this.convert(iKey);
        return super.get(iKey);
    }

    @Override
    public Set<Object> keySet() {
        this.convertAll();
        return this.underlying.keySet();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> iMap) {
        for (Map.Entry<? extends Object, ? extends Object> e : iMap.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<Object> values() {
        this.convertAll();
        return super.values();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    private void convert(Object iKey) {
        if (this.converted) {
            return;
        }
        if (super.containsKey(iKey)) {
            return;
        }
        Object o = this.underlying.get(String.valueOf(iKey));
        if (o instanceof Number) {
            super.put(iKey, this.enumClass.getEnumConstants()[((Number)o).intValue()]);
        } else {
            super.put(iKey, Enum.valueOf(this.enumClass, o.toString()));
        }
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted) {
            return;
        }
        for (Map.Entry<Object, Object> e : this.underlying.entrySet()) {
            if (e.getValue() instanceof Number) {
                super.put(e.getKey(), this.enumClass.getEnumConstants()[((Number)e.getValue()).intValue()]);
                continue;
            }
            super.put(e.getKey(), Enum.valueOf(this.enumClass, e.getValue().toString()));
        }
        this.converted = true;
    }
}

