/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectLazySet;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enumerations.OLazyObjectEnumSerializer;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyList;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyMap;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazySet;
import com.orientechnologies.orient.object.serialization.OLazyObjectCustomSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectProxyMethodHandler
implements MethodHandler {
    protected ODocument doc;
    protected Map<String, Integer> loadedFields;

    public OObjectProxyMethodHandler(ODocument iDocument) {
        this.doc = iDocument;
        if (!((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).isLazyLoading()) {
            this.doc.detach();
        }
        this.loadedFields = new HashMap<String, Integer>();
    }

    public ODocument getDoc() {
        return this.doc;
    }

    public void setDoc(ODocument iDoc) {
        this.doc = iDoc;
    }

    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
        if (this.isSetterMethod(m.getName(), m)) {
            return this.manageSetMethod(self, m, proceed, args);
        }
        if (this.isGetterMethod(m.getName(), m)) {
            return this.manageGetMethod(self, m, proceed, args);
        }
        if (m.getName().equals("equals") && args[0] != null && args[0] instanceof Proxy) {
            return (Boolean)proceed.invoke(self, args) != false && this.doc.equals(OObjectEntitySerializer.getDocument((Proxy)args[0]));
        }
        if (m.getName().equals("hashCode")) {
            return this.doc.hashCode() + (Integer)proceed.invoke(self, args);
        }
        return proceed.invoke(self, args);
    }

    public void detach(Object self) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        for (String fieldName : this.doc.fieldNames()) {
            Object value = this.getValue(self, fieldName, false, null);
            if (value instanceof OLazyObjectMultivalueElement) {
                ((OLazyObjectMultivalueElement)value).detach();
            }
            OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        }
        OObjectEntitySerializer.setIdField(self.getClass(), self, this.doc.getIdentity());
        OObjectEntitySerializer.setVersionField(self.getClass(), self, this.doc.getVersion());
    }

    public void attach(Object self) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<Object> currentClass = self.getClass();
        while (currentClass != Object.class) {
            if (Proxy.class.isAssignableFrom(currentClass)) {
                currentClass = currentClass.getSuperclass();
                continue;
            }
            for (Field f : currentClass.getDeclaredFields()) {
                Object value = OObjectEntitySerializer.getFieldValue(f, self);
                value = this.setValue(self, f.getName(), value);
                OObjectEntitySerializer.setFieldValue(f, self, value);
            }
            if ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(ODocument.class)) continue;
            currentClass = Object.class;
        }
    }

    protected Object manageGetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException, IllegalArgumentException, NoSuchFieldException {
        String fieldName = this.getFieldName(m);
        boolean idOrVersionField = false;
        if (OObjectEntitySerializer.isIdField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            OObjectEntitySerializer.setIdField(m.getDeclaringClass(), self, this.doc.getIdentity());
        } else if (OObjectEntitySerializer.isVersionField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            if (this.doc.getIdentity().isValid() && !this.doc.getIdentity().isTemporary()) {
                OObjectEntitySerializer.setVersionField(m.getDeclaringClass(), self, this.doc.getVersion());
            }
        }
        Object value = proceed.invoke(self, args);
        value = this.getValue(self, fieldName, idOrVersionField, value);
        if (this.doc.getIdentity().isValid() && !this.doc.getIdentity().isTemporary()) {
            this.loadedFields.put(fieldName, this.doc.getVersion());
        } else {
            this.loadedFields.put(fieldName, 0);
        }
        return value;
    }

    protected Object getValue(Object self, String fieldName, boolean idOrVersionField, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!idOrVersionField) {
            Object docValue;
            if (value == null) {
                Object docValue2 = this.doc.field(fieldName, OType.getTypeByClass(this.getField(fieldName, self.getClass()).getType()));
                if (docValue2 != null) {
                    value = this.lazyLoadField(self, fieldName, docValue2);
                }
            } else if ((value instanceof Collection || value instanceof Map) && !(value instanceof OLazyObjectMultivalueElement) || value.getClass().isArray()) {
                Class genericMultiValueType = OReflectionHelper.getGenericMultivalueType((Field)this.getField(fieldName, self.getClass()));
                if (genericMultiValueType != null && !OReflectionHelper.isJavaType((Class)genericMultiValueType)) {
                    Field f = this.getField(fieldName, self.getClass());
                    value = OObjectEntitySerializer.isSerializedType(f) && !(value instanceof OLazyObjectCustomSerializer) ? this.manageSerializedCollections(self, fieldName, value) : (genericMultiValueType.isEnum() && !(value instanceof OLazyObjectEnumSerializer) ? this.manageEnumCollections(self, f.getName(), genericMultiValueType, value) : this.manageObjectCollections(self, fieldName, value));
                } else {
                    Object docValue3 = this.doc.field(fieldName);
                    if (docValue3 == null) {
                        if (value.getClass().isArray()) {
                            OClass schemaClass = this.doc.getSchemaClass();
                            OProperty schemaProperty = null;
                            if (schemaClass != null) {
                                schemaProperty = schemaClass.getProperty(fieldName);
                            }
                            this.doc.field(fieldName, OObjectEntitySerializer.typeToStream(value, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc));
                        } else {
                            this.doc.field(fieldName, value);
                        }
                    } else if (!this.loadedFields.containsKey(fieldName)) {
                        value = this.manageArrayFieldObject(this.getField(fieldName, self.getClass()), self, docValue3);
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    } else if ((value instanceof Set || value instanceof Map) && this.loadedFields.get(fieldName) < this.doc.getVersion()) {
                        value = value instanceof Set ? new OObjectLazySet(this.doc, (Set)docValue3) : new OObjectLazyMap(this.doc, (Map)docValue3);
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    }
                }
            } else if (!this.loadedFields.containsKey(fieldName) && (docValue = this.doc.field(fieldName)) != null && !docValue.equals(value)) {
                value = this.lazyLoadField(self, fieldName, docValue);
            }
        }
        return value;
    }

    protected Object manageObjectCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean customSerialization = false;
        Field f = this.getField(fieldName, self.getClass());
        if (OObjectEntitySerializer.isSerializedType(f)) {
            customSerialization = true;
        }
        if (value instanceof Collection) {
            value = this.manageCollectionSave(f, (Collection)value, customSerialization);
        } else if (value instanceof Map) {
            value = this.manageMapSave(f, (Map)value, customSerialization);
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageSerializedCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            if (value instanceof List) {
                ArrayList<Object> docList = (ArrayList<Object>)this.doc.field(fieldName);
                if (docList == null) {
                    docList = new ArrayList<Object>();
                    this.doc.field(fieldName, docList);
                }
                value = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, (List<Object>)docList, value);
            } else if (value instanceof Set) {
                HashSet<Object> docSet = (HashSet<Object>)this.doc.field(fieldName, OType.LINKSET);
                if (docSet == null) {
                    docSet = new HashSet<Object>();
                    this.doc.field(fieldName, docSet);
                }
                value = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, docSet, (Set)((Object)value));
            }
        } else if (value instanceof Map) {
            HashMap<Object, Object> docMap = (HashMap<Object, Object>)this.doc.field(fieldName);
            if (docMap == null) {
                docMap = new HashMap<Object, Object>();
                this.doc.field(fieldName, docMap);
            }
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(this.getField(fieldName, self.getClass())), this.doc, docMap, (Map)((Object)value));
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageEnumCollections(Object self, String fieldName, Class<?> enumClass, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            if (value instanceof List) {
                ArrayList<Object> docList = (ArrayList<Object>)this.doc.field(fieldName);
                if (docList == null) {
                    docList = new ArrayList<Object>();
                    this.doc.field(fieldName, docList);
                }
                value = new OObjectEnumLazyList(enumClass, this.doc, (List<Object>)docList, value);
            } else if (value instanceof Set) {
                HashSet<Object> docSet = (HashSet<Object>)this.doc.field(fieldName, OType.LINKSET);
                if (docSet == null) {
                    docSet = new HashSet<Object>();
                    this.doc.field(fieldName, docSet);
                }
                value = new OObjectEnumLazySet(enumClass, this.doc, docSet, (Set)((Object)value));
            }
        } else if (value instanceof Map) {
            HashMap<Object, Object> docMap = (HashMap<Object, Object>)this.doc.field(fieldName);
            if (docMap == null) {
                docMap = new HashMap<Object, Object>();
                this.doc.field(fieldName, docMap);
            }
            value = new OObjectEnumLazyMap(enumClass, this.doc, docMap, (Map)((Object)value));
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(this.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageArraySave(String iFieldName, Object[] value) {
        Object o;
        if (value.length > 0 && (o = value[0]) instanceof Proxy) {
            ODocument[] newValue = new ODocument[value.length];
            for (int i = 0; i < value.length; ++i) {
                newValue[i] = value[i] != null ? OObjectEntitySerializer.getDocument((Proxy)value[i]) : null;
            }
            this.doc.field(iFieldName, newValue);
        }
        return value;
    }

    protected Object manageMapSave(Field f, Map<?, ?> value, boolean customSerialization) {
        Class genericType = OReflectionHelper.getGenericMultivalueType((Field)f);
        if (customSerialization) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            this.doc.field(f.getName(), map);
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), this.doc, map, value);
        } else if (genericType.isEnum()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            this.doc.field(f.getName(), map);
            value = new OObjectEnumLazyMap(genericType, this.doc, map, value);
        } else if (!(value instanceof OLazyObjectMultivalueElement)) {
            Map docMap = (Map)this.doc.field(f.getName());
            if (docMap == null) {
                docMap = new ORecordLazyMap(this.doc);
                this.doc.field(f.getName(), docMap);
            }
            value = new OObjectLazyMap(this.doc, docMap, value);
        }
        return value;
    }

    protected Object manageCollectionSave(Field f, Collection<?> value, boolean customSerialization) {
        Class genericType = OReflectionHelper.getGenericMultivalueType((Field)f);
        if (customSerialization) {
            if (value instanceof List) {
                ArrayList list = new ArrayList();
                this.doc.field(f.getName(), list);
                value = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), this.doc, new ArrayList<Object>(), (List)value);
            } else {
                HashSet<Object> set = new HashSet<Object>();
                this.doc.field(f.getName(), set);
                value = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), this.doc, set, (Set)value);
            }
        } else if (genericType.isEnum()) {
            if (value instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                this.doc.field(f.getName(), list);
                value = new OObjectEnumLazyList(genericType, this.doc, list, (List)value);
            } else {
                HashSet<Object> set = new HashSet<Object>();
                this.doc.field(f.getName(), set);
                value = new OObjectEnumLazySet(genericType, this.doc, set, (Set)value);
            }
        } else if (!(value instanceof OLazyObjectMultivalueElement)) {
            if (value instanceof List) {
                List docList = (List)this.doc.field(f.getName());
                if (docList == null) {
                    docList = new ORecordLazyList(this.doc);
                    this.doc.field(f.getName(), docList);
                }
                value = new OObjectLazyList(this.doc, docList, value);
            } else if (value instanceof Set) {
                Set docSet = (Set)this.doc.field(f.getName(), OType.LINKSET);
                if (docSet == null) {
                    docSet = new ORecordLazySet(this.doc);
                    this.doc.field(f.getName(), docSet);
                }
                value = new OObjectLazySet(this.doc, docSet, (Set)value);
            }
        }
        if (!((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).isLazyLoading()) {
            ((OLazyObjectMultivalueElement)((Object)value)).detach();
        }
        return value;
    }

    protected Object lazyLoadField(Object self, String fieldName, Object docValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean customSerialization = false;
        Field f = this.getField(fieldName, self.getClass());
        if (OObjectEntitySerializer.isSerializedType(f)) {
            customSerialization = true;
        }
        if (docValue instanceof OIdentifiable) {
            if (OIdentifiable.class.isAssignableFrom(f.getType())) {
                if (ORecordAbstract.class.isAssignableFrom(f.getType())) {
                    ORecordAbstract record = (ORecordAbstract)((OIdentifiable)docValue).getRecord();
                    OObjectEntitySerializer.setFieldValue(f, self, record);
                    return record;
                }
                OObjectEntitySerializer.setFieldValue(f, self, docValue);
                return docValue;
            }
            docValue = this.convertDocumentToObject((ODocument)((OIdentifiable)docValue).getRecord());
        } else if (docValue instanceof Collection) {
            docValue = this.manageCollectionLoad(f, self, docValue, customSerialization);
        } else if (docValue instanceof Map) {
            docValue = this.manageMapLoad(f, self, docValue, customSerialization);
        } else if (docValue.getClass().isArray() && !docValue.getClass().getComponentType().isPrimitive()) {
            docValue = this.manageArrayLoad(docValue);
        } else if (customSerialization) {
            docValue = OObjectEntitySerializer.deserializeFieldValue(this.getField(fieldName, self.getClass()).getType(), docValue);
        } else if (f.getType().isEnum()) {
            docValue = docValue instanceof Number ? ((Enum[])f.getType().getEnumConstants())[((Number)docValue).intValue()] : Enum.valueOf(f.getType(), docValue.toString());
        }
        OObjectEntitySerializer.setFieldValue(f, self, docValue);
        return docValue;
    }

    protected Object manageArrayLoad(Object value) {
        Object o;
        if (((Object[])value).length > 0 && (o = ((Object[])value)[0]) instanceof OIdentifiable) {
            Object[] newValue = new Object[((Object[])value).length];
            for (int i = 0; i < ((Object[])value).length; ++i) {
                ODocument doc = (ODocument)((OIdentifiable)((Object[])value)[i]).getRecord();
                newValue[i] = OObjectEntitySerializer.getDocument((Proxy)doc);
            }
            value = newValue;
        }
        return value;
    }

    protected Object manageMapLoad(Field f, Object self, Object value, boolean customSerialization) {
        Class genericType = OReflectionHelper.getGenericMultivalueType((Field)f);
        if (value instanceof ORecordLazyMap) {
            value = new OObjectLazyMap(this.doc, (ORecordLazyMap)value);
        } else if (customSerialization) {
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), this.doc, value);
        } else if (genericType.isEnum()) {
            value = new OObjectEnumLazyMap(genericType, this.doc, value);
        }
        return value;
    }

    protected Object manageCollectionLoad(Field f, Object self, Object value, boolean customSerialization) {
        Class genericType = OReflectionHelper.getGenericMultivalueType((Field)f);
        if (value instanceof ORecordLazyList) {
            value = new OObjectLazyList(this.doc, (ORecordLazyList)value);
        } else if (value instanceof ORecordLazySet || value instanceof OMVRBTreeRIDSet) {
            value = new OObjectLazySet(this.doc, (Set)value);
        } else if (customSerialization) {
            value = value instanceof List ? new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), this.doc, (List<Object>)value) : new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), this.doc, (Set)value);
        } else if (genericType.isEnum()) {
            value = value instanceof List ? new OObjectEnumLazyList(genericType, this.doc, (List<Object>)value) : new OObjectEnumLazySet(genericType, this.doc, (Set)value);
        }
        return this.manageArrayFieldObject(f, self, value);
    }

    protected Object manageArrayFieldObject(Field field, Object self, Object value) {
        if (field.getType().isArray()) {
            Collection collectionValue = (Collection)value;
            Object newArray = Array.newInstance(field.getType().getComponentType(), collectionValue.size());
            int i = 0;
            for (Object collectionItem : collectionValue) {
                Array.set(newArray, i, collectionItem);
                ++i;
            }
            return newArray;
        }
        return value;
    }

    protected Object convertDocumentToObject(ODocument value) {
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(value.getClassName(), this.getDatabase().getEntityManager(), value, new Object[0]);
    }

    protected Object manageSetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException {
        String fieldName = this.getFieldName(m);
        args[0] = this.setValue(self, fieldName, args[0]);
        return proceed.invoke(self, args);
    }

    protected Object setValue(Object self, String fieldName, Object valueToSet) {
        if (valueToSet == null) {
            this.doc.field(fieldName, valueToSet);
        } else if (!valueToSet.getClass().isAnonymousClass()) {
            if (valueToSet instanceof Proxy) {
                ODocument docToSet = OObjectEntitySerializer.getDocument((Proxy)valueToSet);
                if (OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    docToSet.addOwner(this.doc);
                }
                this.doc.field(fieldName, docToSet);
            } else if (valueToSet instanceof OIdentifiable) {
                if (valueToSet instanceof ODocument && OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    ((ODocument)valueToSet).addOwner(this.doc);
                }
                this.doc.field(fieldName, valueToSet);
            } else if (valueToSet instanceof Collection || valueToSet instanceof Map || valueToSet.getClass().isArray()) {
                Class genericMultiValueType = OReflectionHelper.getGenericMultivalueType((Field)this.getField(fieldName, self.getClass()));
                if (genericMultiValueType != null && !OReflectionHelper.isJavaType((Class)genericMultiValueType)) {
                    if (!(valueToSet instanceof OLazyObjectMultivalueElement)) {
                        if (valueToSet instanceof Collection) {
                            boolean customSerialization = false;
                            Field f = this.getField(fieldName, self.getClass());
                            if (OObjectEntitySerializer.isSerializedType(f)) {
                                customSerialization = true;
                            }
                            valueToSet = this.manageCollectionSave(f, (Collection)valueToSet, customSerialization);
                        } else if (valueToSet instanceof Map) {
                            boolean customSerialization = false;
                            Field f = this.getField(fieldName, self.getClass());
                            if (OObjectEntitySerializer.isSerializedType(f)) {
                                customSerialization = true;
                            }
                            valueToSet = this.manageMapSave(f, (Map)valueToSet, customSerialization);
                        } else if (valueToSet.getClass().isArray()) {
                            valueToSet = this.manageArraySave(fieldName, (Object[])valueToSet);
                        }
                    }
                } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
                    this.doc.field(fieldName, OObjectEntitySerializer.serializeFieldValue(this.getField(fieldName, self.getClass()).getType(), valueToSet));
                } else if (valueToSet.getClass().isArray()) {
                    OClass schemaClass = this.doc.getSchemaClass();
                    OProperty schemaProperty = null;
                    if (schemaClass != null) {
                        schemaProperty = schemaClass.getProperty(fieldName);
                    }
                    this.doc.field(fieldName, OObjectEntitySerializer.typeToStream(valueToSet, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc));
                } else {
                    this.doc.field(fieldName, valueToSet);
                }
            } else if (valueToSet.getClass().isEnum()) {
                this.doc.field(fieldName, ((Enum)valueToSet).name());
            } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
                this.doc.field(fieldName, OObjectEntitySerializer.serializeFieldValue(this.getField(fieldName, self.getClass()).getType(), valueToSet));
            } else if (this.getDatabase().getEntityManager().getEntityClass(valueToSet.getClass().getSimpleName()) != null && !valueToSet.getClass().isEnum()) {
                valueToSet = OObjectEntitySerializer.serializeObject(valueToSet, this.getDatabase());
                ODocument docToSet = OObjectEntitySerializer.getDocument((Proxy)valueToSet);
                if (OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    docToSet.addOwner(this.doc);
                }
                this.doc.field(fieldName, docToSet);
            } else {
                this.doc.field(fieldName, valueToSet);
            }
            this.loadedFields.put(fieldName, this.doc.getVersion());
        } else {
            OLogManager.instance().warn((Object)this, "Setting property '%s' in proxied class '%s' with an anonymous class '%s'. The document won't have this property.", new Object[]{fieldName, self.getClass().getName(), valueToSet.getClass().getName()});
        }
        return valueToSet;
    }

    protected boolean isSetterMethod(String fieldName, Method m) {
        if (!fieldName.startsWith("set") || !this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "set")) {
            return false;
        }
        return m.getParameterTypes() == null || m.getParameterTypes().length == 1;
    }

    protected boolean isGetterMethod(String fieldName, Method m) {
        int prefixLength;
        if (fieldName.startsWith("get") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "get")) {
            prefixLength = "get".length();
        } else if (fieldName.startsWith("is") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "is")) {
            prefixLength = "is".length();
        } else {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
            return false;
        }
        return fieldName.length() > prefixLength;
    }

    protected boolean checkIfFirstCharAfterPrefixIsUpperCase(String methodName, String prefix) {
        return methodName.length() > prefix.length() ? Character.isUpperCase(methodName.charAt(prefix.length())) : false;
    }

    protected String getFieldName(Method m) {
        if (m.getName().startsWith("get")) {
            return this.getFieldName(m.getName(), "get");
        }
        if (m.getName().startsWith("set")) {
            return this.getFieldName(m.getName(), "set");
        }
        return this.getFieldName(m.getName(), "is");
    }

    protected String getFieldName(String methodName, String prefix) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(prefix.length())));
        for (int i = prefix.length() + 1; i < methodName.length(); ++i) {
            fieldName.append(methodName.charAt(i));
        }
        return fieldName.toString();
    }

    protected String getSetterFieldName(String fieldName) {
        StringBuffer methodName = new StringBuffer("set");
        methodName.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            methodName.append(fieldName.charAt(i));
        }
        return methodName.toString();
    }

    protected Method getSetMethod(Class<?> iClass, String fieldName, Object value) throws NoSuchMethodException {
        for (Method m : iClass.getDeclaredMethods()) {
            if (!m.getName().equals(fieldName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
            return m;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.getSetMethod(iClass.getSuperclass(), fieldName, value);
    }

    protected Field getField(String fieldName, Class<?> iClass) {
        for (Field f : iClass.getDeclaredFields()) {
            if (!f.getName().equals(fieldName)) continue;
            return f;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.getField(fieldName, iClass.getSuperclass());
    }

    private ODatabaseObject getDatabase() {
        return (ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner();
    }
}

