/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.serialization.OLazyObjectCustomSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectEntityEnhancer {
    private static final OObjectEntityEnhancer instance = new OObjectEntityEnhancer();
    public static final String ENHANCER_CLASS_PREFIX = "orientdb_";

    public <T> T getProxiedInstance(String iClass, OEntityManager entityManager, ODocument doc, Object ... iArgs) {
        Class<?> clazz = entityManager.getEntityClass(iClass);
        return (T)this.getProxiedInstance(clazz, doc, iArgs);
    }

    public <T> T getProxiedInstance(String iClass, Object iEnclosingInstance, OEntityManager entityManager, ODocument doc, Object ... iArgs) {
        Class<?> clazz = entityManager.getEntityClass(iClass);
        return (T)this.getProxiedInstance(clazz, iEnclosingInstance, doc, iArgs);
    }

    public <T> T getProxiedInstance(Class<T> iClass, ODocument doc, Object ... iArgs) {
        return this.getProxiedInstance(iClass, (Object)null, doc, iArgs);
    }

    public <T> T getProxiedInstance(final Class<T> iClass, Object iEnclosingInstance, ODocument doc, Object ... iArgs) {
        Class c;
        boolean isInnerClass;
        if (iClass == null) {
            throw new OSerializationException("Type " + doc.getClassName() + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        boolean bl = isInnerClass = iClass.getEnclosingClass() != null;
        if (Proxy.class.isAssignableFrom(iClass)) {
            c = iClass;
        } else {
            ProxyFactory f = new ProxyFactory();
            f.setSuperclass(iClass);
            f.setFilter(new MethodFilter(){

                public boolean isHandled(Method m) {
                    String methodName = m.getName();
                    try {
                        return OObjectEntityEnhancer.this.isSetterMethod(methodName, m) || OObjectEntityEnhancer.this.isGetterMethod(methodName, m) || methodName.equals("equals") || methodName.equals("hashCode");
                    }
                    catch (NoSuchFieldException nsfe) {
                        OLogManager.instance().warn((Object)this, "Error handling the method %s in class %s", (Throwable)nsfe, new Object[]{m.getName(), iClass.getName()});
                        return false;
                    }
                    catch (SecurityException se) {
                        OLogManager.instance().warn((Object)this, "", (Throwable)se, new Object[]{m.getName(), iClass.getName()});
                        return false;
                    }
                }
            });
            c = f.createClass();
        }
        OObjectProxyMethodHandler mi = new OObjectProxyMethodHandler(doc);
        try {
            T newEntity;
            if (iArgs != null && iArgs.length > 0) {
                if (isInnerClass) {
                    if (iEnclosingInstance == null) {
                        iEnclosingInstance = iClass.getEnclosingClass().newInstance();
                    }
                    Object[] newArgs = new Object[iArgs.length + 1];
                    newArgs[0] = iEnclosingInstance;
                    for (int i = 0; i < iArgs.length; ++i) {
                        newArgs[i + 1] = iArgs[i];
                    }
                    iArgs = newArgs;
                }
                Constructor<?> constructor = null;
                for (Constructor<?> constr : c.getConstructors()) {
                    boolean found = true;
                    if (constr.getParameterTypes().length != iArgs.length) continue;
                    for (int i = 0; i < constr.getParameterTypes().length; ++i) {
                        Class<?> parameterType = constr.getParameterTypes()[i];
                        if (parameterType.isPrimitive()) {
                            if (this.isPrimitiveParameterCorrect(parameterType, iArgs[i])) continue;
                            found = false;
                            break;
                        }
                        if (iArgs[i] == null || parameterType.isAssignableFrom(iArgs[i].getClass())) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    constructor = constr;
                    break;
                }
                if (constructor != null) {
                    newEntity = constructor.newInstance(iArgs);
                    this.initDocument(iClass, newEntity, doc, (ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner());
                } else {
                    newEntity = iEnclosingInstance != null ? this.createInstanceNoParameters(c, iEnclosingInstance) : this.createInstanceNoParameters(c, iClass);
                }
            } else {
                newEntity = iEnclosingInstance != null ? this.createInstanceNoParameters(c, iEnclosingInstance) : this.createInstanceNoParameters(c, iClass);
            }
            ((Proxy)newEntity).setHandler((MethodHandler)mi);
            if (OObjectEntitySerializer.hasBoundedDocumentField(iClass)) {
                OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getBoundedDocumentField(iClass), newEntity, doc);
            }
            return newEntity;
        }
        catch (InstantiationException ie) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)ie, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)iae, new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)iae, new Object[0]);
        }
        catch (SecurityException se) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)se, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)ite, new Object[0]);
        }
        catch (NoSuchMethodException nsme) {
            OLogManager.instance().error((Object)this, "Error creating proxied instance for class " + iClass.getName(), (Throwable)nsme, new Object[0]);
        }
        return null;
    }

    public static synchronized OObjectEntityEnhancer getInstance() {
        return instance;
    }

    private boolean isSetterMethod(String fieldName, Method m) throws SecurityException, NoSuchFieldException {
        if (!fieldName.startsWith("set") || !this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "set")) {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length != 1) {
            return false;
        }
        return !OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m));
    }

    private boolean isGetterMethod(String fieldName, Method m) throws SecurityException, NoSuchFieldException {
        int prefixLength;
        if (fieldName.startsWith("get") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "get")) {
            prefixLength = "get".length();
        } else if (fieldName.startsWith("is") && this.checkIfFirstCharAfterPrefixIsUpperCase(fieldName, "is")) {
            prefixLength = "is".length();
        } else {
            return false;
        }
        if (m.getParameterTypes() != null && m.getParameterTypes().length > 0) {
            return false;
        }
        if (fieldName.length() <= prefixLength) {
            return false;
        }
        return !OObjectEntitySerializer.isTransientField(m.getDeclaringClass(), this.getFieldName(m));
    }

    protected String getFieldName(Method m) {
        if (m.getName().startsWith("get")) {
            return this.getFieldName(m.getName(), "get");
        }
        if (m.getName().startsWith("set")) {
            return this.getFieldName(m.getName(), "set");
        }
        return this.getFieldName(m.getName(), "is");
    }

    protected String getFieldName(String methodName, String prefix) {
        StringBuffer fieldName = new StringBuffer();
        fieldName.append(Character.toLowerCase(methodName.charAt(prefix.length())));
        for (int i = prefix.length() + 1; i < methodName.length(); ++i) {
            fieldName.append(methodName.charAt(i));
        }
        return fieldName.toString();
    }

    private boolean checkIfFirstCharAfterPrefixIsUpperCase(String methodName, String prefix) {
        return methodName.length() > prefix.length() ? Character.isUpperCase(methodName.charAt(prefix.length())) : false;
    }

    private boolean isPrimitiveParameterCorrect(Class<?> primitiveClass, Object parameterValue) {
        if (parameterValue == null) {
            return false;
        }
        Class<?> parameterClass = parameterValue.getClass();
        if (Integer.TYPE.isAssignableFrom(primitiveClass)) {
            return Integer.class.isAssignableFrom(parameterClass);
        }
        if (Double.TYPE.isAssignableFrom(primitiveClass)) {
            return Double.class.isAssignableFrom(parameterClass);
        }
        if (Float.TYPE.isAssignableFrom(primitiveClass)) {
            return Float.class.isAssignableFrom(parameterClass);
        }
        if (Long.TYPE.isAssignableFrom(primitiveClass)) {
            return Long.class.isAssignableFrom(parameterClass);
        }
        if (Short.TYPE.isAssignableFrom(primitiveClass)) {
            return Short.class.isAssignableFrom(parameterClass);
        }
        if (Byte.TYPE.isAssignableFrom(primitiveClass)) {
            return Byte.class.isAssignableFrom(parameterClass);
        }
        return false;
    }

    protected void initDocument(Class<?> iClass, Object iInstance, ODocument iDocument, ODatabaseObject db) throws IllegalArgumentException, IllegalAccessException {
        for (Class<?> currentClass = iClass; currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            for (Field f : currentClass.getDeclaredFields()) {
                OLazyObjectCustomSerializer o;
                if (f.getName().equals("this$0")) continue;
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                if ((o = f.get(iInstance)) == null) continue;
                if (OObjectEntitySerializer.isSerializedType(f)) {
                    if (o instanceof List) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        iDocument.field(f.getName(), list);
                        o = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), iDocument, (List<Object>)list, o);
                        f.set(iInstance, o);
                        continue;
                    }
                    if (o instanceof Set) {
                        HashSet<Object> set = new HashSet<Object>();
                        iDocument.field(f.getName(), set);
                        o = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), iDocument, set, (Set)((Object)o));
                        f.set(iInstance, o);
                        continue;
                    }
                    if (o instanceof Map) {
                        HashMap<Object, Object> map = new HashMap<Object, Object>();
                        iDocument.field(f.getName(), map);
                        o = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), iDocument, map, (Map)((Object)o));
                        f.set(iInstance, o);
                        continue;
                    }
                    o = OObjectEntitySerializer.serializeFieldValue(o.getClass(), o);
                    iDocument.field(f.getName(), o);
                    continue;
                }
                iDocument.field(f.getName(), OObjectEntitySerializer.typeToStream(o, OType.getTypeByClass(f.getType()), db, iDocument));
            }
        }
    }

    protected <T> T createInstanceNoParameters(Class<T> iProxiedClass, Class<?> iOriginalClass) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T instanceToReturn = null;
        Class<?> enclosingClass = iOriginalClass.getEnclosingClass();
        if (enclosingClass != null) {
            Object instanceOfEnclosingClass = this.createInstanceNoParameters(enclosingClass, enclosingClass);
            Constructor<T> ctor = iProxiedClass.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(instanceOfEnclosingClass);
            }
        } else {
            try {
                instanceToReturn = iProxiedClass.newInstance();
            }
            catch (InstantiationException e) {
                OLogManager.instance().error((Object)this, "Cannot create an instance of the enclosing class '%s'", new Object[]{iOriginalClass});
                throw e;
            }
        }
        return instanceToReturn;
    }

    protected <T> T createInstanceNoParameters(Class<T> iProxiedClass, Object iEnclosingInstance) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        T instanceToReturn = null;
        Class<?> enclosingClass = iEnclosingInstance.getClass();
        if (enclosingClass != null) {
            Constructor<T> ctor = iProxiedClass.getConstructor(enclosingClass);
            if (ctor != null) {
                instanceToReturn = ctor.newInstance(iEnclosingInstance);
            }
        } else {
            instanceToReturn = iProxiedClass.newInstance();
        }
        return instanceToReturn;
    }
}

