/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.OLazyObjectMultivalueElement;
import com.orientechnologies.orient.core.db.object.OLazyObjectSetInterface;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectLazyIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectLazySet<TYPE>
extends HashSet<TYPE>
implements OLazyObjectSetInterface<TYPE>,
OLazyObjectMultivalueElement,
Serializable {
    private static final long serialVersionUID = 1793910544017627989L;
    private final ORecord<?> sourceRecord;
    private final Set<OIdentifiable> underlying;
    private String fetchPlan;
    private boolean converted = false;
    private boolean convertToRecord = true;

    public OObjectLazySet(ORecord<?> iSourceRecord, Set<OIdentifiable> iRecordSource) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordSource;
    }

    public OObjectLazySet(ORecord<?> iSourceRecord, Set<OIdentifiable> iRecordSource, Set<? extends TYPE> iSourceCollection) {
        this.sourceRecord = iSourceRecord;
        this.underlying = iRecordSource;
        this.addAll((Collection<? extends TYPE>)iSourceCollection);
    }

    @Override
    public Iterator<TYPE> iterator() {
        return new OObjectLazyIterator<TYPE>(this.getDatabase(), this.sourceRecord, this.underlying.iterator(), this.convertToRecord);
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(this.getDatabase().getRecordByUserObject(o, false));
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.underlying.toArray(a);
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (int i = 0; i < a.length; ++i) {
            a[i] = database.getUserObjectByRecord((OIdentifiable)a[i], this.fetchPlan);
        }
        return a;
    }

    @Override
    public boolean add(Object e) {
        if (this.converted && e instanceof ORID) {
            this.converted = false;
        }
        this.setDirty();
        return this.underlying.add(this.getDatabase().getRecordByUserObject(e, true));
    }

    @Override
    public boolean remove(Object o) {
        this.setDirty();
        return this.underlying.remove(this.getDatabase().getRecordByUserObject(o, false));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object o : c) {
            if (this.underlying.contains(database.getRecordByUserObject(o, false))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends TYPE> c) {
        boolean modified = false;
        this.setDirty();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (TYPE o : c) {
            if (this.underlying.add(database.getRecordByUserObject(o, false))) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.setDirty();
        return this.underlying.retainAll(c);
    }

    @Override
    public void clear() {
        this.setDirty();
        this.underlying.clear();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.setDirty();
        boolean modified = false;
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object o : c) {
            if (this.underlying.remove(database.getRecordByUserObject(o, false))) continue;
            modified = true;
        }
        return modified;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    @Override
    public boolean isConverted() {
        return this.converted;
    }

    public OObjectLazySet<TYPE> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }

    public boolean isConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public String toString() {
        return this.underlying.toString();
    }

    public void setDirty() {
        if (this.sourceRecord != null) {
            this.sourceRecord.setDirty();
        }
    }

    @Override
    public void detach() {
        this.convertAll();
    }

    protected void convertAll() {
        if (this.converted || !this.convertToRecord) {
            return;
        }
        HashSet copy = new HashSet(this);
        this.underlying.clear();
        ODatabasePojoAbstract<TYPE> database = this.getDatabase();
        for (Object e : copy) {
            if (e == null) continue;
            if (e instanceof ORID) {
                this.add(database.getUserObjectByRecord((ORecordInternal)((ODatabaseRecord)this.getDatabase().getUnderlying()).load((ORID)e, this.fetchPlan), this.fetchPlan));
                continue;
            }
            if (e instanceof ODocument) {
                this.add(database.getUserObjectByRecord((ORecordInternal)e, this.fetchPlan));
                continue;
            }
            this.add(e);
        }
        this.converted = true;
    }

    protected ODatabasePojoAbstract<TYPE> getDatabase() {
        return (ODatabasePojoAbstract)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner();
    }
}

