/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandSQLPojoWrapper
implements OCommandRequest {
    private OCommandRequest command;
    private ODatabasePojoAbstract<?> database;

    public OCommandSQLPojoWrapper(ODatabasePojoAbstract<?> iDatabase, OCommandRequest iCommand) {
        this.database = iDatabase;
        this.command = iCommand;
    }

    @Override
    public <RET> RET execute(Object ... iArgs) {
        this.database.convertParameters(iArgs);
        Object result = this.command.execute(iArgs);
        if (result instanceof Collection) {
            ArrayList<ODocument> resultPojo = new ArrayList<ODocument>();
            Collection coll = (Collection)result;
            for (ODocument doc : coll) {
                ODocument obj = doc.getClassName() == null ? doc : this.database.getUserObjectByRecord(doc, null, true);
                resultPojo.add(obj);
            }
            result = resultPojo;
        } else if (result instanceof ODocument && ((ODocument)result).getClassName() != null) {
            result = this.database.getUserObjectByRecord((ODocument)result, null, true);
        }
        return result;
    }

    @Override
    public int getLimit() {
        return this.command.getLimit();
    }

    @Override
    public OCommandRequest setLimit(int iLimit) {
        this.command.setLimit(iLimit);
        return this;
    }

    @Override
    public boolean isIdempotent() {
        return this.command.isIdempotent();
    }
}

