/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.orient.core.db.record.ODetachable;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringBuilderSerializable;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRID;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDProvider;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeRIDSet
implements Set<OIdentifiable>,
OStringBuilderSerializable,
OSerializableStream,
ODetachable {
    private static final long serialVersionUID = 1L;
    private final OMVRBTreeRID tree;

    public OMVRBTreeRIDSet() {
        this(new OMVRBTreeRID());
    }

    public OMVRBTreeRIDSet(OIdentifiable iRecord) {
        this(new OMVRBTreeRID((ODocument)iRecord.getRecord()));
    }

    public OMVRBTreeRIDSet(String iClusterName) {
        this(new OMVRBTreeRID(iClusterName));
    }

    public OMVRBTreeRIDSet(ORecord<?> iOwner) {
        this((OMVRBTreeRID)new OMVRBTreeRID().setOwner(iOwner));
    }

    public OMVRBTreeRIDSet(ORecord<?> iOwner, Collection<OIdentifiable> iInitValues) {
        this((OMVRBTreeRID)new OMVRBTreeRID(iInitValues).setOwner(iOwner));
    }

    public OMVRBTreeRIDSet(OMVRBTreeRID iProvider) {
        this.tree = iProvider;
    }

    public OMVRBTreeRIDSet(OMVRBTreeRIDSet iSource, ODocument iClone) {
        this.tree = new OMVRBTreeRID(iSource.tree);
        this.tree.setOwner(iClone);
    }

    @Override
    public int size() {
        return this.tree.size();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.tree.containsKey(o);
    }

    public OLazyIterator<OIdentifiable> iterator(boolean iAutoConvertToRecord) {
        return this.tree.iterator(iAutoConvertToRecord);
    }

    @Override
    public OLazyIterator<OIdentifiable> iterator() {
        return this.tree.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.tree.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.tree.toArray(a);
    }

    @Override
    public boolean add(OIdentifiable e) {
        return this.tree.put(e, null) != null;
    }

    @Override
    public boolean remove(Object o) {
        return this.tree.remove(o) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.tree.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        boolean changed = false;
        for (OIdentifiable oIdentifiable : c) {
            if (!this.add(oIdentifiable) || changed) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.tree.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.tree.removeAll(c);
    }

    @Override
    public boolean detach() {
        return this.tree.detach();
    }

    @Override
    public void clear() {
        this.tree.clear();
    }

    public OMVRBTreeRIDSet fromDocument(ODocument iDocument) {
        this.fromStream(iDocument.toStream());
        return this;
    }

    public ODocument toDocument() {
        return ((OMVRBTreeRIDProvider)this.tree.getProvider()).toDocument();
    }

    public OMVRBTreeRIDSet copy(ODocument iCloned) {
        OMVRBTreeRIDSet clone = new OMVRBTreeRIDSet(this, iCloned);
        return clone;
    }

    @Override
    public OStringBuilderSerializable fromStream(StringBuilder iSource) {
        ((OMVRBTreeRIDProvider)this.tree.getProvider()).fromStream(iSource);
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        this.fromStream(new StringBuilder(OBinaryProtocol.bytes2string(iStream)));
        return this;
    }

    @Override
    public OStringBuilderSerializable toStream(StringBuilder iOutput) throws OSerializationException {
        ((OMVRBTreeRIDProvider)this.tree.getProvider()).toStream(iOutput);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        StringBuilder buffer = new StringBuilder();
        this.toStream(buffer);
        return buffer.toString().getBytes();
    }

    public String toString() {
        return this.tree.toString();
    }

    public OMVRBTreeRIDSet setAutoConvert(boolean b) {
        this.tree.setAutoConvert(b);
        return this;
    }
}

