/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OIdentityChangedListener;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeEntryPersistent<K, V>
extends OMVRBTreeEntry<K, V>
implements OIdentityChangedListener {
    protected OMVRBTreeEntryDataProvider<K, V> dataProvider;
    protected OMVRBTreePersistent<K, V> pTree;
    protected OMVRBTreeEntryPersistent<K, V> parent;
    protected OMVRBTreeEntryPersistent<K, V> left;
    protected OMVRBTreeEntryPersistent<K, V> right;

    public OMVRBTreeEntryPersistent(OMVRBTreePersistent<K, V> iTree, OMVRBTreeEntryPersistent<K, V> iParent, ORID iRecordId) {
        super(iTree);
        this.pTree = iTree;
        this.dataProvider = this.pTree.dataProvider.getEntry(iRecordId);
        this.dataProvider.setIdentityChangedListener(this);
        this.init();
        this.parent = iParent;
        this.pTree.addNodeInMemory(this);
    }

    public OMVRBTreeEntryPersistent(OMVRBTreePersistent<K, V> iTree, K iKey, V iValue, OMVRBTreeEntryPersistent<K, V> iParent) {
        super(iTree);
        this.pTree = iTree;
        this.dataProvider = this.pTree.dataProvider.createEntry();
        this.dataProvider.setIdentityChangedListener(this);
        this.dataProvider.insertAt(0, iKey, iValue);
        this.init();
        this.setParent(iParent);
        this.pTree.addNodeInMemory(this);
        this.markDirty();
    }

    public OMVRBTreeEntryPersistent(OMVRBTreeEntry<K, V> iParent, int iPosition) {
        super(((OMVRBTreeEntryPersistent)iParent).getTree());
        this.pTree = (OMVRBTreePersistent)this.tree;
        OMVRBTreeEntryPersistent pParent = (OMVRBTreeEntryPersistent)iParent;
        this.dataProvider = this.pTree.dataProvider.createEntry();
        this.dataProvider.setIdentityChangedListener(this);
        this.dataProvider.copyDataFrom(pParent.dataProvider, iPosition);
        if (pParent.dataProvider.truncate(iPosition)) {
            pParent.markDirty();
        }
        this.init();
        this.setParent(pParent);
        this.pTree.addNodeInMemory(this);
        this.markDirty();
    }

    public OMVRBTreeEntryDataProvider<K, V> getProvider() {
        return this.dataProvider;
    }

    public OMVRBTreeEntryPersistent<K, V> save() throws OSerializationException {
        if (!this.dataProvider.isEntryDirty()) {
            return this;
        }
        boolean isNew = this.dataProvider.getIdentity().isNew();
        if (this.left != null && this.left.dataProvider.getIdentity().isNew()) {
            if (isNew) {
                this.left.dataProvider.save();
            } else {
                this.left.save();
            }
        }
        if (this.right != null && this.right.dataProvider.getIdentity().isNew()) {
            if (isNew) {
                this.right.dataProvider.save();
            } else {
                this.right.save();
            }
        }
        if (this.parent != null && this.parent.dataProvider.getIdentity().isNew()) {
            if (isNew) {
                this.parent.dataProvider.save();
            } else {
                this.parent.save();
            }
        }
        this.dataProvider.save();
        this.checkEntryStructure();
        if (this.pTree.searchNodeInCache(this.dataProvider.getIdentity()) != this) {
            this.pTree.addNodeInMemory(this);
        }
        return this;
    }

    public OMVRBTreeEntryPersistent<K, V> delete() throws IOException {
        if (this.dataProvider != null) {
            this.pTree.removeNodeFromMemory(this);
            this.pTree.removeEntry(this.dataProvider.getIdentity());
            if (this.getLeft() != null) {
                ((OMVRBTreeEntryPersistent)this.getLeft()).delete();
            }
            if (this.getRight() != null) {
                ((OMVRBTreeEntryPersistent)this.getRight()).delete();
            }
            this.dataProvider.removeIdentityChangedListener(this);
            this.dataProvider.delete();
            this.clear();
        }
        return this;
    }

    protected int disconnect(boolean iForceDirty, int iLevel) {
        if (this.dataProvider == null) {
            return 1;
        }
        int totalDisconnected = 0;
        ORID rid = this.dataProvider.getIdentity();
        boolean disconnectedFromParent = false;
        if (this.parent != null) {
            if (this.canDisconnectFrom(this.parent) || iForceDirty) {
                if (this.parent.left == this) {
                    this.parent.left = null;
                } else if (this.parent.right == this) {
                    this.parent.right = null;
                } else {
                    OLogManager.instance().warn((Object)this, "Node " + rid + " has the parent (" + this.parent + ") unlinked to itself. It links to " + this.parent, new Object[0]);
                }
                totalDisconnected += this.parent.disconnect(iForceDirty, iLevel + 1);
                this.parent = null;
                disconnectedFromParent = true;
            }
        } else {
            disconnectedFromParent = true;
        }
        boolean disconnectedFromLeft = false;
        if (this.left != null) {
            if (this.canDisconnectFrom(this.left) || iForceDirty) {
                if (this.left.parent == this) {
                    this.left.parent = null;
                } else {
                    OLogManager.instance().warn((Object)this, "Node " + rid + " has the left (" + this.left + ") unlinked to itself. It links to " + this.left.parent, new Object[0]);
                }
                totalDisconnected += this.left.disconnect(iForceDirty, iLevel + 1);
                this.left = null;
                disconnectedFromLeft = true;
            }
        } else {
            disconnectedFromLeft = true;
        }
        boolean disconnectedFromRight = false;
        if (this.right != null) {
            if (this.canDisconnectFrom(this.right) || iForceDirty) {
                if (this.right.parent == this) {
                    this.right.parent = null;
                } else {
                    OLogManager.instance().warn((Object)this, "Node " + rid + " has the right (" + this.right + ") unlinked to itself. It links to " + this.right.parent, new Object[0]);
                }
                totalDisconnected += this.right.disconnect(iForceDirty, iLevel + 1);
                this.right = null;
                disconnectedFromRight = true;
            }
        } else {
            disconnectedFromLeft = true;
        }
        if (disconnectedFromParent && disconnectedFromLeft && disconnectedFromRight && (!this.dataProvider.isEntryDirty() && !this.dataProvider.getIdentity().isTemporary() || iForceDirty) && !this.pTree.isNodeEntryPoint(this)) {
            ++totalDisconnected;
            this.pTree.removeNodeFromMemory(this);
            this.clear();
        }
        return totalDisconnected;
    }

    private boolean canDisconnectFrom(OMVRBTreeEntryPersistent<K, V> entry) {
        return this.dataProvider == null || !this.dataProvider.getIdentity().isNew() && !entry.dataProvider.getIdentity().isNew();
    }

    protected void clear() {
        this.pTree = null;
        this.tree = null;
        this.dataProvider.removeIdentityChangedListener(this);
        this.dataProvider.clear();
        this.dataProvider = null;
    }

    protected int disconnectLinked(boolean iForce) {
        return this.disconnect(iForce, 0);
    }

    public int getDepthInMemory() {
        int level = 0;
        OMVRBTreeEntryPersistent<K, V> entry = this;
        while (entry.parent != null) {
            ++level;
            entry = entry.parent;
        }
        return level;
    }

    @Override
    public int getDepth() {
        int level = 0;
        OMVRBTreeEntryPersistent entry = this;
        while (entry.getParent() != null) {
            ++level;
            entry = (OMVRBTreeEntryPersistent)entry.getParent();
        }
        return level;
    }

    @Override
    public OMVRBTreeEntry<K, V> getParent() {
        if (this.dataProvider == null) {
            return null;
        }
        if (this.parent == null && this.dataProvider.getParent().isValid()) {
            this.parent = this.pTree.loadEntry(null, this.dataProvider.getParent());
            this.checkEntryStructure();
            if (this.parent != null) {
                if (this.parent.dataProvider.getLeft().isValid() && this.parent.dataProvider.getLeft().equals(this.dataProvider.getIdentity())) {
                    this.parent.left = this;
                } else if (this.parent.dataProvider.getRight().isValid() && this.parent.dataProvider.getRight().equals(this.dataProvider.getIdentity())) {
                    this.parent.right = this;
                } else {
                    OLogManager.instance().error((Object)this, "getParent: Cannot assign node %s to parent. Nodes parent-left=%s, parent-right=%s", this.dataProvider.getParent(), this.parent.dataProvider.getLeft(), this.parent.dataProvider.getRight());
                }
            }
        }
        return this.parent;
    }

    @Override
    public OMVRBTreeEntry<K, V> setParent(OMVRBTreeEntry<K, V> iParent) {
        if (iParent != this.parent) {
            OMVRBTreeEntryPersistent newParent = (OMVRBTreeEntryPersistent)iParent;
            ORecordId newParentId = iParent == null ? ORecordId.EMPTY_RECORD_ID : newParent.dataProvider.getIdentity();
            this.parent = newParent;
            if (this.dataProvider.setParent(newParentId)) {
                this.markDirty();
            }
            if (this.parent != null) {
                ORID thisRid = this.dataProvider.getIdentity();
                if (this.parent.left == this && !this.parent.dataProvider.getLeft().equals(thisRid) && this.parent.dataProvider.setLeft(thisRid)) {
                    this.parent.markDirty();
                }
                if (this.parent.left != this && this.parent.dataProvider.getLeft().isValid() && this.parent.dataProvider.getLeft().equals(thisRid)) {
                    this.parent.left = this;
                }
                if (this.parent.right == this && !this.parent.dataProvider.getRight().equals(thisRid) && this.parent.dataProvider.setRight(thisRid)) {
                    this.parent.markDirty();
                }
                if (this.parent.right != this && this.parent.dataProvider.getRight().isValid() && this.parent.dataProvider.getRight().equals(thisRid)) {
                    this.parent.right = this;
                }
            }
        }
        return iParent;
    }

    @Override
    public OMVRBTreeEntry<K, V> getLeft() {
        if (this.dataProvider == null) {
            return null;
        }
        if (this.left == null && this.dataProvider.getLeft().isValid()) {
            this.left = this.pTree.loadEntry(this, this.dataProvider.getLeft());
            this.checkEntryStructure();
        }
        return this.left;
    }

    @Override
    public void setLeft(OMVRBTreeEntry<K, V> iLeft) {
        if (iLeft != this.left) {
            OMVRBTreeEntryPersistent newLeft = (OMVRBTreeEntryPersistent)iLeft;
            ORecordId newLeftId = iLeft == null ? ORecordId.EMPTY_RECORD_ID : newLeft.dataProvider.getIdentity();
            this.left = newLeft;
            if (this.dataProvider.setLeft(newLeftId)) {
                this.markDirty();
            }
            if (this.left != null && this.left.parent != this) {
                this.left.setParent(this);
            }
            this.checkEntryStructure();
        }
    }

    @Override
    public OMVRBTreeEntry<K, V> getRight() {
        if (this.dataProvider == null) {
            return null;
        }
        if (this.right == null && this.dataProvider.getRight().isValid()) {
            this.right = this.pTree.loadEntry(this, this.dataProvider.getRight());
            this.checkEntryStructure();
        }
        return this.right;
    }

    @Override
    public void setRight(OMVRBTreeEntry<K, V> iRight) {
        if (iRight != this.right) {
            OMVRBTreeEntryPersistent newRight = (OMVRBTreeEntryPersistent)iRight;
            ORecordId newRightId = iRight == null ? ORecordId.EMPTY_RECORD_ID : newRight.dataProvider.getIdentity();
            this.right = newRight;
            if (this.dataProvider.setRight(newRightId)) {
                this.markDirty();
            }
            if (this.right != null && this.right.parent != this) {
                this.right.setParent(this);
            }
            this.checkEntryStructure();
        }
    }

    public void checkEntryStructure() {
        if (!this.tree.isRuntimeCheckEnabled()) {
            return;
        }
        if (this.dataProvider.getParent() == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has parentRid null!\n", this);
        }
        if (this.dataProvider.getLeft() == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has leftRid null!\n", this);
        }
        if (this.dataProvider.getRight() == null) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has rightRid null!\n", this);
        }
        if (this == this.left || this.dataProvider.getIdentity().isValid() && this.dataProvider.getIdentity().equals(this.dataProvider.getLeft())) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has left that points to itself!\n", this);
        }
        if (this == this.right || this.dataProvider.getIdentity().isValid() && this.dataProvider.getIdentity().equals(this.dataProvider.getRight())) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has right that points to itself!\n", this);
        }
        if (this.left != null && this.left == this.right) {
            OLogManager.instance().error((Object)this, "checkEntryStructure: Node %s has left and right equals!\n", this);
        }
        if (this.left != null) {
            if (!this.left.dataProvider.getIdentity().equals(this.dataProvider.getLeft())) {
                OLogManager.instance().error((Object)this, "checkEntryStructure: Wrong left node loaded: " + this.dataProvider.getLeft(), new Object[0]);
            }
            if (this.left.parent != this) {
                OLogManager.instance().error((Object)this, "checkEntryStructure: Left node is not correctly connected to the parent" + this.dataProvider.getLeft(), new Object[0]);
            }
        }
        if (this.right != null) {
            if (!this.right.dataProvider.getIdentity().equals(this.dataProvider.getRight())) {
                OLogManager.instance().error((Object)this, "checkEntryStructure: Wrong right node loaded: " + this.dataProvider.getRight(), new Object[0]);
            }
            if (this.right.parent != this) {
                OLogManager.instance().error((Object)this, "checkEntryStructure: Right node is not correctly connected to the parent" + this.dataProvider.getRight(), new Object[0]);
            }
        }
    }

    @Override
    protected void copyFrom(OMVRBTreeEntry<K, V> iSource) {
        if (this.dataProvider.copyFrom(((OMVRBTreeEntryPersistent)iSource).dataProvider)) {
            this.markDirty();
        }
    }

    @Override
    protected void insert(int iIndex, K iKey, V iValue) {
        Object oldKey;
        Object k = oldKey = iIndex == 0 ? (Object)this.dataProvider.getKeyAt(0) : null;
        if (this.dataProvider.insertAt(iIndex, iKey, iValue)) {
            this.markDirty();
        }
        if (iIndex == 0) {
            this.pTree.updateEntryPoint(oldKey, this);
        }
    }

    @Override
    protected void remove() {
        Object oldKey;
        int index = this.tree.getPageIndex();
        Object k = oldKey = index == 0 ? (Object)this.getKeyAt(0) : null;
        if (this.dataProvider.removeAt(index)) {
            this.markDirty();
        }
        this.tree.setPageIndex(index - 1);
        if (index == 0) {
            this.pTree.updateEntryPoint(oldKey, this);
        }
    }

    @Override
    public K getKeyAt(int iIndex) {
        return this.dataProvider.getKeyAt(iIndex);
    }

    @Override
    protected V getValueAt(int iIndex) {
        return this.dataProvider.getValueAt(iIndex);
    }

    @Override
    public V setValue(V iValue) {
        Object oldValue = this.getValue();
        int index = this.tree.getPageIndex();
        if (this.dataProvider.setValueAt(index, iValue)) {
            this.markDirty();
        }
        return oldValue;
    }

    @Override
    public int getSize() {
        return this.dataProvider != null ? this.dataProvider.getSize() : 0;
    }

    @Override
    public int getPageSize() {
        return this.dataProvider.getPageSize();
    }

    public int getMaxDepthInMemory() {
        return this.getMaxDepthInMemory(0);
    }

    private int getMaxDepthInMemory(int iCurrDepthLevel) {
        int rightDepth;
        int depth = this.left != null ? super.getMaxDepthInMemory(iCurrDepthLevel + 1) : iCurrDepthLevel;
        if (this.right != null && (rightDepth = super.getMaxDepthInMemory(iCurrDepthLevel + 1)) > depth) {
            depth = rightDepth;
        }
        return depth;
    }

    @Override
    public OMVRBTreeEntryPersistent<K, V> getNextInMemory() {
        OMVRBTreeEntryPersistent<K, V> t = this;
        OMVRBTreeEntryPersistent<K, V> p = null;
        if (t.right != null) {
            p = t.right;
            while (p.left != null) {
                p = p.left;
            }
        } else {
            p = t.parent;
            while (p != null && t == p.right) {
                t = p;
                p = p.parent;
            }
        }
        return p;
    }

    @Override
    public boolean getColor() {
        return this.dataProvider.getColor();
    }

    @Override
    protected void setColor(boolean iColor) {
        if (this.dataProvider.setColor(iColor)) {
            this.markDirty();
        }
    }

    public void markDirty() {
        this.pTree.signalNodeChanged(this);
    }

    @Override
    protected OMVRBTreeEntry<K, V> getLeftInMemory() {
        return this.left;
    }

    @Override
    protected OMVRBTreeEntry<K, V> getParentInMemory() {
        return this.parent;
    }

    @Override
    protected OMVRBTreeEntry<K, V> getRightInMemory() {
        return this.right;
    }

    @Override
    public void onIdentityChanged(ORID rid) {
        if (this.left != null && this.left.dataProvider.setParent(rid)) {
            this.left.markDirty();
        }
        if (this.right != null && this.right.dataProvider.setParent(rid)) {
            this.right.markDirty();
        }
        if (this.parent != null) {
            if (this.parent.left == this) {
                if (this.parent.dataProvider.setLeft(rid)) {
                    this.parent.markDirty();
                }
            } else if (this.parent.right == this) {
                if (this.parent.dataProvider.setRight(rid)) {
                    this.parent.markDirty();
                }
            } else {
                OLogManager.instance().error((Object)this, "[save]: Tree inconsistent entries.", new Object[0]);
            }
        } else if (this.pTree.getRoot() == this && this.pTree.dataProvider.setRoot(rid)) {
            this.pTree.markDirty();
        }
    }
}

