/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.ODataSegment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ODataSegmentMemory
extends OSharedResourceAdaptive
implements ODataSegment {
    private final String name;
    private final int id;
    private final List<byte[]> entries = new ArrayList<byte[]>();

    public ODataSegmentMemory(String iDataSegmentName, int iId) {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
        this.name = iDataSegmentName;
        this.id = iId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void drop() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count() {
        this.acquireSharedLock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (byte[] e : this.entries) {
                if (e == null) continue;
                size += (long)e.length;
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createRecord(byte[] iContent) {
        this.acquireExclusiveLock();
        try {
            this.entries.add(iContent);
            long l = this.entries.size() - 1;
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRecord(long iRecordPosition) {
        this.acquireExclusiveLock();
        try {
            this.entries.set((int)iRecordPosition, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readRecord(long iRecordPosition) {
        this.acquireSharedLock();
        try {
            byte[] byArray = this.entries.get((int)iRecordPosition);
            return byArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecord(long iRecordPosition, byte[] iContent) {
        this.acquireExclusiveLock();
        try {
            this.entries.set((int)iRecordPosition, iContent);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }
}

