/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterMemory
extends OSharedResourceAdaptive
implements OCluster {
    public static final String TYPE = "MEMORY";
    private OStorage storage;
    private int id;
    private String name;
    private int dataSegmentId;
    private List<OPhysicalPosition> entries = new ArrayList<OPhysicalPosition>();
    private List<OPhysicalPosition> removed = new ArrayList<OPhysicalPosition>();

    public OClusterMemory() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.configure(iStorage, iConfig.getId(), iConfig.getName(), iConfig.getLocation(), iConfig.getDataSegmentId(), new Object[0]);
    }

    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) {
        this.storage = iStorage;
        this.id = iId;
        this.name = iClusterName;
        this.dataSegmentId = iDataSegmentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataSegmentId() {
        int n;
        this.acquireSharedLock();
        try {
            n = this.dataSegmentId;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return n;
    }

    public OClusterPositionIterator absoluteIterator() {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void open() throws IOException {
    }

    public void create(int iStartSize) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.close();
            this.entries.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.name = stringValue;
                break;
            }
            case DATASEGMENT: {
                this.dataSegmentId = this.storage.getDataSegmentIdByName(stringValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntries() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() - this.removed.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordsSize() {
        long l;
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (OPhysicalPosition e : this.entries) {
                if (e == null) continue;
                size += (long)e.recordSize;
            }
            l = size;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstEntryPosition() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() == 0 ? -1L : 0L;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEntryPosition() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() - 1;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailablePosition() throws IOException {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicalPosition(OPhysicalPosition iPPosition) {
        this.acquireExclusiveLock();
        try {
            if (!this.removed.isEmpty()) {
                OPhysicalPosition recycledPosition = this.removed.remove(this.removed.size() - 1);
                iPPosition.clusterPosition = recycledPosition.clusterPosition;
                iPPosition.recordVersion = recycledPosition.recordVersion + 1;
                this.entries.set((int)recycledPosition.clusterPosition, iPPosition);
            } else {
                iPPosition.clusterPosition = this.allocateRecord(iPPosition);
                iPPosition.recordVersion = 0;
                this.entries.add(iPPosition);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    protected long allocateRecord(OPhysicalPosition iPPosition) {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).recordType = iRecordType;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersion(long iPosition, int iVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).recordVersion = iVersion;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) {
        OPhysicalPosition oPhysicalPosition;
        this.acquireSharedLock();
        try {
            oPhysicalPosition = this.entries.get((int)iPPosition.clusterPosition);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oPhysicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysicalPosition(long iPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            this.removed.add(ppos);
            this.entries.set((int)iPosition, null);
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataSegmentPosition(long iPosition, int iDataSegmentId, long iDataPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            ppos.dataSegmentId = iDataSegmentId;
            ppos.dataSegmentPos = iDataPosition;
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void synch() {
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public void lock() {
        this.acquireSharedLock();
    }

    public void unlock() {
        this.releaseSharedLock();
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return "OClusterMemory [name=" + this.name + ", id=" + this.id + ", entries=" + this.entries.size() + ", removed=" + this.removed + "]";
    }
}

