/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.fs.OFileFactory;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;

public class OSingleFileSegment {
    protected OStorageLocal storage;
    protected OFile file;
    protected OStorageFileConfiguration config;

    public OSingleFileSegment(String iPath, String iType) throws IOException {
        this.file = OFileFactory.instance().create(iType, OSystemVariableResolver.resolveSystemVariables(iPath), "rw");
    }

    public OSingleFileSegment(OStorageLocal iStorage, OStorageFileConfiguration iConfig) throws IOException {
        this(iStorage, iConfig, iConfig.type);
    }

    public OSingleFileSegment(OStorageLocal iStorage, OStorageFileConfiguration iConfig, String iType) throws IOException {
        this.config = iConfig;
        this.storage = iStorage;
        this.file = OFileFactory.instance().create(iType, iStorage.getVariableParser().resolveVariables(iConfig.path), iStorage.getMode());
        this.file.setMaxSize((int)OFileUtils.getSizeAsNumber(iConfig.maxSize));
        this.file.setIncrementSize((int)OFileUtils.getSizeAsNumber(iConfig.incrementSize));
    }

    public boolean open() throws IOException {
        boolean softClosed = this.file.open();
        if (!softClosed) {
            OLogManager.instance().warn((Object)this, "segment file '%s' was not closed correctly last time", OFileUtils.getPath(this.file.getName()));
        }
        return softClosed;
    }

    public void create(int iStartSize) throws IOException {
        this.file.create(iStartSize);
    }

    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public void delete() throws IOException {
        if (this.file != null) {
            this.file.delete();
        }
    }

    public void truncate() throws IOException {
        this.file.shrink(0);
    }

    public boolean exists() {
        return this.file.exists();
    }

    public long getSize() {
        return this.file.getFileSize();
    }

    public long getFilledUpTo() {
        return this.file.getFilledUpTo();
    }

    public OStorageFileConfiguration getConfig() {
        return this.config;
    }

    public OFile getFile() {
        return this.file;
    }

    public void synch() throws IOException {
        this.file.synch();
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.file.setSoftlyClosed(softlyClosed);
    }
}

