/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataHoleConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocalHole;
import com.orientechnologies.orient.core.storage.impl.local.OMultiFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODataLocal
extends OMultiFileSegment
implements ODataSegment {
    static final String DEF_EXTENSION = ".oda";
    public static final int RECORD_FIX_SIZE = 14;
    protected final int id;
    protected final ODataLocalHole holeSegment;
    protected int defragMaxHoleDistance;
    protected int defragStrategy;
    protected long defStartSize;
    private final String PROFILER_HOLE_FIND_CLOSER;
    private final String PROFILER_UPDATE_REUSED_ALL;
    private final String PROFILER_UPDATE_REUSED_PARTIAL;
    private final String PROFILER_UPDATE_NOT_REUSED;
    private final String PROFILER_MOVE_RECORD;
    private final String PROFILER_HOLE_HANDLE;
    private final OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);

    public ODataLocal(OStorageLocal iStorage, OStorageDataConfiguration iConfig, int iId) throws IOException {
        super(iStorage, iConfig, DEF_EXTENSION, 0);
        this.id = iId;
        OFileUtils.checkValidName(iConfig.name);
        iConfig.holeFile = new OStorageDataHoleConfiguration(iConfig, iConfig.getLocation() + "/" + this.name, iConfig.fileType, iConfig.maxSize);
        this.holeSegment = new ODataLocalHole(iStorage, iConfig.holeFile);
        this.defStartSize = OFileUtils.getSizeAsNumber(iConfig.fileStartSize);
        this.defragMaxHoleDistance = OGlobalConfiguration.FILE_DEFRAG_HOLE_MAX_DISTANCE.getValueAsInteger();
        this.defragStrategy = OGlobalConfiguration.FILE_DEFRAG_STRATEGY.getValueAsInteger();
        this.PROFILER_HOLE_HANDLE = "db." + this.storage.getName() + ".data.handleHole";
        this.PROFILER_HOLE_FIND_CLOSER = "db." + this.storage.getName() + ".data.findClosestHole";
        this.PROFILER_UPDATE_REUSED_ALL = "db." + this.storage.getName() + ".data.update.reusedAll";
        this.PROFILER_UPDATE_REUSED_PARTIAL = "db." + this.storage.getName() + ".data.update.reusedPartial";
        this.PROFILER_UPDATE_NOT_REUSED = "db." + this.storage.getName() + ".data.update.notReused";
        this.PROFILER_MOVE_RECORD = "db." + this.storage.getName() + ".data.move";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.open();
            this.holeSegment.open();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(int iStartSize) throws IOException {
        this.acquireExclusiveLock();
        try {
            super.create((int)(iStartSize > -1 ? (long)iStartSize : this.defStartSize));
            this.holeSegment.create(-1);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.close();
            super.delete();
            this.holeSegment.delete();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.close();
            this.holeSegment.close();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synch() throws IOException {
        this.acquireSharedLock();
        try {
            this.holeSegment.synch();
            super.synch();
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.holeSegment.setSoftlyClosed(softlyClosed);
            super.setSoftlyClosed(softlyClosed);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.acquireSharedLock();
        try {
            long l = super.getFilledUpTo();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addRecord(ORecordId iRid, byte[] iContent) throws IOException {
        if (iContent.length == 0) {
            return -1L;
        }
        int recordSize = iContent.length + 14;
        this.acquireExclusiveLock();
        try {
            long[] newFilePosition = this.getFreeSpace(recordSize);
            this.writeRecord(newFilePosition, iRid.clusterId, iRid.clusterPosition, iContent);
            long l = this.getAbsolutePosition(newFilePosition);
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRecord(long iPosition) throws IOException {
        if (iPosition == -1L) {
            return null;
        }
        this.acquireSharedLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            int recordSize = file.readInt(pos[1]);
            if (recordSize <= 0) {
                byte[] byArray = null;
                return byArray;
            }
            if (pos[1] + 14L + (long)recordSize > (long)file.getFilledUpTo()) {
                throw new OStorageException("Error on reading record from file '" + file.getName() + "', position " + iPosition + ", size " + OFileUtils.getSizeAsString(recordSize) + ": the record size is bigger then the file itself (" + OFileUtils.getSizeAsString(this.getFilledUpTo()) + "). Probably the record is dirty due to a previous crash. It is strongly suggested to restore the database or export and reimport this one.");
            }
            byte[] content = new byte[recordSize];
            file.read(pos[1] + 14L, content, recordSize);
            byte[] byArray = content;
            return byArray;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecordSize(long iPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            int n = file.readInt(pos[1]);
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ORecordId getRecordRid(long iPosition) throws IOException {
        this.acquireSharedLock();
        try {
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            ORecordId oRecordId = new ORecordId(file.readShort(pos[1] + 4L), file.readLong(pos[1] + 4L + 2L));
            return oRecordId;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long setRecord(long iPosition, ORecordId iRid, byte[] iContent) throws IOException {
        this.acquireExclusiveLock();
        try {
            int contentLength;
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            int recordSize = file.readInt(pos[1]);
            int n = contentLength = iContent != null ? iContent.length : 0;
            if (contentLength == recordSize) {
                file.write(pos[1] + 14L, iContent);
                OProfiler.getInstance().updateCounter(this.PROFILER_UPDATE_REUSED_ALL, 1L);
                long l = iPosition;
                return l;
            }
            if (recordSize - contentLength > 64) {
                this.writeRecord(pos, iRid.clusterId, iRid.clusterPosition, iContent);
                this.handleHole(iPosition + 14L + (long)contentLength, recordSize - contentLength - 14);
                OProfiler.getInstance().updateCounter(this.PROFILER_UPDATE_REUSED_PARTIAL, 1L);
            } else {
                this.handleHole(iPosition, recordSize);
                pos = this.getFreeSpace(contentLength + 14);
                this.writeRecord(pos, iRid.clusterId, iRid.clusterPosition, iContent);
                OProfiler.getInstance().updateCounter(this.PROFILER_UPDATE_NOT_REUSED, 1L);
            }
            long l = this.getAbsolutePosition(pos);
            return l;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteRecord(long iPosition) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (iPosition == -1L) {
                int n = 0;
                return n;
            }
            long[] pos = this.getRelativePosition(iPosition);
            OFile file = this.files[(int)pos[0]];
            int recordSize = file.readInt(pos[1]);
            this.handleHole(iPosition, recordSize);
            int n = recordSize;
            return n;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoles() {
        this.acquireSharedLock();
        try {
            long l = this.holeSegment.getHoles();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ODataHoleInfo> getHolesList() {
        this.acquireSharedLock();
        try {
            ArrayList<ODataHoleInfo> holes = new ArrayList<ODataHoleInfo>();
            int tot = this.holeSegment.getHoles();
            for (int i = 0; i < tot; ++i) {
                ODataHoleInfo h = this.holeSegment.getHole(i);
                if (h == null) continue;
                holes.add(h);
            }
            ArrayList<ODataHoleInfo> arrayList = holes;
            return arrayList;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    private void handleHole(long iRecordOffset, int iRecordSize) throws IOException {
        long holePositionOffset = iRecordOffset;
        int holeSize = iRecordSize + 14;
        long timer = OProfiler.getInstance().startChrono();
        long[] pos = this.getRelativePosition(iRecordOffset);
        OFile file = this.files[(int)pos[0]];
        ODataHoleInfo closestHole = this.getCloserHole(iRecordOffset, iRecordSize, file, pos);
        OProfiler.getInstance().stopChrono(this.PROFILER_HOLE_FIND_CLOSER, timer);
        if (closestHole == null) {
            this.holeSegment.createHole(iRecordOffset, holeSize);
        } else if (closestHole.dataOffset + (long)closestHole.size == iRecordOffset) {
            this.holeSegment.updateHole(closestHole, closestHole.dataOffset, holeSize += closestHole.size);
            holePositionOffset = closestHole.dataOffset;
        } else if (holePositionOffset + (long)holeSize == closestHole.dataOffset) {
            this.holeSegment.updateHole(closestHole, holePositionOffset, holeSize += closestHole.size);
        } else {
            long closestHoleOffset = iRecordOffset > closestHole.dataOffset ? closestHole.dataOffset + (long)closestHole.size - iRecordOffset : closestHole.dataOffset - (iRecordOffset + (long)iRecordSize);
            if (closestHoleOffset < 0L) {
                int recordContentSize;
                long moveFrom;
                int recordSize;
                closestHoleOffset *= -1L;
                long offsetLimit = iRecordOffset;
                ArrayList<long[]> segmentPositions = new ArrayList<long[]>();
                for (moveFrom = closestHole.dataOffset + (long)closestHole.size; moveFrom < offsetLimit && (pos = this.getRelativePosition(moveFrom))[1] < (long)file.getFilledUpTo() && (recordContentSize = file.readInt(pos[1])) >= 0; moveFrom += (long)recordSize) {
                    recordSize = recordContentSize + 14;
                    segmentPositions.add(0, new long[]{moveFrom, recordSize});
                }
                long gap = offsetLimit + (long)holeSize;
                for (long[] item : segmentPositions) {
                    int sizeMoved = this.moveRecord(item[0], gap - item[1]);
                    if (sizeMoved < 0) {
                        throw new IllegalStateException("Cannot move record at position " + moveFrom + ": found hole");
                    }
                    if ((long)sizeMoved != item[1]) {
                        throw new IllegalStateException("Corrupted hole at position " + item[0] + ": found size " + sizeMoved + " instead of " + item[1]);
                    }
                    gap -= (long)sizeMoved;
                }
                holePositionOffset = closestHole.dataOffset;
                holeSize += closestHole.size;
            } else {
                long moveFrom = iRecordOffset + (long)holeSize;
                long moveTo = iRecordOffset;
                long moveUpTo = closestHole.dataOffset;
                while (moveFrom < moveUpTo) {
                    int sizeMoved = this.moveRecord(moveFrom, moveTo);
                    if (sizeMoved < 0) {
                        throw new IllegalStateException("Cannot move record at position " + moveFrom + ": found hole");
                    }
                    moveFrom += (long)sizeMoved;
                    moveTo += (long)sizeMoved;
                }
                if (moveFrom != moveUpTo) {
                    throw new IllegalStateException("Corrupted holes: found offset " + moveFrom + " instead of " + moveUpTo + " while creating a new hole on position " + iRecordOffset + ", size " + iRecordSize + ". The closest hole " + closestHole.holeOffset + " points to position " + closestHole.dataOffset + ", size " + closestHole.size);
                }
                holePositionOffset = moveTo;
                holeSize += closestHole.size;
            }
            this.holeSegment.updateHole(closestHole, holePositionOffset, holeSize);
        }
        pos = this.getRelativePosition(holePositionOffset);
        this.files[(int)pos[0]].writeInt(pos[1], holeSize * -1);
        OProfiler.getInstance().stopChrono(this.PROFILER_HOLE_HANDLE, timer);
    }

    private ODataHoleInfo getCloserHole(long iRecordOffset, int iRecordSize, OFile file, long[] pos) {
        long[] fileRanges;
        int defragHoleDistance;
        if (this.holeSegment.getHoles() == 0) {
            return null;
        }
        if (this.defragMaxHoleDistance > 0) {
            defragHoleDistance = this.defragMaxHoleDistance;
        } else {
            long size = this.getSize();
            defragHoleDistance = Math.max(32768 * (int)(size / 10000000L), 32768);
        }
        if (pos[0] == 0L) {
            fileRanges = new long[]{0L, file.getFilledUpTo()};
        } else {
            long size = (long)this.files[0].getFileSize() * pos[0];
            fileRanges = new long[]{size, size + (long)file.getFilledUpTo()};
        }
        return this.holeSegment.getCloserHole(iRecordOffset, iRecordSize, Math.max(iRecordOffset - (long)defragHoleDistance, fileRanges[0]), Math.min(iRecordOffset + (long)iRecordSize + (long)defragHoleDistance, fileRanges[1]));
    }

    private int moveRecord(long iSourcePosition, long iDestinationPosition) throws IOException {
        long[] pos = this.getRelativePosition(iSourcePosition);
        OFile file = this.files[(int)pos[0]];
        int recordSize = file.readInt(pos[1]);
        if (recordSize < 0) {
            return -1;
        }
        long timer = OProfiler.getInstance().startChrono();
        short clusterId = file.readShort(pos[1] + 4L);
        long clusterPosition = file.readLong(pos[1] + 4L + 2L);
        byte[] content = new byte[recordSize];
        file.read(pos[1] + 14L, content, recordSize);
        if (clusterId > -1) {
            OCluster cluster = this.storage.getClusterById(clusterId);
            OPhysicalPosition ppos = cluster.getPhysicalPosition(new OPhysicalPosition(clusterPosition));
            if (ppos.dataSegmentPos != iSourcePosition) {
                OLogManager.instance().warn((Object)this, "Found corrupted record hole for rid %d:%d: data position is wrong: %d <-> %d. Auto fixed by writing position %d", clusterId, clusterPosition, ppos.dataSegmentPos, iSourcePosition, iDestinationPosition);
            }
            cluster.updateDataSegmentPosition(clusterPosition, this.id, iDestinationPosition);
        }
        this.writeRecord(this.getRelativePosition(iDestinationPosition), clusterId, clusterPosition, content);
        OProfiler.getInstance().stopChrono(this.PROFILER_MOVE_RECORD, timer);
        return recordSize + 14;
    }

    private void writeRecord(long[] iFilePosition, int iClusterSegment, long iClusterPosition, byte[] iContent) throws IOException {
        OFile file = this.files[(int)iFilePosition[0]];
        file.writeInt(iFilePosition[1], iContent != null ? iContent.length : 0);
        file.writeShort(iFilePosition[1] + 4L, (short)iClusterSegment);
        file.writeLong(iFilePosition[1] + 4L + 2L, iClusterPosition);
        file.write(iFilePosition[1] + 14L, iContent);
    }

    private long[] getFreeSpace(int recordSize) throws IOException {
        long position = this.holeSegment.popFirstAvailableHole(recordSize);
        long[] newFilePosition = position > -1L ? this.getRelativePosition(position) : this.allocateSpace(recordSize);
        return newFilePosition;
    }

    public void acquireExclusiveLock() {
        this.lock.acquireExclusiveLock();
    }

    public void releaseExclusiveLock() {
        this.lock.releaseExclusiveLock();
    }

    public void acquireSharedLock() {
        this.lock.acquireSharedLock();
    }

    public void releaseSharedLock() {
        this.lock.releaseSharedLock();
    }
}

