/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerAbstract;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMMapManagerOld
extends OMMapManagerAbstract
implements OMMapManager {
    private static final long MIN_MEMORY = 50000000L;
    private static OVERLAP_STRATEGY overlapStrategy;
    private static OMMapManager.ALLOC_STRATEGY lastStrategy;
    private static int blockSize;
    private static long maxMemory;
    private static long totalMemory;
    private static final ReadWriteLock lock;
    private static List<OMMapBufferEntry> bufferPoolLRU;
    private static Map<OFileMMap, List<OMMapBufferEntry>> bufferPoolPerFile;

    OMMapManagerOld() {
    }

    @Override
    public void init() {
        blockSize = OGlobalConfiguration.FILE_MMAP_BLOCK_SIZE.getValueAsInteger();
        maxMemory = OGlobalConfiguration.FILE_MMAP_MAX_MEMORY.getValueAsLong();
        OMMapManagerOld.setOverlapStrategy(OGlobalConfiguration.FILE_MMAP_OVERLAP_STRATEGY.getValueAsInteger());
        OProfiler.getInstance().registerHookValue("system.file.mmap.totalMemory", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return totalMemory;
            }
        });
        OProfiler.getInstance().registerHookValue("system.file.mmap.maxMemory", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return maxMemory;
            }
        });
        OProfiler.getInstance().registerHookValue("system.file.mmap.blockSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return blockSize;
            }
        });
        OProfiler.getInstance().registerHookValue("system.file.mmap.blocks", new OProfiler.OProfilerHookValue(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                lock.readLock().lock();
                try {
                    Integer n = bufferPoolLRU.size();
                    Object var3_2 = null;
                    lock.readLock().unlock();
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    lock.readLock().unlock();
                    throw throwable;
                }
            }
        });
        OProfiler.getInstance().registerHookValue("system.file.mmap.alloc.strategy", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return lastStrategy;
            }
        });
        OProfiler.getInstance().registerHookValue("system.file.mmap.overlap.strategy", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return overlapStrategy;
            }
        });
    }

    @Override
    public OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        return this.acquire(iFile, iBeginOffset, iSize, false, iOperationType, iStrategy);
    }

    /*
     * Exception decompiling
     */
    private OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 19[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void freeResources() {
        long memoryThreshold = (long)((double)maxMemory * 0.75);
        long startingMemory = totalMemory;
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug(null, "Freeing off-heap memory as mmmap blocks, target is %s...", OFileUtils.getSizeAsString(startingMemory - memoryThreshold));
        }
        Collections.sort(bufferPoolLRU, new Comparator<OMMapBufferEntry>(){

            @Override
            public int compare(OMMapBufferEntry o1, OMMapBufferEntry o2) {
                return (int)(o1.counter - o2.counter);
            }
        });
        Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
        while (it.hasNext()) {
            OMMapBufferEntry entry = it.next();
            if (OMMapManagerOld.removeEntry(entry)) {
                it.remove();
            }
            if (totalMemory >= memoryThreshold) continue;
            break;
        }
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug(null, "Freed off-heap memory as mmmap blocks for %s...", OFileUtils.getSizeAsString(startingMemory - totalMemory));
        }
    }

    private static OMMapBufferEntry searchBetweenLastBlocks(OFileMMap iFile, long iBeginOffset, int iSize) {
        if (!bufferPoolLRU.isEmpty()) {
            int min = Math.max(bufferPoolLRU.size() - 5, -1);
            for (int i = bufferPoolLRU.size() - 1; i > min; --i) {
                OMMapBufferEntry e = bufferPoolLRU.get(i);
                if (!e.isValid() || e.file != iFile || iBeginOffset < e.beginOffset || iBeginOffset + (long)iSize > e.beginOffset + (long)e.size) continue;
                OProfiler.getInstance().updateCounter("OMMapManager.reusedPageBetweenLast", 1L);
                ++e.counter;
                return e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        lock.writeLock().lock();
        try {
            Iterator<OMMapBufferEntry> it = bufferPoolLRU.iterator();
            while (it.hasNext()) {
                OMMapBufferEntry entry = it.next();
                if (entry.file == null || !entry.file.isClosed() || !OMMapManagerOld.removeEntry(entry)) continue;
                it.remove();
            }
            Object var4_3 = null;
            lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean removeEntry(OMMapBufferEntry entry) {
        if (!entry.flush()) {
            return false;
        }
        entry.acquireWriteLock();
        try {
            List<OMMapBufferEntry> file = bufferPoolPerFile.get(entry.file);
            if (file != null) {
                file.remove(entry);
                if (file.isEmpty()) {
                    bufferPoolPerFile.remove(entry.file);
                }
            }
            entry.close();
            totalMemory -= (long)entry.size;
            boolean bl = true;
            Object var4_3 = null;
            entry.releaseWriteLock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            entry.releaseWriteLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFile(OFileMMap iFile) {
        lock.writeLock().lock();
        try {
            List<OMMapBufferEntry> entries = bufferPoolPerFile.remove(iFile);
            if (entries != null) {
                for (OMMapBufferEntry entry : entries) {
                    bufferPoolLRU.remove(entry);
                    OMMapManagerOld.removeEntry(entry);
                }
            }
            Object var6_5 = null;
            lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushFile(OFileMMap iFile) {
        lock.readLock().lock();
        try {
            List<OMMapBufferEntry> entries = bufferPoolPerFile.get(iFile);
            if (entries != null) {
                for (OMMapBufferEntry entry : entries) {
                    entry.flush();
                }
            }
            Object var6_5 = null;
            lock.readLock().unlock();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        lock.writeLock().lock();
        try {
            for (OMMapBufferEntry entry : new ArrayList<OMMapBufferEntry>(bufferPoolLRU)) {
                OMMapManagerOld.removeEntry(entry);
            }
            bufferPoolLRU.clear();
            bufferPoolPerFile.clear();
            totalMemory = 0L;
            Object var4_3 = null;
            lock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.writeLock().unlock();
            throw throwable;
        }
    }

    public long getMaxMemory() {
        return maxMemory;
    }

    public static void setMaxMemory(long iMaxMemory) {
        maxMemory = iMaxMemory;
    }

    public long getTotalMemory() {
        return totalMemory;
    }

    public int getBlockSize() {
        return blockSize;
    }

    public static void setBlockSize(int blockSize) {
        OMMapManagerOld.blockSize = blockSize;
    }

    public OVERLAP_STRATEGY getOverlapStrategy() {
        return overlapStrategy;
    }

    public static void setOverlapStrategy(int overlapStrategy) {
        OMMapManagerOld.overlapStrategy = OVERLAP_STRATEGY.values()[overlapStrategy];
    }

    public void setOverlapStrategy(OVERLAP_STRATEGY overlapStrategy) {
        OMMapManagerOld.overlapStrategy = overlapStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOverlappedBlocks() {
        lock.readLock().lock();
        try {
            int count = 0;
            for (OFileMMap f : bufferPoolPerFile.keySet()) {
                count += this.getOverlappedBlocks(f);
            }
            int n = count;
            Object var5_5 = null;
            lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getOverlappedBlocks(OFileMMap iFile) {
        lock.readLock().lock();
        try {
            int count = 0;
            List<OMMapBufferEntry> blocks = bufferPoolPerFile.get(iFile);
            long lastPos = -1L;
            for (OMMapBufferEntry block : blocks) {
                if (lastPos > -1L && lastPos > block.beginOffset) {
                    OLogManager.instance().warn(null, "Found overlapped block for file %s at position %d. Previous offset+size was %d", iFile, block.beginOffset, lastPos);
                    ++count;
                }
                lastPos = block.beginOffset + (long)block.size;
            }
            int n = count;
            Object var9_8 = null;
            lock.readLock().unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            lock.readLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OMMapBufferEntry mapBuffer(OFileMMap iFile, long iBeginOffset, int iSize) throws IOException {
        OMMapBufferEntry oMMapBufferEntry;
        long timer = OProfiler.getInstance().startChrono();
        try {
            oMMapBufferEntry = new OMMapBufferEntry(iFile, iFile.map(iBeginOffset, iSize), iBeginOffset, iSize);
            Object var8_5 = null;
            OProfiler.getInstance().stopChrono("OMMapManager.loadPage", timer);
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            OProfiler.getInstance().stopChrono("OMMapManager.loadPage", timer);
            throw throwable;
        }
        return oMMapBufferEntry;
    }

    private static int searchEntry(List<OMMapBufferEntry> fileEntries, long iBeginOffset, int iSize) {
        if (fileEntries == null || fileEntries.size() == 0) {
            return -1;
        }
        int high = fileEntries.size() - 1;
        if (high < 0) {
            return -1;
        }
        int low = 0;
        int mid = -1;
        while (low <= high) {
            mid = low + high >>> 1;
            OMMapBufferEntry e = fileEntries.get(mid);
            if (iBeginOffset >= e.beginOffset && iBeginOffset + (long)iSize <= e.beginOffset + (long)e.size) {
                OProfiler.getInstance().updateCounter("OMMapManager.reusedPage", 1L);
                ++e.counter;
                return mid;
            }
            if (low == high) {
                if (iBeginOffset > e.beginOffset) {
                    ++low;
                }
                return (low + 2) * -1;
            }
            if (iBeginOffset >= e.beginOffset) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        return mid;
    }

    private static boolean allocIfOverlaps(long iBeginOffset, int iSize, List<OMMapBufferEntry> fileEntries, int p) {
        if (overlapStrategy == OVERLAP_STRATEGY.OVERLAP) {
            return true;
        }
        boolean overlaps = false;
        OMMapBufferEntry entry = null;
        if (p > 0) {
            entry = fileEntries.get(p - 1);
            boolean bl = overlaps = entry.beginOffset <= iBeginOffset && entry.beginOffset + (long)entry.size >= iBeginOffset;
        }
        if (!overlaps && p < fileEntries.size() - 1) {
            entry = fileEntries.get(p);
            boolean bl = overlaps = iBeginOffset + (long)iSize >= entry.beginOffset;
        }
        if (overlaps) {
            OProfiler.getInstance().updateCounter("system.file.mmap.overlappedPageUsingChannel", 1L);
            if (overlapStrategy == OVERLAP_STRATEGY.NO_OVERLAP_FLUSH_AND_USE_CHANNEL) {
                entry.flush();
            }
            return false;
        }
        return true;
    }

    private static int computeBestEntrySize(OFileMMap iFile, long iBeginOffset, int iSize, boolean iForce, List<OMMapBufferEntry> fileEntries, int p) {
        int bufferSize;
        if (p > -1 && p < fileEntries.size()) {
            bufferSize = (int)(fileEntries.get((int)p).beginOffset - iBeginOffset);
            if (bufferSize < iSize) {
                bufferSize = iSize;
            }
            if (bufferSize < blockSize) {
                bufferSize = blockSize;
            }
        } else {
            int n = iForce ? iSize : (bufferSize = iSize < blockSize ? blockSize : iSize);
            if (iBeginOffset + (long)bufferSize > (long)iFile.getFileSize()) {
                bufferSize = (int)((long)iFile.getFileSize() - iBeginOffset);
            }
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Invalid range requested for file " + iFile + ". Requested " + iSize + " bytes from the address " + iBeginOffset + " while the total file size is " + iFile.getFileSize());
        }
        return bufferSize;
    }

    static {
        lock = new ReentrantReadWriteLock();
        bufferPoolLRU = new ArrayList<OMMapBufferEntry>();
        bufferPoolPerFile = new HashMap<OFileMMap, List<OMMapBufferEntry>>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OVERLAP_STRATEGY {
        NO_OVERLAP_USE_CHANNEL,
        NO_OVERLAP_FLUSH_AND_USE_CHANNEL,
        OVERLAP;

    }
}

