/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import com.orientechnologies.orient.core.storage.fs.OMMapBufferEntry;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerAbstract;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class OMMapManagerNew
extends OMMapManagerAbstract
implements OMMapManager {
    private static final int BINARY_SEARCH_THRESHOLD = 10;
    private static final OMMapBufferEntry[] EMPTY_BUFFER_ENTRIES = new OMMapBufferEntry[0];
    private final ConcurrentHashMap<OFileMMap, OMMapBufferEntry[]> bufferPoolPerFile = new ConcurrentHashMap();
    private final ConcurrentHashMap<OFileMMap, LastMMapEntrySearchInfo> mapEntrySearchInfo = new ConcurrentHashMap();
    private final OLockManager<OFileMMap, Runnable> lockManager = new OLockManager(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger());

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OMMapBufferEntry[] acquire(OFileMMap iFile, long iBeginOffset, int iSize, OMMapManager.OPERATION_TYPE iOperationType, OMMapManager.ALLOC_STRATEGY iStrategy) {
        OMMapBufferEntry newMappedEntry;
        OMMapBufferEntry[] foundEntries;
        if (iStrategy == OMMapManager.ALLOC_STRATEGY.MMAP_NEVER) {
            return null;
        }
        OMMapBufferEntry[] fileEntries = this.bufferPoolPerFile.get(iFile);
        if (fileEntries == null) {
            fileEntries = EMPTY_BUFFER_ENTRIES;
            this.bufferPoolPerFile.putIfAbsent(iFile, fileEntries);
        }
        if ((foundEntries = this.searchAmongExisting(iFile, fileEntries, iBeginOffset, iSize)).length > 0) {
            OMMapBufferEntry lastEntry = foundEntries[foundEntries.length - 1];
            if (lastEntry.beginOffset + (long)lastEntry.size >= iBeginOffset + (long)iSize) {
                this.acquireLocksOnEntries(foundEntries, iOperationType);
                return foundEntries;
            }
        }
        this.lockManager.acquireLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
        try {
            fileEntries = this.bufferPoolPerFile.get(iFile);
            foundEntries = this.searchAmongExisting(iFile, fileEntries, iBeginOffset, iSize);
            long totalMappedSize = 0L;
            if (fileEntries.length > 0) {
                OMMapBufferEntry lastEntry = fileEntries[fileEntries.length - 1];
                totalMappedSize = lastEntry.beginOffset + (long)lastEntry.size;
            }
            try {
                newMappedEntry = this.mapNew(iFile, totalMappedSize);
            }
            catch (IOException ex) {
                OMMapBufferEntry[] oMMapBufferEntryArray = null;
                Object var16_14 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
                return oMMapBufferEntryArray;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
            throw throwable;
        }
        OMMapBufferEntry[] newEntries = this.addEntry(fileEntries, newMappedEntry);
        this.bufferPoolPerFile.put(iFile, newEntries);
        OMMapBufferEntry[] resultEntries = this.addEntry(foundEntries, newMappedEntry);
        this.acquireLocksOnEntries(resultEntries, iOperationType);
        OMMapBufferEntry[] oMMapBufferEntryArray = resultEntries;
        Object var16_15 = null;
        this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
        return oMMapBufferEntryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Iterator<Map.Entry<OFileMMap, OMMapBufferEntry[]>> it = this.bufferPoolPerFile.entrySet().iterator();
        while (it.hasNext()) {
            Object var10_9;
            Map.Entry<OFileMMap, OMMapBufferEntry[]> mapEntry = it.next();
            OFileMMap file = mapEntry.getKey();
            this.lockManager.acquireLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
            try {
                if (file.isClosed()) {
                    OMMapBufferEntry[] notFlushed = EMPTY_BUFFER_ENTRIES;
                    for (OMMapBufferEntry entry : mapEntry.getValue()) {
                        if (this.removeEntry(entry)) continue;
                        notFlushed = this.addEntry(notFlushed, entry);
                    }
                    if (notFlushed.length == 0) {
                        it.remove();
                    } else {
                        mapEntry.setValue(notFlushed);
                    }
                }
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                this.lockManager.releaseLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
                throw throwable;
            }
            this.lockManager.releaseLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (Map.Entry<OFileMMap, OMMapBufferEntry[]> entries : this.bufferPoolPerFile.entrySet()) {
            Object var5_4;
            OFileMMap file = entries.getKey();
            this.lockManager.acquireLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
            try {
                this.removeFileEntries(entries.getValue());
                var5_4 = null;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.lockManager.releaseLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
                throw throwable;
            }
            this.lockManager.releaseLock(Thread.currentThread(), file, OLockManager.LOCK.EXCLUSIVE);
            {
            }
        }
        this.bufferPoolPerFile.clear();
        this.mapEntrySearchInfo.clear();
    }

    private OMMapBufferEntry[] searchAmongExisting(OFileMMap file, OMMapBufferEntry[] fileEntries, long beginOffset, int size) {
        int endSearchPosition;
        int beginSearchPosition;
        if (fileEntries.length == 0) {
            return EMPTY_BUFFER_ENTRIES;
        }
        OMMapBufferEntry lastEntry = fileEntries[fileEntries.length - 1];
        if (lastEntry.beginOffset + (long)lastEntry.size <= beginOffset) {
            return EMPTY_BUFFER_ENTRIES;
        }
        LastMMapEntrySearchInfo entrySearchInfo = this.mapEntrySearchInfo.get(file);
        if (entrySearchInfo == null) {
            beginSearchPosition = 0;
            endSearchPosition = fileEntries.length - 1;
        } else if (entrySearchInfo.requestedPosition <= beginOffset) {
            beginSearchPosition = entrySearchInfo.foundMmapIndex;
            endSearchPosition = fileEntries.length - 1;
        } else {
            beginSearchPosition = 0;
            endSearchPosition = entrySearchInfo.foundMmapIndex;
        }
        int resultFirstPosition = endSearchPosition - beginSearchPosition > 10 ? this.binarySearch(fileEntries, beginOffset, beginSearchPosition, endSearchPosition) : this.linearSearch(fileEntries, beginOffset, beginSearchPosition, endSearchPosition);
        if (beginSearchPosition < 0) {
            return EMPTY_BUFFER_ENTRIES;
        }
        int resultLastPosition = fileEntries.length - 1;
        for (int i = resultFirstPosition; i <= resultLastPosition; ++i) {
            OMMapBufferEntry entry = fileEntries[i];
            if (entry.beginOffset + (long)entry.size < beginOffset + (long)size) continue;
            resultLastPosition = i;
            break;
        }
        int length = resultLastPosition - resultFirstPosition + 1;
        OMMapBufferEntry[] foundEntries = new OMMapBufferEntry[length];
        if (length > 0) {
            System.arraycopy(fileEntries, resultFirstPosition, foundEntries, 0, length);
            this.mapEntrySearchInfo.put(file, new LastMMapEntrySearchInfo(resultFirstPosition, beginOffset));
        }
        return foundEntries;
    }

    private int binarySearch(OMMapBufferEntry[] fileEntries, long beginOffset, int beginPosition, int endPosition) {
        while (beginPosition <= endPosition) {
            int midPosition = beginPosition + endPosition >>> 1;
            OMMapBufferEntry entry = fileEntries[midPosition];
            if (entry.beginOffset + (long)entry.size > beginOffset && entry.beginOffset <= beginOffset) {
                return midPosition;
            }
            if (beginPosition == endPosition) {
                return -1;
            }
            if (beginOffset > entry.beginOffset) {
                beginPosition = midPosition + 1;
                continue;
            }
            endPosition = midPosition;
        }
        return -1;
    }

    private int linearSearch(OMMapBufferEntry[] fileEntries, long beginOffset, int beginPosition, int endPosition) {
        for (int i = beginPosition; i <= endPosition; ++i) {
            OMMapBufferEntry entry = fileEntries[i];
            if (entry.beginOffset + (long)entry.size <= beginOffset || entry.beginOffset > beginOffset) continue;
            return i;
        }
        return -1;
    }

    private OMMapBufferEntry mapNew(OFileMMap file, long beginOffset) throws IOException {
        return new OMMapBufferEntry(file, file.map(beginOffset, file.getFileSize() - (int)beginOffset), beginOffset, file.getFileSize() - (int)beginOffset);
    }

    private OMMapBufferEntry[] addEntry(OMMapBufferEntry[] sourceEntries, OMMapBufferEntry newEntry) {
        OMMapBufferEntry[] newEntries = new OMMapBufferEntry[sourceEntries.length + 1];
        System.arraycopy(sourceEntries, 0, newEntries, 0, sourceEntries.length);
        newEntries[sourceEntries.length] = newEntry;
        return newEntries;
    }

    private void acquireLocksOnEntries(OMMapBufferEntry[] entries, OMMapManager.OPERATION_TYPE operationType) {
        if (operationType == OMMapManager.OPERATION_TYPE.WRITE) {
            for (OMMapBufferEntry entry : entries) {
                entry.acquireWriteLock();
                entry.setDirty();
            }
        } else {
            for (OMMapBufferEntry entry : entries) {
                entry.acquireReadLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(OFileMMap iFile) {
        this.lockManager.acquireLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
        try {
            this.mapEntrySearchInfo.remove(iFile);
            OMMapBufferEntry[] entries = this.bufferPoolPerFile.remove(iFile);
            this.removeFileEntries(entries);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
            throw throwable;
        }
        this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.EXCLUSIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeEntry(OMMapBufferEntry entry) {
        entry.acquireWriteLock();
        try {
            entry.close();
            Object var3_2 = null;
            entry.releaseWriteLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            entry.releaseWriteLock();
            throw throwable;
        }
    }

    private void removeFileEntries(OMMapBufferEntry[] fileEntries) {
        if (fileEntries != null) {
            for (OMMapBufferEntry entry : fileEntries) {
                this.removeEntry(entry);
            }
        }
    }

    private boolean removeEntry(OMMapBufferEntry entry) {
        if (!entry.flush()) {
            return false;
        }
        this.closeEntry(entry);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushFile(OFileMMap iFile) {
        this.lockManager.acquireLock(Thread.currentThread(), iFile, OLockManager.LOCK.SHARED);
        try {
            OMMapBufferEntry[] fileEntries = this.bufferPoolPerFile.get(iFile);
            if (fileEntries != null) {
                for (OMMapBufferEntry entry : fileEntries) {
                    entry.flush();
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.SHARED);
            throw throwable;
        }
        this.lockManager.releaseLock(Thread.currentThread(), iFile, OLockManager.LOCK.SHARED);
    }

    private static final class LastMMapEntrySearchInfo {
        private final int foundMmapIndex;
        private final long requestedPosition;

        private LastMMapEntrySearchInfo(int foundMmapIndex, long requestedPosition) {
            this.foundMmapIndex = foundMmapIndex;
            this.requestedPosition = requestedPosition;
        }
    }
}

