/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerAbstract;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerNew;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerOld;
import java.util.concurrent.atomic.AtomicReference;

public class OMMapManagerLocator {
    private static final AtomicReference<OMMapManager> instanceRef = new AtomicReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMMapManager getInstance() {
        if (instanceRef.get() == null) {
            AtomicReference<OMMapManager> atomicReference = instanceRef;
            synchronized (atomicReference) {
                if (instanceRef.compareAndSet(null, OMMapManagerLocator.createInstance())) {
                    instanceRef.get().init();
                }
            }
        }
        return instanceRef.get();
    }

    private static OMMapManager createInstance() {
        OMMapManagerAbstract localInstance;
        if (OGlobalConfiguration.FILE_MMAP_USE_OLD_MANAGER.getValueAsBoolean()) {
            OLogManager.instance().config(null, "[OMMapManagerLocator.createInstance] Using old mmap manager!", new Object[0]);
            localInstance = new OMMapManagerOld();
        } else {
            OLogManager.instance().config(null, "[OMMapManagerLocator.createInstance] Using new mmap manager!", new Object[0]);
            localInstance = new OMMapManagerNew();
        }
        return localInstance;
    }
}

